/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.session;

import java.util.Set;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.application.api.ui.TranslationKeyField;
import org.teamapps.application.api.ui.UiComponentFactory;
import org.teamapps.application.server.system.bootstrap.BaseResourceLinkProvider;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.ui.localize.LocalizationTranslationKeyField;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.localize.TranslatableField;
import org.teamapps.application.ux.org.OrganizationViewUtils;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.OrganizationUnitTypeView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class SessionUiComponentFactory
implements UiComponentFactory {
    private final ApplicationInstanceData applicationInstanceData;
    private final BaseResourceLinkProvider baseResourceLinkProvider;
    private final Application application;

    public SessionUiComponentFactory(ApplicationInstanceData applicationInstanceData, BaseResourceLinkProvider baseResourceLinkProvider, Application application) {
        this.applicationInstanceData = applicationInstanceData;
        this.baseResourceLinkProvider = baseResourceLinkProvider;
        this.application = application;
    }

    public ComboBox<OrganizationUnitView> createOrganizationUnitComboBox(Set<OrganizationUnitView> allowedUnits) {
        return OrganizationViewUtils.createOrganizationComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, allowedUnits, (ApplicationInstanceData)this.applicationInstanceData);
    }

    public TagComboBox<OrganizationUnitTypeView> createOrganizationUnitTypeTagComboBox() {
        return OrganizationViewUtils.createOrganizationUnitTypeTagComboBox((int)150, (ApplicationInstanceData)this.applicationInstanceData);
    }

    public TemplateField<OrganizationUnitView> createOrganizationUnitTemplateField() {
        return UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, (PropertyProvider)OrganizationViewUtils.creatOrganizationUnitViewPropertyProvider((ApplicationInstanceData)this.applicationInstanceData));
    }

    public TemplateField<Integer> createUserTemplateField() {
        return UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createUserIdPropertyProvider(this.applicationInstanceData));
    }

    public TranslatableField createTranslatableField() {
        return new TranslatableField(this.applicationInstanceData);
    }

    public TranslationKeyField createTranslationKeyField(String linkButtonCaption) {
        return new LocalizationTranslationKeyField(linkButtonCaption, this.applicationInstanceData, () -> this.application);
    }

    public FormMetaFields createFormMetaFields() {
        return null;
    }

    public String createUserAvatarLink(int userId, boolean large) {
        return this.baseResourceLinkProvider.getUserProfilePictureLink(userId, large);
    }
}

