/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.ui.localize;

import java.util.function.Supplier;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.ui.TranslationKeyField;
import org.teamapps.application.server.system.localization.SystemLocalizationProvider;
import org.teamapps.application.server.ui.localize.LocalizationKeyWindow;
import org.teamapps.application.server.ui.localize.LocalizationUiUtils;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.linkbutton.LinkButton;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class LocalizationTranslationKeyField
implements TranslationKeyField {
    private final ComboBox<String> localizationKeyCombo;
    private final TextField keyTextField;
    private final LinkButton linkButton;

    public LocalizationTranslationKeyField(String linkButtonCaption, ApplicationInstanceData applicationInstanceData, Supplier<Application> applicationSupplier) {
        this(linkButtonCaption, applicationInstanceData, applicationSupplier, null);
    }

    public LocalizationTranslationKeyField(String linkButtonCaption, ApplicationInstanceData applicationInstanceData, SystemLocalizationProvider systemLocalizationProvider) {
        this(linkButtonCaption, applicationInstanceData, null, systemLocalizationProvider);
    }

    private LocalizationTranslationKeyField(String linkButtonCaption, ApplicationInstanceData applicationInstanceData, Supplier<Application> applicationSupplier, SystemLocalizationProvider systemLocalizationProvider) {
        this.localizationKeyCombo = LocalizationUiUtils.createLocalizationKeyCombo((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, (ApplicationLocalizationProvider)applicationInstanceData, applicationSupplier);
        this.localizationKeyCombo.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        this.localizationKeyCombo.setShowClearButton(true);
        this.keyTextField = new TextField();
        this.keyTextField.setEditingMode(FieldEditingMode.READONLY);
        this.linkButton = new LinkButton(linkButtonCaption);
        this.localizationKeyCombo.onValueChanged.addListener(arg_0 -> ((TextField)this.keyTextField).setValue(arg_0));
        LocalizationKeyWindow localizationKeyWindow = applicationSupplier != null ? LocalizationKeyWindow.createApplicationKey(applicationSupplier.get(), applicationInstanceData) : LocalizationKeyWindow.createSystemKey(systemLocalizationProvider, applicationInstanceData);
        this.linkButton.onClicked.addListener(() -> {
            localizationKeyWindow.onNewKey.addListener(arg_0 -> this.localizationKeyCombo.setValue(arg_0));
            localizationKeyWindow.onNewKey.addListener(arg_0 -> ((TextField)this.keyTextField).setValue(arg_0));
            localizationKeyWindow.show();
        });
    }

    public AbstractField<String> getSelectionField() {
        return this.localizationKeyCombo;
    }

    public AbstractField<String> getKeyDisplayField() {
        return this.keyTextField;
    }

    public LinkButton getKeyLinkButton() {
        return this.linkButton;
    }

    public void setKey(String key) {
        this.localizationKeyCombo.setValue((Object)key);
        this.keyTextField.setValue((Object)key);
    }

    public String getKey() {
        return (String)this.localizationKeyCombo.getValue();
    }
}

