/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.ui.localize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class LocalizationUiUtils {
    public static ComboBox<String> createLocalizationKeyCombo(Template template, ApplicationLocalizationProvider localizationProvider) {
        return LocalizationUiUtils.createLocalizationKeyCombo(template, localizationProvider, null);
    }

    public static ComboBox<String> createLocalizationKeyCombo(Template template, ApplicationLocalizationProvider localizationProvider, Supplier<Application> applicationSupplier) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setPropertyProvider((s, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            LocalizationKey localizationKey = LocalizationKey.filter().key(TextFilter.textEqualsFilter((String)s)).executeExpectSingleton();
            map.put("icon", LocalizationUiUtils.getLocalizationKeyIcon(localizationKey));
            map.put("caption", localizationProvider.getLocalized(localizationKey.getKey(), new Object[0]));
            map.put("description", localizationKey.getKey());
            return map;
        });
        comboBox.setRecordToStringFunction(x$0 -> localizationProvider.getLocalized(x$0, new Object[0]));
        comboBox.setModel(query -> {
            ArrayList<Object> keys = new ArrayList<Object>();
            keys.addAll(applicationSupplier != null && applicationSupplier.get() != null ? LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)((Application)applicationSupplier.get()).getId())).execute() : Collections.emptyList());
            keys.addAll(LocalizationKey.filter().localizationKeyType(EnumFilterType.EQUALS, LocalizationKeyType.DICTIONARY_KEY).execute());
            keys.addAll(LocalizationKey.filter().localizationKeyType(EnumFilterType.EQUALS, LocalizationKeyType.SYSTEM_KEY).execute());
            if (query == null || query.isBlank()) {
                return keys.stream().limit(150L).map(LocalizationKey::getKey).collect(Collectors.toList());
            }
            String q = query.toLowerCase();
            return keys.stream().filter(key -> key.getKey().toLowerCase().contains(q) || localizationProvider.getLocalized(key.getKey(), new Object[0]).toLowerCase().contains(q)).limit(150L).map(LocalizationKey::getKey).collect(Collectors.toList());
        });
        comboBox.setTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        return comboBox;
    }

    public static Icon getLocalizationKeyIcon(LocalizationKey key) {
        return switch (key.getLocalizationKeyType()) {
            case LocalizationKeyType.APPLICATION_RESOURCE_KEY -> IconUtils.decodeIcon((String)key.getApplication().getIcon());
            case LocalizationKeyType.DICTIONARY_KEY -> ApplicationIcons.DICTIONARY;
            case LocalizationKeyType.REPORTING_KEY -> ApplicationIcons.DOCUMENT_NOTEBOOK;
            case LocalizationKeyType.SYSTEM_KEY -> ApplicationIcons.SYSTEM;
            default -> null;
        };
    }
}

