/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationGroup;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;

public class UdbManagedApplication
extends AbstractUdbEntity<ManagedApplication>
implements ManagedApplication {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static SingleReferenceIndex mainApplication;
    protected static SingleReferenceIndex organizationField;
    protected static TextIndex icon;
    protected static TextIndex titleKey;
    protected static TextIndex descriptionKey;
    protected static BooleanIndex singleApplication;
    protected static BooleanIndex darkTheme;
    protected static MultiReferenceIndex perspectives;
    protected static IntegerIndex listingPosition;
    protected static BooleanIndex toolbarApplicationMenu;
    protected static SingleReferenceIndex applicationGroup;
    protected static BooleanIndex hidden;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        mainApplication = (SingleReferenceIndex)tableIndex.getColumnIndex("mainApplication");
        organizationField = (SingleReferenceIndex)tableIndex.getColumnIndex("organizationField");
        icon = (TextIndex)tableIndex.getColumnIndex("icon");
        titleKey = (TextIndex)tableIndex.getColumnIndex("titleKey");
        descriptionKey = (TextIndex)tableIndex.getColumnIndex("descriptionKey");
        singleApplication = (BooleanIndex)tableIndex.getColumnIndex("singleApplication");
        darkTheme = (BooleanIndex)tableIndex.getColumnIndex("darkTheme");
        perspectives = (MultiReferenceIndex)tableIndex.getColumnIndex("perspectives");
        listingPosition = (IntegerIndex)tableIndex.getColumnIndex("listingPosition");
        toolbarApplicationMenu = (BooleanIndex)tableIndex.getColumnIndex("toolbarApplicationMenu");
        applicationGroup = (SingleReferenceIndex)tableIndex.getColumnIndex("applicationGroup");
        hidden = (BooleanIndex)tableIndex.getColumnIndex("hidden");
    }

    public static List<ManagedApplication> getAll() {
        return new EntityBitSetList(ManagedApplication.getBuilder(), table.getRecordBitSet());
    }

    public static List<ManagedApplication> sort(List<ManagedApplication> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbManagedApplication.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<ManagedApplication> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbManagedApplication.sort((TableIndex)table, ManagedApplication.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbManagedApplication() {
        super(table);
    }

    public UdbManagedApplication(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public ManagedApplication build() {
        return new UdbManagedApplication();
    }

    public ManagedApplication build(int id) {
        return new UdbManagedApplication(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public ManagedApplication setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public ManagedApplication setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public ManagedApplication setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public ManagedApplication setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public ManagedApplication setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public ManagedApplication setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public ManagedApplication setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public ManagedApplication setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public ManagedApplication setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public ManagedApplication setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public ManagedApplication setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public ManagedApplication setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public Application getMainApplication() {
        if (this.isChanged((ColumnIndex)mainApplication)) {
            return (Application)this.getReferenceChangeValue((ColumnIndex)mainApplication);
        }
        int id = mainApplication.getValue(this.getId());
        if (id > 0) {
            return Application.getById(id);
        }
        return null;
    }

    @Override
    public ManagedApplication setMainApplication(Application value) {
        this.setSingleReferenceValue((ColumnIndex)mainApplication, value, table);
        return this;
    }

    @Override
    public OrganizationField getOrganizationField() {
        if (this.isChanged((ColumnIndex)organizationField)) {
            return (OrganizationField)this.getReferenceChangeValue((ColumnIndex)organizationField);
        }
        int id = organizationField.getValue(this.getId());
        if (id > 0) {
            return OrganizationField.getById(id);
        }
        return null;
    }

    @Override
    public ManagedApplication setOrganizationField(OrganizationField value) {
        this.setSingleReferenceValue((ColumnIndex)organizationField, value, table);
        return this;
    }

    @Override
    public String getIcon() {
        return this.getTextValue(icon);
    }

    @Override
    public ManagedApplication setIcon(String value) {
        this.setTextValue(value, icon);
        return this;
    }

    @Override
    public String getTitleKey() {
        return this.getTextValue(titleKey);
    }

    @Override
    public ManagedApplication setTitleKey(String value) {
        this.setTextValue(value, titleKey);
        return this;
    }

    @Override
    public String getDescriptionKey() {
        return this.getTextValue(descriptionKey);
    }

    @Override
    public ManagedApplication setDescriptionKey(String value) {
        this.setTextValue(value, descriptionKey);
        return this;
    }

    @Override
    public boolean getSingleApplication() {
        return this.getBooleanValue(singleApplication);
    }

    @Override
    public ManagedApplication setSingleApplication(boolean value) {
        this.setBooleanValue(value, singleApplication);
        return this;
    }

    @Override
    public boolean isSingleApplication() {
        return this.getBooleanValue(singleApplication);
    }

    @Override
    public boolean getDarkTheme() {
        return this.getBooleanValue(darkTheme);
    }

    @Override
    public ManagedApplication setDarkTheme(boolean value) {
        this.setBooleanValue(value, darkTheme);
        return this;
    }

    @Override
    public boolean isDarkTheme() {
        return this.getBooleanValue(darkTheme);
    }

    @Override
    public List<ManagedApplicationPerspective> getPerspectives() {
        return this.getMultiReferenceValue(perspectives, ManagedApplicationPerspective.getBuilder());
    }

    @Override
    public ManagedApplication setPerspectives(List<ManagedApplicationPerspective> value) {
        this.setMultiReferenceValue(value, perspectives);
        return this;
    }

    @Override
    public int getPerspectivesCount() {
        return this.getMultiReferenceValueCount(perspectives, ManagedApplicationPerspective.getBuilder());
    }

    @Override
    public ManagedApplication setPerspectives(ManagedApplicationPerspective ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), perspectives);
        return this;
    }

    @Override
    public BitSet getPerspectivesAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(perspectives, ManagedApplicationPerspective.getBuilder());
    }

    @Override
    public ManagedApplication addPerspectives(List<ManagedApplicationPerspective> value) {
        this.addMultiReferenceValue(value, perspectives);
        return this;
    }

    @Override
    public ManagedApplication addPerspectives(ManagedApplicationPerspective ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), perspectives);
        return this;
    }

    @Override
    public ManagedApplication removePerspectives(List<ManagedApplicationPerspective> value) {
        this.removeMultiReferenceValue(value, perspectives);
        return this;
    }

    @Override
    public ManagedApplication removePerspectives(ManagedApplicationPerspective ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), perspectives);
        return this;
    }

    @Override
    public ManagedApplication removeAllPerspectives() {
        this.removeAllMultiReferenceValue(perspectives);
        return this;
    }

    @Override
    public int getListingPosition() {
        return this.getIntValue(listingPosition);
    }

    @Override
    public ManagedApplication setListingPosition(int value) {
        this.setIntValue(value, listingPosition);
        return this;
    }

    @Override
    public boolean getToolbarApplicationMenu() {
        return this.getBooleanValue(toolbarApplicationMenu);
    }

    @Override
    public ManagedApplication setToolbarApplicationMenu(boolean value) {
        this.setBooleanValue(value, toolbarApplicationMenu);
        return this;
    }

    @Override
    public boolean isToolbarApplicationMenu() {
        return this.getBooleanValue(toolbarApplicationMenu);
    }

    @Override
    public ManagedApplicationGroup getApplicationGroup() {
        if (this.isChanged((ColumnIndex)applicationGroup)) {
            return (ManagedApplicationGroup)this.getReferenceChangeValue((ColumnIndex)applicationGroup);
        }
        int id = applicationGroup.getValue(this.getId());
        if (id > 0) {
            return ManagedApplicationGroup.getById(id);
        }
        return null;
    }

    @Override
    public ManagedApplication setApplicationGroup(ManagedApplicationGroup value) {
        this.setSingleReferenceValue((ColumnIndex)applicationGroup, value, table);
        return this;
    }

    @Override
    public boolean getHidden() {
        return this.getBooleanValue(hidden);
    }

    @Override
    public ManagedApplication setHidden(boolean value) {
        this.setBooleanValue(value, hidden);
        return this;
    }

    @Override
    public boolean isHidden() {
        return this.getBooleanValue(hidden);
    }

    public UdbManagedApplication save(Transaction transaction, boolean strictChangeVerification) {
        this.save(transaction, table, strictChangeVerification);
        return this;
    }

    public UdbManagedApplication saveTransactional(boolean strictChangeVerification) {
        this.save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    public UdbManagedApplication save() {
        this.save(table);
        return this;
    }

    public void delete(Transaction transaction) {
        this.delete(transaction, table);
    }

    public void delete() {
        this.delete(table);
    }
}

