package org.teamapps.protocol.system;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class LoginData extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<LoginData> decoder = new PojoObjectDecoder<LoginData>() {
		@Override
		public LoginData decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new LoginData(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating LoginData instance", e);
			}
			return null;
		}

		@Override
		public LoginData decode(Element element, FileDataReader fileDataReader) {
			return new LoginData(element, fileDataReader);
		}

        @Override
        public LoginData decode(String xml, FileDataReader fileDataReader) {
            try {
                return new LoginData(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating LoginData instance", e);
            }
            return null;
        }

		@Override
		public LoginData defaultMessage() {
			return (LoginData) new LoginData().setDefaultValues(ApplicationServerProtocol.MODEL_COLLECTION);
		}

		@Override
		public LoginData remap(MessageRecord message) {
			return new LoginData(message, ApplicationServerProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<LoginData> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ApplicationServerProtocol.MODEL_COLLECTION;
	}

    public static LoginData remap(MessageRecord message) {
        return new LoginData(message, ApplicationServerProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "#t.l";


	public LoginData() {
		super(ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public LoginData(MessageRecord message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public LoginData(DataInputStream dis) throws IOException {
		super(dis, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public LoginData(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public LoginData(byte[] bytes) throws IOException {
		super(bytes, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public LoginData(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public LoginData(Element element, FileDataReader fileDataReader) {
		super(element, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ApplicationServerProtocol.MODEL_COLLECTION);
	}

    public LoginData(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ApplicationServerProtocol.MODEL_COLLECTION);
    }

	public int getLoginId() {
		return getIntAttribute("loginId");
	}

	public LoginData setLoginId(int value) {
		setIntAttribute("loginId", value);
		return this;
	}

	public int getUserId() {
		return getIntAttribute("userId");
	}

	public LoginData setUserId(int value) {
		setIntAttribute("userId", value);
		return this;
	}

	public String getIp() {
		return getStringAttribute("ip");
	}

	public LoginData setIp(String value) {
		setStringAttribute("ip", value);
		return this;
	}

	public String getUserAgent() {
		return getStringAttribute("userAgent");
	}

	public LoginData setUserAgent(String value) {
		setStringAttribute("userAgent", value);
		return this;
	}

	public boolean isMobileDevice() {
		return getBooleanAttribute("mobileDevice");
	}

	public LoginData setMobileDevice(boolean value) {
		setBooleanAttribute("mobileDevice", value);
		return this;
	}

	public int getScreenWidth() {
		return getIntAttribute("screenWidth");
	}

	public LoginData setScreenWidth(int value) {
		setIntAttribute("screenWidth", value);
		return this;
	}

	public int getScreenHeight() {
		return getIntAttribute("screenHeight");
	}

	public LoginData setScreenHeight(int value) {
		setIntAttribute("screenHeight", value);
		return this;
	}

	public int getLoginTimestamp() {
		return getIntAttribute("loginTimestamp");
	}

	public LoginData setLoginTimestamp(int value) {
		setIntAttribute("loginTimestamp", value);
		return this;
	}

	public int getLogoutTimestamp() {
		return getIntAttribute("logoutTimestamp");
	}

	public LoginData setLogoutTimestamp(int value) {
		setIntAttribute("logoutTimestamp", value);
		return this;
	}

	public int getOpenApplicationsCount() {
		return getIntAttribute("openApplicationsCount");
	}

	public LoginData setOpenApplicationsCount(int value) {
		setIntAttribute("openApplicationsCount", value);
		return this;
	}

	public int getOpenPerspectivesCount() {
		return getIntAttribute("openPerspectivesCount");
	}

	public LoginData setOpenPerspectivesCount(int value) {
		setIntAttribute("openPerspectivesCount", value);
		return this;
	}

	public int getActivityCount() {
		return getIntAttribute("activityCount");
	}

	public LoginData setActivityCount(int value) {
		setIntAttribute("activityCount", value);
		return this;
	}

	public long getSentBytesToClient() {
		return getLongAttribute("sentBytesToClient");
	}

	public LoginData setSentBytesToClient(long value) {
		setLongAttribute("sentBytesToClient", value);
		return this;
	}

	public long getReceivedBytesFromClient() {
		return getLongAttribute("receivedBytesFromClient");
	}

	public LoginData setReceivedBytesFromClient(long value) {
		setLongAttribute("receivedBytesFromClient", value);
		return this;
	}



}