/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.teamapps.application.server.ByteArrayResourceProvider;
import org.teamapps.application.server.LastModifiedProvider;
import org.teamapps.ux.resource.ByteArrayResource;
import org.teamapps.ux.resource.Resource;

public class SecureLinkBuilder {
    private final String linkPrefix;
    private final String fileSuffix;
    private final ByteArrayResourceProvider byteArrayResourceProvider;
    private final LastModifiedProvider lastModifiedProvider;
    private final Map<String, Long> idByKey = new ConcurrentHashMap<String, Long>();
    private final Map<Long, String> keyById = new ConcurrentHashMap<Long, String>();

    public SecureLinkBuilder(String linkPrefix, String fileSuffix, ByteArrayResourceProvider byteArrayResourceProvider, LastModifiedProvider lastModifiedProvider) {
        this.linkPrefix = linkPrefix;
        this.fileSuffix = fileSuffix;
        this.byteArrayResourceProvider = byteArrayResourceProvider;
        this.lastModifiedProvider = lastModifiedProvider;
    }

    public String createLink(int entityId) {
        long id = (long)entityId + this.lastModifiedProvider.getLastModified(entityId) / 1000L * 100000000L;
        String key = this.keyById.get(id);
        if (key != null) {
            return this.linkPrefix + "/" + key;
        }
        if (this.byteArrayResourceProvider.getResource(entityId) == null) {
            return null;
        }
        String uuid = UUID.randomUUID().toString();
        this.idByKey.put(uuid, id);
        this.keyById.put(id, uuid);
        return this.linkPrefix + "/" + uuid;
    }

    public Resource getResource(String key) {
        if (this.idByKey.containsKey(key)) {
            long value = this.idByKey.get(key);
            int id = (int)(value % 100000000L);
            return new ByteArrayResource(this.byteArrayResourceProvider.getResource(id), key + "." + this.fileSuffix).lastModified(new Date(this.lastModifiedProvider.getLastModified(id))).expiring(new Date(System.currentTimeMillis() + 7776000000L));
        }
        return null;
    }
}

