package org.teamapps.model;

import org.teamapps.universaldb.schema.*;

public class ControlCenterSchema implements SchemaInfoProvider {

	public static Schema create() {
		return new ControlCenterSchema().getSchema();
	}

	public Schema getSchema() {
		return Schema.parse(getSchemaDefinition());
	}

    public String getSchemaDefinition() {
        return "org.teamapps.model as SCHEMA\n" + 
				"controlCenter as DATABASE\n" + 
				"	language as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		isoCode as TEXT\n" + 
				"		icon as TEXT\n" + 
				"		englishDisplayName as TEXT\n" + 
				"		nonLatinScript as BOOLEAN\n" + 
				"		rightToLeftLanguage as BOOLEAN\n" + 
				"		localizationKey as SINGLE_REFERENCE controlCenter.localizationKey BACKREF NONE\n" + 
				"	country as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		isoCode as TEXT\n" + 
				"		icon as TEXT\n" + 
				"		englishDisplayName as TEXT\n" + 
				"		localizationKey as SINGLE_REFERENCE controlCenter.localizationKey BACKREF NONE\n" + 
				"		addressFormat as TEXT\n" + 
				"		mainLanguage as SINGLE_REFERENCE controlCenter.language BACKREF NONE\n" + 
				"		otherLanguages as MULTI_REFERENCE controlCenter.language BACKREF NONE\n" + 
				"		currency as SINGLE_REFERENCE controlCenter.currency BACKREF NONE\n" + 
				"		otherCurrencies as MULTI_REFERENCE controlCenter.currency BACKREF NONE\n" + 
				"	currency as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"	login as TABLE (KEEP_DELETED)\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		user as SINGLE_REFERENCE controlCenter.user BACKREF NONE\n" + 
				"		ip as TEXT\n" + 
				"		userAgent as TEXT\n" + 
				"		mobileDevice as BOOLEAN\n" + 
				"		screenSize as TEXT\n" + 
				"		dateLogin as TIMESTAMP\n" + 
				"		dateLogout as TIMESTAMP\n" + 
				"		activityCount as INT\n" + 
				"		applicationOpenCount as INT\n" + 
				"	user as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		firstName as TEXT\n" + 
				"		lastName as TEXT\n" + 
				"		profilePicture as BINARY\n" + 
				"		profilePictureLarge as BINARY\n" + 
				"		languages as TEXT\n" + 
				"		email as TEXT\n" + 
				"		mobile as TEXT\n" + 
				"		phone as TEXT\n" + 
				"		login as TEXT\n" + 
				"		lastLogin as TIMESTAMP\n" + 
				"		password as TEXT\n" + 
				"		theme as TEXT\n" + 
				"		userAccountStatus as ENUM VALUES (active, inactive, superAdmin)\n" + 
				"		acceptedPolicies as SINGLE_REFERENCE controlCenter.userAcceptedPolicy BACKREF NONE\n" + 
				"		address as SINGLE_REFERENCE controlCenter.address BACKREF NONE\n" + 
				"		organizationUnit as SINGLE_REFERENCE controlCenter.organizationUnit BACKREF users\n" + 
				"		accessTokens as MULTI_REFERENCE controlCenter.userAccessToken BACKREF user\n" + 
				"		roleAssignments as MULTI_REFERENCE controlCenter.userRoleAssignment BACKREF user\n" + 
				"		allGroupMemberships as MULTI_REFERENCE controlCenter.userGroupMembership BACKREF user\n" + 
				"		privateMessages as MULTI_REFERENCE controlCenter.message BACKREF privateRecipients\n" + 
				"	userAcceptedPolicy as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		lastAcceptedPrivacyPolicy as INT\n" + 
				"		lastAcceptedTermsOfUse as INT\n" + 
				"		acceptEntries as MULTI_REFERENCE controlCenter.userAcceptedPolicyEntries BACKREF NONE\n" + 
				"	userAcceptedPolicyEntries as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		acceptedPrivacyPolicy as INT\n" + 
				"		acceptedTermsOfUse as INT\n" + 
				"	userAccessToken as TABLE (TRACK_CREATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		user as SINGLE_REFERENCE controlCenter.user BACKREF accessTokens\n" + 
				"		userAgentOnCreation as TEXT\n" + 
				"		userAgentLastUsed as TEXT\n" + 
				"		lastUsed as TIMESTAMP\n" + 
				"		valid as BOOLEAN\n" + 
				"		restApi as BOOLEAN\n" + 
				"		secureToken as TEXT\n" + 
				"	organizationUnit as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		parent as SINGLE_REFERENCE controlCenter.organizationUnit BACKREF children\n" + 
				"		children as MULTI_REFERENCE controlCenter.organizationUnit BACKREF parent\n" + 
				"		type as SINGLE_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"		icon as TEXT\n" + 
				"		address as SINGLE_REFERENCE controlCenter.address BACKREF NONE\n" + 
				"		users as MULTI_REFERENCE controlCenter.user BACKREF organizationUnit\n" + 
				"	organizationUnitType as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		abbreviation as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"		translateOrganizationUnits as BOOLEAN\n" + 
				"		allowUsers as BOOLEAN\n" + 
				"		defaultChildType as SINGLE_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"		possibleChildrenTypes as MULTI_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"		geoLocationType as ENUM VALUES (country, state, city, place, none)\n" + 
				"	organizationField as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		title as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"	address as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TEXT\n" + 
				"		organisation as TEXT\n" + 
				"		street as TEXT\n" + 
				"		city as TEXT\n" + 
				"		dependentLocality as TEXT\n" + 
				"		state as TEXT\n" + 
				"		postalCode as TEXT\n" + 
				"		country as TEXT\n" + 
				"		latitude as FLOAT\n" + 
				"		longitude as FLOAT\n" + 
				"	organizationUnitView as VIEW REFERENCING controlCenter.organizationUnit\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		parent as SINGLE_REFERENCE controlCenter.organizationUnitView BACKREF children\n" + 
				"		children as MULTI_REFERENCE controlCenter.organizationUnitView BACKREF parent\n" + 
				"		type as SINGLE_REFERENCE controlCenter.organizationUnitTypeView BACKREF NONE\n" + 
				"		icon as TEXT\n" + 
				"		address as SINGLE_REFERENCE controlCenter.addressView BACKREF NONE\n" + 
				"	organizationUnitTypeView as VIEW REFERENCING controlCenter.organizationUnitType\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		abbreviation as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"		translateOrganizationUnits as BOOLEAN\n" + 
				"		allowUserContainer as BOOLEAN\n" + 
				"		defaultChildType as SINGLE_REFERENCE controlCenter.organizationUnitTypeView BACKREF NONE\n" + 
				"		possibleChildrenTypes as MULTI_REFERENCE controlCenter.organizationUnitTypeView BACKREF NONE\n" + 
				"		geoLocationType as ENUM VALUES (country, state, city, place, none)\n" + 
				"	organizationFieldView as VIEW REFERENCING controlCenter.organizationField\n" + 
				"		title as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"	addressView as VIEW REFERENCING controlCenter.address\n" + 
				"		name as TEXT\n" + 
				"		organisation as TEXT\n" + 
				"		street as TEXT\n" + 
				"		city as TEXT\n" + 
				"		dependentLocality as TEXT\n" + 
				"		state as TEXT\n" + 
				"		postalCode as TEXT\n" + 
				"		country as TEXT\n" + 
				"		latitude as FLOAT\n" + 
				"		longitude as FLOAT\n" + 
				"	role as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		title as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"		parent as SINGLE_REFERENCE controlCenter.role BACKREF children\n" + 
				"		children as MULTI_REFERENCE controlCenter.role BACKREF parent\n" + 
				"		allowedOrganizationUnitTypes as MULTI_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"		organizationField as SINGLE_REFERENCE controlCenter.organizationField BACKREF NONE\n" + 
				"		generalizationRoles as MULTI_REFERENCE controlCenter.role BACKREF specializationRoles\n" + 
				"		specializationRoles as MULTI_REFERENCE controlCenter.role BACKREF generalizationRoles\n" + 
				"		privilegesReceivingRoles as MULTI_REFERENCE controlCenter.role BACKREF privilegesSendingRoles\n" + 
				"		privilegesSendingRoles as MULTI_REFERENCE controlCenter.role BACKREF privilegesReceivingRoles\n" + 
				"		noDirectMemberships as BOOLEAN\n" + 
				"		userRoleAssignments as MULTI_REFERENCE controlCenter.userRoleAssignment BACKREF role\n" + 
				"		privilegeAssignments as MULTI_REFERENCE controlCenter.rolePrivilegeAssignment BACKREF role\n" + 
				"		applicationRoleAssignments as MULTI_REFERENCE controlCenter.roleApplicationRoleAssignment BACKREF role\n" + 
				"	userRoleAssignment as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		user as SINGLE_REFERENCE controlCenter.user BACKREF roleAssignments\n" + 
				"		role as SINGLE_REFERENCE controlCenter.role BACKREF userRoleAssignments\n" + 
				"		organizationUnit as SINGLE_REFERENCE controlCenter.organizationUnit BACKREF NONE\n" + 
				"		lastVerified as TIMESTAMP\n" + 
				"		lastVerifiedBy as SINGLE_REFERENCE controlCenter.user BACKREF NONE\n" + 
				"	rolePrivilegeAssignment as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		role as SINGLE_REFERENCE controlCenter.role BACKREF privilegeAssignments\n" + 
				"		application as SINGLE_REFERENCE controlCenter.application BACKREF NONE\n" + 
				"		privilegeGroup as SINGLE_REFERENCE controlCenter.applicationPrivilegeGroup BACKREF NONE\n" + 
				"		privileges as MULTI_REFERENCE controlCenter.applicationPrivilege BACKREF NONE\n" + 
				"		privilegeObjects as TEXT\n" + 
				"		privilegeObjectInheritance as BOOLEAN\n" + 
				"		organizationFieldFilter as SINGLE_REFERENCE controlCenter.organizationField BACKREF NONE\n" + 
				"		fixedOrganizationRoot as SINGLE_REFERENCE controlCenter.organizationUnit BACKREF NONE\n" + 
				"		organizationUnitTypeFilter as MULTI_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"	roleApplicationRoleAssignment as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		role as SINGLE_REFERENCE controlCenter.role BACKREF applicationRoleAssignments\n" + 
				"		application as SINGLE_REFERENCE controlCenter.application BACKREF NONE\n" + 
				"		applicationRoleName as TEXT\n" + 
				"		organizationFieldFilter as SINGLE_REFERENCE controlCenter.organizationField BACKREF NONE\n" + 
				"		fixedOrganizationRoot as SINGLE_REFERENCE controlCenter.organizationUnit BACKREF NONE\n" + 
				"		organizationUnitTypeFilter as MULTI_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"	systemSettings as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		allowedBaseLanguages as TEXT\n" + 
				"	systemLog as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		managedApplication as SINGLE_REFERENCE controlCenter.managedApplication BACKREF NONE\n" + 
				"		managedPerspective as SINGLE_REFERENCE controlCenter.managedApplicationPerspective BACKREF NONE\n" + 
				"		application as SINGLE_REFERENCE controlCenter.application BACKREF NONE\n" + 
				"		applicationPerspective as SINGLE_REFERENCE controlCenter.applicationPerspective BACKREF NONE\n" + 
				"		applicationVersion as SINGLE_REFERENCE controlCenter.applicationVersion BACKREF NONE\n" + 
				"		logLevel as ENUM VALUES (info, warning, error)\n" + 
				"		thread as TEXT\n" + 
				"		message as TEXT\n" + 
				"		details as TEXT\n" + 
				"		exceptionClass as TEXT\n" + 
				"	application as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TEXT\n" + 
				"		icon as TEXT\n" + 
				"		titleKey as TEXT\n" + 
				"		descriptionKey as TEXT\n" + 
				"		unmanagedApplication as BOOLEAN\n" + 
				"		config as TEXT\n" + 
				"		darkTheme as BOOLEAN\n" + 
				"		perspectives as MULTI_REFERENCE controlCenter.applicationPerspective BACKREF application CASCADE DELETE REFERENCES\n" + 
				"		privilegeGroups as MULTI_REFERENCE controlCenter.applicationPrivilegeGroup BACKREF application\n" + 
				"		versions as MULTI_REFERENCE controlCenter.applicationVersion BACKREF application\n" + 
				"		installedVersion as SINGLE_REFERENCE controlCenter.applicationVersion BACKREF NONE\n" + 
				"		installedAsMainApplication as MULTI_REFERENCE controlCenter.managedApplication BACKREF mainApplication\n" + 
				"	applicationPerspective as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		application as SINGLE_REFERENCE controlCenter.application BACKREF perspectives\n" + 
				"		name as TEXT\n" + 
				"		icon as TEXT\n" + 
				"		titleKey as TEXT\n" + 
				"		descriptionKey as TEXT\n" + 
				"		autoProvision as BOOLEAN\n" + 
				"		toolbarPerspectiveMenu as BOOLEAN\n" + 
				"		managedPerspectives as MULTI_REFERENCE controlCenter.managedApplicationPerspective BACKREF applicationPerspective CASCADE DELETE REFERENCES\n" + 
				"	applicationPrivilegeGroup as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		application as SINGLE_REFERENCE controlCenter.application BACKREF privilegeGroups\n" + 
				"		applicationPrivilegeGroupType as ENUM VALUES (simplePrivilege, simpleOrganizationalPrivilege, simpleCustomObjectPrivilege, standardPrivilegeGroup, organizationalPrivilegeGroup, customObjectPrivilegeGroup)\n" + 
				"		name as TEXT\n" + 
				"		icon as TEXT\n" + 
				"		titleKey as TEXT\n" + 
				"		descriptionKey as TEXT\n" + 
				"		privileges as MULTI_REFERENCE controlCenter.applicationPrivilege BACKREF privilegeGroup\n" + 
				"	applicationPrivilege as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		privilegeGroup as SINGLE_REFERENCE controlCenter.applicationPrivilegeGroup BACKREF privileges\n" + 
				"		name as TEXT\n" + 
				"		icon as TEXT\n" + 
				"		titleKey as TEXT\n" + 
				"	applicationVersion as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		application as SINGLE_REFERENCE controlCenter.application BACKREF versions\n" + 
				"		binary as FILE\n" + 
				"		binaryHash as TEXT\n" + 
				"		version as TEXT\n" + 
				"		releaseNotes as TEXT\n" + 
				"		dataModelData as SINGLE_REFERENCE controlCenter.applicationVersionData BACKREF NONE\n" + 
				"		localizationData as SINGLE_REFERENCE controlCenter.applicationVersionData BACKREF NONE\n" + 
				"		privilegeData as SINGLE_REFERENCE controlCenter.applicationVersionData BACKREF NONE\n" + 
				"		perspectiveData as SINGLE_REFERENCE controlCenter.applicationVersionData BACKREF NONE\n" + 
				"	applicationVersionData as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		data as TEXT\n" + 
				"		dataRows as INT\n" + 
				"		dataAdded as TEXT\n" + 
				"		dataAddedRows as INT\n" + 
				"		dataRemoved as TEXT\n" + 
				"		dataRemovedRows as INT\n" + 
				"	managedApplication as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		mainApplication as SINGLE_REFERENCE controlCenter.application BACKREF installedAsMainApplication\n" + 
				"		organizationField as SINGLE_REFERENCE controlCenter.organizationField BACKREF NONE\n" + 
				"		icon as TEXT\n" + 
				"		titleKey as TEXT\n" + 
				"		descriptionKey as TEXT\n" + 
				"		singleApplication as BOOLEAN\n" + 
				"		darkTheme as BOOLEAN\n" + 
				"		startOnLogin as BOOLEAN\n" + 
				"		perspectives as MULTI_REFERENCE controlCenter.managedApplicationPerspective BACKREF managedApplication CASCADE DELETE REFERENCES\n" + 
				"		listingPosition as INT\n" + 
				"		toolbarApplicationMenu as BOOLEAN\n" + 
				"		applicationGroup as SINGLE_REFERENCE controlCenter.managedApplicationGroup BACKREF applications\n" + 
				"		hidden as BOOLEAN\n" + 
				"	managedApplicationPerspective as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		managedApplication as SINGLE_REFERENCE controlCenter.managedApplication BACKREF perspectives\n" + 
				"		applicationPerspective as SINGLE_REFERENCE controlCenter.applicationPerspective BACKREF managedPerspectives\n" + 
				"		iconOverride as TEXT\n" + 
				"		titleKeyOverride as TEXT\n" + 
				"		descriptionKeyOverride as TEXT\n" + 
				"		toolbarPerspectiveMenu as BOOLEAN\n" + 
				"		listingPosition as INT\n" + 
				"	managedApplicationGroup as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		icon as TEXT\n" + 
				"		titleKey as TEXT\n" + 
				"		applications as MULTI_REFERENCE controlCenter.managedApplication BACKREF applicationGroup\n" + 
				"		listingPosition as INT\n" + 
				"	localizationKey as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		application as SINGLE_REFERENCE controlCenter.application BACKREF NONE\n" + 
				"		key as TEXT\n" + 
				"		used as BOOLEAN\n" + 
				"		localizationKeyFormat as ENUM VALUES (singleLine, multiLine, formatted)\n" + 
				"		localizationKeyType as ENUM VALUES (applicationResourceKey, dictionaryKey, reportingKey, systemKey)\n" + 
				"		comments as TEXT\n" + 
				"		localizationValues as MULTI_REFERENCE controlCenter.localizationValue BACKREF localizationKey\n" + 
				"		topics as MULTI_REFERENCE controlCenter.localizationTopic BACKREF keys\n" + 
				"	localizationValue as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		localizationKey as SINGLE_REFERENCE controlCenter.localizationKey BACKREF localizationValues\n" + 
				"		language as TEXT\n" + 
				"		original as TEXT\n" + 
				"		machineTranslation as TEXT\n" + 
				"		translation as TEXT\n" + 
				"		adminLocalOverride as TEXT\n" + 
				"		adminKeyOverride as TEXT\n" + 
				"		currentDisplayValue as TEXT\n" + 
				"		notes as TEXT\n" + 
				"		machineTranslationState as ENUM VALUES (translationRequested, ok, failed, notNecessary)\n" + 
				"		translationState as ENUM VALUES (translationRequested, ok, unclear, notNecessary)\n" + 
				"		translationVerificationState as ENUM VALUES (notYetTranslated, verificationRequested, ok, correctionsRequired, notNecessary)\n" + 
				"	localizationTopic as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		keys as MULTI_REFERENCE controlCenter.localizationKey BACKREF topics\n" + 
				"		application as SINGLE_REFERENCE controlCenter.application BACKREF NONE\n" + 
				"		icon as TEXT\n" + 
				"		title as TEXT\n" + 
				"		screenshot as FILE\n" + 
				"	group as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		groupType as ENUM VALUES (messageGroup, workGroup)\n" + 
				"		name as TEXT\n" + 
				"		description as TEXT\n" + 
				"		language as TEXT\n" + 
				"		organizationField as SINGLE_REFERENCE controlCenter.organizationField BACKREF NONE\n" + 
				"		organizationUnit as SINGLE_REFERENCE controlCenter.organizationUnit BACKREF NONE\n" + 
				"		owner as SINGLE_REFERENCE controlCenter.user BACKREF NONE\n" + 
				"		moderators as MULTI_REFERENCE controlCenter.user BACKREF NONE\n" + 
				"		mentors as MULTI_REFERENCE controlCenter.user BACKREF NONE\n" + 
				"		valid as BOOLEAN\n" + 
				"		membershipDefinitions as MULTI_REFERENCE controlCenter.groupMembershipDefinition BACKREF group\n" + 
				"		registrationAllowedForDefinitions as MULTI_REFERENCE controlCenter.groupMembershipDefinition BACKREF NONE\n" + 
				"		userMemberships as MULTI_REFERENCE controlCenter.userGroupMembership BACKREF group\n" + 
				"		lastMessageDate as TIMESTAMP\n" + 
				"		groupFolders as MULTI_REFERENCE controlCenter.groupFolder BACKREF group\n" + 
				"	groupMembershipDefinition as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		groupMemberType as ENUM VALUES (user, group, roleMember, userContainer)\n" + 
				"		user as SINGLE_REFERENCE controlCenter.user BACKREF NONE\n" + 
				"		group as SINGLE_REFERENCE controlCenter.group BACKREF NONE\n" + 
				"		role as SINGLE_REFERENCE controlCenter.role BACKREF NONE\n" + 
				"		organizationUnit as SINGLE_REFERENCE controlCenter.organizationUnit BACKREF NONE\n" + 
				"		organizationUnitTypesFilter as MULTI_REFERENCE controlCenter.organizationUnitType BACKREF NONE\n" + 
				"	groupFolder as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		group as SINGLE_REFERENCE controlCenter.group BACKREF groupFolders\n" + 
				"		name as TEXT\n" + 
				"		moderatorReadAccess as BOOLEAN\n" + 
				"		moderatorWriteAccess as BOOLEAN\n" + 
				"		subjectTags as TEXT\n" + 
				"		groupFolderType as ENUM VALUES (chat, messages, files, calendar)\n" + 
				"		messages as MULTI_REFERENCE controlCenter.message BACKREF groupFolder\n" + 
				"	userGroupMembership as TABLE \n" + 
				"		group as SINGLE_REFERENCE controlCenter.group BACKREF userMemberships\n" + 
				"		user as SINGLE_REFERENCE controlCenter.user BACKREF allGroupMemberships\n" + 
				"		groupMembershipRole as ENUM VALUES (participant, moderator, mentor, owner)\n" + 
				"		membershipRejected as BOOLEAN\n" + 
				"		groupMembershipNotificationSetting as ENUM VALUES (standard, silent)\n" + 
				"	applicationFolder as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TEXT\n" + 
				"		application as SINGLE_REFERENCE controlCenter.application BACKREF NONE\n" + 
				"		applicationFolderType as ENUM VALUES (chat, messages, files, calendar)\n" + 
				"		parent as SINGLE_REFERENCE controlCenter.applicationFolder BACKREF children\n" + 
				"		children as MULTI_REFERENCE controlCenter.applicationFolder BACKREF parent\n" + 
				"		messages as MULTI_REFERENCE controlCenter.message BACKREF applicationFolder\n" + 
				"	message as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		messageRecipientType as ENUM VALUES (private, groupFolder, applicationFolder)\n" + 
				"		privateRecipients as MULTI_REFERENCE controlCenter.user BACKREF privateMessages\n" + 
				"		groupFolder as SINGLE_REFERENCE controlCenter.groupFolder BACKREF messages\n" + 
				"		applicationFolder as SINGLE_REFERENCE controlCenter.applicationFolder BACKREF messages\n" + 
				"		subject as TEXT\n" + 
				"		message as TEXT\n" + 
				"		messageType as ENUM VALUES (message, chatMessage, appointment, appointmentSeries, file)\n" + 
				"		file as FILE\n" + 
				"		appointment as SINGLE_REFERENCE controlCenter.appointment BACKREF message\n" + 
				"		appointmentSeries as SINGLE_REFERENCE controlCenter.appointmentSeries BACKREF message\n" + 
				"	appointment as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		message as SINGLE_REFERENCE controlCenter.message BACKREF appointment\n" + 
				"		appointmentSeries as SINGLE_REFERENCE controlCenter.appointmentSeries BACKREF appointments\n" + 
				"		webConference as BOOLEAN\n" + 
				"		startDateTime as DATE_TIME\n" + 
				"		endDateTime as DATE_TIME\n" + 
				"		fullDayEvent as BOOLEAN\n" + 
				"	appointmentSeries as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		message as SINGLE_REFERENCE controlCenter.message BACKREF appointmentSeries\n" + 
				"		appointments as MULTI_REFERENCE controlCenter.appointment BACKREF appointmentSeries\n" + 
				"		appointmentSeriesType as ENUM VALUES (daily, weekly, monthly, yearly)\n" + 
				"		repeatEvery as INT\n" + 
				"		startDateTime as DATE_TIME\n" + 
				"		endDateTime as DATE_TIME\n" + 
				"		fullDayEvent as BOOLEAN\n" + 
				"		seriesEndDate as LOCAL_DATE\n" + 
				"	chatChannel as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		title as TEXT\n" + 
				"		chatMessages as MULTI_REFERENCE controlCenter.chatMessage BACKREF chatChannel\n" + 
				"	chatMessage as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		chatChannel as SINGLE_REFERENCE controlCenter.chatChannel BACKREF chatMessages\n" + 
				"		author as SINGLE_REFERENCE controlCenter.user BACKREF NONE\n" + 
				"		message as TEXT\n";

    }

}
