package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ApplicationPrivilegeGroup extends Entity<ApplicationPrivilegeGroup> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_APPLICATION = "application";
	final static String FIELD_APPLICATION_PRIVILEGE_GROUP_TYPE = "applicationPrivilegeGroupType";
	final static String FIELD_NAME = "name";
	final static String FIELD_ICON = "icon";
	final static String FIELD_TITLE_KEY = "titleKey";
	final static String FIELD_DESCRIPTION_KEY = "descriptionKey";
	final static String FIELD_PRIVILEGES = "privileges";

    static ApplicationPrivilegeGroup create() {
        return new UdbApplicationPrivilegeGroup();
    }

    static ApplicationPrivilegeGroup create(int id) {
        return new UdbApplicationPrivilegeGroup(id, true);
    }

    static ApplicationPrivilegeGroup getById(int id) {
        return new UdbApplicationPrivilegeGroup(id, false);
    }

    static EntityBuilder<ApplicationPrivilegeGroup> getBuilder() {
        return new UdbApplicationPrivilegeGroup(0, false);
    }

    Instant getMetaCreationDate();

    ApplicationPrivilegeGroup setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ApplicationPrivilegeGroup setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ApplicationPrivilegeGroup setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ApplicationPrivilegeGroup setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ApplicationPrivilegeGroup setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ApplicationPrivilegeGroup setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ApplicationPrivilegeGroup setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ApplicationPrivilegeGroup setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ApplicationPrivilegeGroup setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ApplicationPrivilegeGroup setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ApplicationPrivilegeGroup setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ApplicationPrivilegeGroup setMetaDeletedBy(int value);

    Application getApplication();

    ApplicationPrivilegeGroup setApplication(Application value);

    ApplicationPrivilegeGroupType getApplicationPrivilegeGroupType();

    ApplicationPrivilegeGroup setApplicationPrivilegeGroupType(ApplicationPrivilegeGroupType value);

    String getName();

    ApplicationPrivilegeGroup setName(String value);

    String getIcon();

    ApplicationPrivilegeGroup setIcon(String value);

    String getTitleKey();

    ApplicationPrivilegeGroup setTitleKey(String value);

    String getDescriptionKey();

    ApplicationPrivilegeGroup setDescriptionKey(String value);

    List<ApplicationPrivilege> getPrivileges();

    ApplicationPrivilegeGroup setPrivileges(List<ApplicationPrivilege> value);

    int getPrivilegesCount();

    ApplicationPrivilegeGroup setPrivileges(ApplicationPrivilege ... value);

    BitSet getPrivilegesAsBitSet();

    ApplicationPrivilegeGroup addPrivileges(List<ApplicationPrivilege> value);

    ApplicationPrivilegeGroup addPrivileges(ApplicationPrivilege ... value);

    ApplicationPrivilegeGroup removePrivileges(List<ApplicationPrivilege> value);

    ApplicationPrivilegeGroup removePrivileges(ApplicationPrivilege ... value);

    ApplicationPrivilegeGroup removeAllPrivileges();


    static List<ApplicationPrivilegeGroup> getAll() {
        return UdbApplicationPrivilegeGroup.getAll();
    }

    static List<ApplicationPrivilegeGroup> sort(List<ApplicationPrivilegeGroup> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplicationPrivilegeGroup.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbApplicationPrivilegeGroup.getCount();
    }

    static ApplicationPrivilegeGroupQuery filter() {
        return new UdbApplicationPrivilegeGroupQuery();
    }
}

