package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface ApplicationPrivilegeGroupQuery extends Query<ApplicationPrivilegeGroup> {

    static ApplicationPrivilegeGroupQuery create() {
        return new UdbApplicationPrivilegeGroupQuery();
    }

    ApplicationPrivilegeGroupQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ApplicationPrivilegeGroupQuery parseFullTextFilter(String query, String... fieldNames);

	ApplicationPrivilegeGroupQuery metaCreationDate(NumericFilter filter);

	ApplicationPrivilegeGroupQuery orMetaCreationDate(NumericFilter filter);

	ApplicationPrivilegeGroupQuery metaCreatedBy(NumericFilter filter);

	ApplicationPrivilegeGroupQuery orMetaCreatedBy(NumericFilter filter);

	ApplicationPrivilegeGroupQuery metaModificationDate(NumericFilter filter);

	ApplicationPrivilegeGroupQuery orMetaModificationDate(NumericFilter filter);

	ApplicationPrivilegeGroupQuery metaModifiedBy(NumericFilter filter);

	ApplicationPrivilegeGroupQuery orMetaModifiedBy(NumericFilter filter);

	ApplicationPrivilegeGroupQuery metaDeletionDate(NumericFilter filter);

	ApplicationPrivilegeGroupQuery orMetaDeletionDate(NumericFilter filter);

	ApplicationPrivilegeGroupQuery metaDeletedBy(NumericFilter filter);

	ApplicationPrivilegeGroupQuery orMetaDeletedBy(NumericFilter filter);

	ApplicationPrivilegeGroupQuery filterApplication(ApplicationQuery query);

	ApplicationPrivilegeGroupQuery application(NumericFilter filter);

	ApplicationPrivilegeGroupQuery orApplication(NumericFilter filter);

	ApplicationPrivilegeGroupQuery applicationPrivilegeGroupType(EnumFilterType filterType, ApplicationPrivilegeGroupType ... enums);

	ApplicationPrivilegeGroupQuery orApplicationPrivilegeGroupType(EnumFilterType filterType, ApplicationPrivilegeGroupType ... enums);

	ApplicationPrivilegeGroupQuery name(TextFilter filter);

	ApplicationPrivilegeGroupQuery orName(TextFilter filter);

	ApplicationPrivilegeGroupQuery icon(TextFilter filter);

	ApplicationPrivilegeGroupQuery orIcon(TextFilter filter);

	ApplicationPrivilegeGroupQuery titleKey(TextFilter filter);

	ApplicationPrivilegeGroupQuery orTitleKey(TextFilter filter);

	ApplicationPrivilegeGroupQuery descriptionKey(TextFilter filter);

	ApplicationPrivilegeGroupQuery orDescriptionKey(TextFilter filter);

	ApplicationPrivilegeGroupQuery filterPrivileges(ApplicationPrivilegeQuery query);

	ApplicationPrivilegeGroupQuery privileges(MultiReferenceFilterType type, ApplicationPrivilege ... value);

	ApplicationPrivilegeGroupQuery privilegesCount(MultiReferenceFilterType type, int count);

	ApplicationPrivilegeGroupQuery privileges(MultiReferenceFilter filter);

	ApplicationPrivilegeGroupQuery orPrivileges(MultiReferenceFilter filter);


    ApplicationPrivilegeGroupQuery andOr(ApplicationPrivilegeGroupQuery... queries);

    ApplicationPrivilegeGroupQuery customFilter(Function<ApplicationPrivilegeGroup, Boolean> customFilter);

    List<ApplicationPrivilegeGroup> execute();

    ApplicationPrivilegeGroup executeExpectSingleton();

    BitSet executeToBitSet();

    List<ApplicationPrivilegeGroup> execute(String sortFieldName, boolean ascending, String ... path);

    List<ApplicationPrivilegeGroup> execute(int startIndex, int length, Sorting sorting);

}

