package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface ApplicationQuery extends Query<Application> {

    static ApplicationQuery create() {
        return new UdbApplicationQuery();
    }

    ApplicationQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ApplicationQuery parseFullTextFilter(String query, String... fieldNames);

	ApplicationQuery metaCreationDate(NumericFilter filter);

	ApplicationQuery orMetaCreationDate(NumericFilter filter);

	ApplicationQuery metaCreatedBy(NumericFilter filter);

	ApplicationQuery orMetaCreatedBy(NumericFilter filter);

	ApplicationQuery metaModificationDate(NumericFilter filter);

	ApplicationQuery orMetaModificationDate(NumericFilter filter);

	ApplicationQuery metaModifiedBy(NumericFilter filter);

	ApplicationQuery orMetaModifiedBy(NumericFilter filter);

	ApplicationQuery metaDeletionDate(NumericFilter filter);

	ApplicationQuery orMetaDeletionDate(NumericFilter filter);

	ApplicationQuery metaDeletedBy(NumericFilter filter);

	ApplicationQuery orMetaDeletedBy(NumericFilter filter);

	ApplicationQuery name(TextFilter filter);

	ApplicationQuery orName(TextFilter filter);

	ApplicationQuery icon(TextFilter filter);

	ApplicationQuery orIcon(TextFilter filter);

	ApplicationQuery titleKey(TextFilter filter);

	ApplicationQuery orTitleKey(TextFilter filter);

	ApplicationQuery descriptionKey(TextFilter filter);

	ApplicationQuery orDescriptionKey(TextFilter filter);

	ApplicationQuery unmanagedApplication(BooleanFilter filter);

	ApplicationQuery orUnmanagedApplication(BooleanFilter filter);

	ApplicationQuery config(TextFilter filter);

	ApplicationQuery orConfig(TextFilter filter);

	ApplicationQuery darkTheme(BooleanFilter filter);

	ApplicationQuery orDarkTheme(BooleanFilter filter);

	ApplicationQuery filterPerspectives(ApplicationPerspectiveQuery query);

	ApplicationQuery perspectives(MultiReferenceFilterType type, ApplicationPerspective ... value);

	ApplicationQuery perspectivesCount(MultiReferenceFilterType type, int count);

	ApplicationQuery perspectives(MultiReferenceFilter filter);

	ApplicationQuery orPerspectives(MultiReferenceFilter filter);

	ApplicationQuery filterPrivilegeGroups(ApplicationPrivilegeGroupQuery query);

	ApplicationQuery privilegeGroups(MultiReferenceFilterType type, ApplicationPrivilegeGroup ... value);

	ApplicationQuery privilegeGroupsCount(MultiReferenceFilterType type, int count);

	ApplicationQuery privilegeGroups(MultiReferenceFilter filter);

	ApplicationQuery orPrivilegeGroups(MultiReferenceFilter filter);

	ApplicationQuery filterVersions(ApplicationVersionQuery query);

	ApplicationQuery versions(MultiReferenceFilterType type, ApplicationVersion ... value);

	ApplicationQuery versionsCount(MultiReferenceFilterType type, int count);

	ApplicationQuery versions(MultiReferenceFilter filter);

	ApplicationQuery orVersions(MultiReferenceFilter filter);

	ApplicationQuery filterInstalledVersion(ApplicationVersionQuery query);

	ApplicationQuery installedVersion(NumericFilter filter);

	ApplicationQuery orInstalledVersion(NumericFilter filter);

	ApplicationQuery filterInstalledAsMainApplication(ManagedApplicationQuery query);

	ApplicationQuery installedAsMainApplication(MultiReferenceFilterType type, ManagedApplication ... value);

	ApplicationQuery installedAsMainApplicationCount(MultiReferenceFilterType type, int count);

	ApplicationQuery installedAsMainApplication(MultiReferenceFilter filter);

	ApplicationQuery orInstalledAsMainApplication(MultiReferenceFilter filter);


    ApplicationQuery andOr(ApplicationQuery... queries);

    ApplicationQuery customFilter(Function<Application, Boolean> customFilter);

    List<Application> execute();

    Application executeExpectSingleton();

    BitSet executeToBitSet();

    List<Application> execute(String sortFieldName, boolean ascending, String ... path);

    List<Application> execute(int startIndex, int length, Sorting sorting);

}

