package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface AppointmentSeries extends Entity<AppointmentSeries> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_MESSAGE = "message";
	final static String FIELD_APPOINTMENTS = "appointments";
	final static String FIELD_APPOINTMENT_SERIES_TYPE = "appointmentSeriesType";
	final static String FIELD_REPEAT_EVERY = "repeatEvery";
	final static String FIELD_START_DATE_TIME = "startDateTime";
	final static String FIELD_END_DATE_TIME = "endDateTime";
	final static String FIELD_FULL_DAY_EVENT = "fullDayEvent";
	final static String FIELD_SERIES_END_DATE = "seriesEndDate";

    static AppointmentSeries create() {
        return new UdbAppointmentSeries();
    }

    static AppointmentSeries create(int id) {
        return new UdbAppointmentSeries(id, true);
    }

    static AppointmentSeries getById(int id) {
        return new UdbAppointmentSeries(id, false);
    }

    static EntityBuilder<AppointmentSeries> getBuilder() {
        return new UdbAppointmentSeries(0, false);
    }

    Instant getMetaCreationDate();

    AppointmentSeries setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    AppointmentSeries setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    AppointmentSeries setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    AppointmentSeries setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    AppointmentSeries setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    AppointmentSeries setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    AppointmentSeries setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    AppointmentSeries setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    AppointmentSeries setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    AppointmentSeries setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    AppointmentSeries setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    AppointmentSeries setMetaDeletedBy(int value);

    Message getMessage();

    AppointmentSeries setMessage(Message value);

    List<Appointment> getAppointments();

    AppointmentSeries setAppointments(List<Appointment> value);

    int getAppointmentsCount();

    AppointmentSeries setAppointments(Appointment ... value);

    BitSet getAppointmentsAsBitSet();

    AppointmentSeries addAppointments(List<Appointment> value);

    AppointmentSeries addAppointments(Appointment ... value);

    AppointmentSeries removeAppointments(List<Appointment> value);

    AppointmentSeries removeAppointments(Appointment ... value);

    AppointmentSeries removeAllAppointments();

    AppointmentSeriesType getAppointmentSeriesType();

    AppointmentSeries setAppointmentSeriesType(AppointmentSeriesType value);

    int getRepeatEvery();

    AppointmentSeries setRepeatEvery(int value);

    Instant getStartDateTime();

    AppointmentSeries setStartDateTime(Instant value);

    long getStartDateTimeAsEpochMilli();

    AppointmentSeries setStartDateTimeAsEpochMilli(long value);

    Instant getEndDateTime();

    AppointmentSeries setEndDateTime(Instant value);

    long getEndDateTimeAsEpochMilli();

    AppointmentSeries setEndDateTimeAsEpochMilli(long value);

    boolean getFullDayEvent();

    AppointmentSeries setFullDayEvent(boolean value);

    boolean isFullDayEvent();

    LocalDate getSeriesEndDate();

    AppointmentSeries setSeriesEndDate(LocalDate value);

    long getSeriesEndDateAsEpochMilli();

    AppointmentSeries setSeriesEndDateAsEpochMilli(long value);


    static List<AppointmentSeries> getAll() {
        return UdbAppointmentSeries.getAll();
    }

    static List<AppointmentSeries> sort(List<AppointmentSeries> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbAppointmentSeries.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbAppointmentSeries.getCount();
    }

    static AppointmentSeriesQuery filter() {
        return new UdbAppointmentSeriesQuery();
    }
}

