package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface AppointmentSeriesQuery extends Query<AppointmentSeries> {

    static AppointmentSeriesQuery create() {
        return new UdbAppointmentSeriesQuery();
    }

    AppointmentSeriesQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    AppointmentSeriesQuery parseFullTextFilter(String query, String... fieldNames);

	AppointmentSeriesQuery metaCreationDate(NumericFilter filter);

	AppointmentSeriesQuery orMetaCreationDate(NumericFilter filter);

	AppointmentSeriesQuery metaCreatedBy(NumericFilter filter);

	AppointmentSeriesQuery orMetaCreatedBy(NumericFilter filter);

	AppointmentSeriesQuery metaModificationDate(NumericFilter filter);

	AppointmentSeriesQuery orMetaModificationDate(NumericFilter filter);

	AppointmentSeriesQuery metaModifiedBy(NumericFilter filter);

	AppointmentSeriesQuery orMetaModifiedBy(NumericFilter filter);

	AppointmentSeriesQuery metaDeletionDate(NumericFilter filter);

	AppointmentSeriesQuery orMetaDeletionDate(NumericFilter filter);

	AppointmentSeriesQuery metaDeletedBy(NumericFilter filter);

	AppointmentSeriesQuery orMetaDeletedBy(NumericFilter filter);

	AppointmentSeriesQuery filterMessage(MessageQuery query);

	AppointmentSeriesQuery message(NumericFilter filter);

	AppointmentSeriesQuery orMessage(NumericFilter filter);

	AppointmentSeriesQuery filterAppointments(AppointmentQuery query);

	AppointmentSeriesQuery appointments(MultiReferenceFilterType type, Appointment ... value);

	AppointmentSeriesQuery appointmentsCount(MultiReferenceFilterType type, int count);

	AppointmentSeriesQuery appointments(MultiReferenceFilter filter);

	AppointmentSeriesQuery orAppointments(MultiReferenceFilter filter);

	AppointmentSeriesQuery appointmentSeriesType(EnumFilterType filterType, AppointmentSeriesType ... enums);

	AppointmentSeriesQuery orAppointmentSeriesType(EnumFilterType filterType, AppointmentSeriesType ... enums);

	AppointmentSeriesQuery repeatEvery(NumericFilter filter);

	AppointmentSeriesQuery orRepeatEvery(NumericFilter filter);

	AppointmentSeriesQuery startDateTime(NumericFilter filter);

	AppointmentSeriesQuery orStartDateTime(NumericFilter filter);

	AppointmentSeriesQuery endDateTime(NumericFilter filter);

	AppointmentSeriesQuery orEndDateTime(NumericFilter filter);

	AppointmentSeriesQuery fullDayEvent(BooleanFilter filter);

	AppointmentSeriesQuery orFullDayEvent(BooleanFilter filter);

	AppointmentSeriesQuery seriesEndDate(NumericFilter filter);

	AppointmentSeriesQuery orSeriesEndDate(NumericFilter filter);


    AppointmentSeriesQuery andOr(AppointmentSeriesQuery... queries);

    AppointmentSeriesQuery customFilter(Function<AppointmentSeries, Boolean> customFilter);

    List<AppointmentSeries> execute();

    AppointmentSeries executeExpectSingleton();

    BitSet executeToBitSet();

    List<AppointmentSeries> execute(String sortFieldName, boolean ascending, String ... path);

    List<AppointmentSeries> execute(int startIndex, int length, Sorting sorting);

}

