package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ChatChannel extends Entity<ChatChannel> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_TITLE = "title";
	final static String FIELD_CHAT_MESSAGES = "chatMessages";

    static ChatChannel create() {
        return new UdbChatChannel();
    }

    static ChatChannel create(int id) {
        return new UdbChatChannel(id, true);
    }

    static ChatChannel getById(int id) {
        return new UdbChatChannel(id, false);
    }

    static EntityBuilder<ChatChannel> getBuilder() {
        return new UdbChatChannel(0, false);
    }

    Instant getMetaCreationDate();

    ChatChannel setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ChatChannel setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ChatChannel setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ChatChannel setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ChatChannel setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ChatChannel setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ChatChannel setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ChatChannel setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ChatChannel setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ChatChannel setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ChatChannel setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ChatChannel setMetaDeletedBy(int value);

    String getTitle();

    ChatChannel setTitle(String value);

    List<ChatMessage> getChatMessages();

    ChatChannel setChatMessages(List<ChatMessage> value);

    int getChatMessagesCount();

    ChatChannel setChatMessages(ChatMessage ... value);

    BitSet getChatMessagesAsBitSet();

    ChatChannel addChatMessages(List<ChatMessage> value);

    ChatChannel addChatMessages(ChatMessage ... value);

    ChatChannel removeChatMessages(List<ChatMessage> value);

    ChatChannel removeChatMessages(ChatMessage ... value);

    ChatChannel removeAllChatMessages();


    static List<ChatChannel> getAll() {
        return UdbChatChannel.getAll();
    }

    static List<ChatChannel> sort(List<ChatChannel> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbChatChannel.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbChatChannel.getCount();
    }

    static ChatChannelQuery filter() {
        return new UdbChatChannelQuery();
    }
}

