package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Group extends Entity<Group> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_GROUP_TYPE = "groupType";
	final static String FIELD_NAME = "name";
	final static String FIELD_DESCRIPTION = "description";
	final static String FIELD_LANGUAGE = "language";
	final static String FIELD_ORGANIZATION_FIELD = "organizationField";
	final static String FIELD_ORGANIZATION_UNIT = "organizationUnit";
	final static String FIELD_OWNER = "owner";
	final static String FIELD_MODERATORS = "moderators";
	final static String FIELD_MENTORS = "mentors";
	final static String FIELD_VALID = "valid";
	final static String FIELD_MEMBERSHIP_DEFINITIONS = "membershipDefinitions";
	final static String FIELD_REGISTRATION_ALLOWED_FOR_DEFINITIONS = "registrationAllowedForDefinitions";
	final static String FIELD_USER_MEMBERSHIPS = "userMemberships";
	final static String FIELD_LAST_MESSAGE_DATE = "lastMessageDate";
	final static String FIELD_GROUP_FOLDERS = "groupFolders";

    static Group create() {
        return new UdbGroup();
    }

    static Group create(int id) {
        return new UdbGroup(id, true);
    }

    static Group getById(int id) {
        return new UdbGroup(id, false);
    }

    static EntityBuilder<Group> getBuilder() {
        return new UdbGroup(0, false);
    }

    Instant getMetaCreationDate();

    Group setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    Group setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    Group setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    Group setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    Group setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    Group setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    Group setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    Group setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    Group setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Group setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Group setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Group setMetaDeletedBy(int value);

    GroupType getGroupType();

    Group setGroupType(GroupType value);

    String getName();

    Group setName(String value);

    String getDescription();

    Group setDescription(String value);

    String getLanguage();

    Group setLanguage(String value);

    OrganizationField getOrganizationField();

    Group setOrganizationField(OrganizationField value);

    OrganizationUnit getOrganizationUnit();

    Group setOrganizationUnit(OrganizationUnit value);

    User getOwner();

    Group setOwner(User value);

    List<User> getModerators();

    Group setModerators(List<User> value);

    int getModeratorsCount();

    Group setModerators(User ... value);

    BitSet getModeratorsAsBitSet();

    Group addModerators(List<User> value);

    Group addModerators(User ... value);

    Group removeModerators(List<User> value);

    Group removeModerators(User ... value);

    Group removeAllModerators();

    List<User> getMentors();

    Group setMentors(List<User> value);

    int getMentorsCount();

    Group setMentors(User ... value);

    BitSet getMentorsAsBitSet();

    Group addMentors(List<User> value);

    Group addMentors(User ... value);

    Group removeMentors(List<User> value);

    Group removeMentors(User ... value);

    Group removeAllMentors();

    boolean getValid();

    Group setValid(boolean value);

    boolean isValid();

    List<GroupMembershipDefinition> getMembershipDefinitions();

    Group setMembershipDefinitions(List<GroupMembershipDefinition> value);

    int getMembershipDefinitionsCount();

    Group setMembershipDefinitions(GroupMembershipDefinition ... value);

    BitSet getMembershipDefinitionsAsBitSet();

    Group addMembershipDefinitions(List<GroupMembershipDefinition> value);

    Group addMembershipDefinitions(GroupMembershipDefinition ... value);

    Group removeMembershipDefinitions(List<GroupMembershipDefinition> value);

    Group removeMembershipDefinitions(GroupMembershipDefinition ... value);

    Group removeAllMembershipDefinitions();

    List<GroupMembershipDefinition> getRegistrationAllowedForDefinitions();

    Group setRegistrationAllowedForDefinitions(List<GroupMembershipDefinition> value);

    int getRegistrationAllowedForDefinitionsCount();

    Group setRegistrationAllowedForDefinitions(GroupMembershipDefinition ... value);

    BitSet getRegistrationAllowedForDefinitionsAsBitSet();

    Group addRegistrationAllowedForDefinitions(List<GroupMembershipDefinition> value);

    Group addRegistrationAllowedForDefinitions(GroupMembershipDefinition ... value);

    Group removeRegistrationAllowedForDefinitions(List<GroupMembershipDefinition> value);

    Group removeRegistrationAllowedForDefinitions(GroupMembershipDefinition ... value);

    Group removeAllRegistrationAllowedForDefinitions();

    List<UserGroupMembership> getUserMemberships();

    Group setUserMemberships(List<UserGroupMembership> value);

    int getUserMembershipsCount();

    Group setUserMemberships(UserGroupMembership ... value);

    BitSet getUserMembershipsAsBitSet();

    Group addUserMemberships(List<UserGroupMembership> value);

    Group addUserMemberships(UserGroupMembership ... value);

    Group removeUserMemberships(List<UserGroupMembership> value);

    Group removeUserMemberships(UserGroupMembership ... value);

    Group removeAllUserMemberships();

    Instant getLastMessageDate();

    Group setLastMessageDate(Instant value);

    int getLastMessageDateAsEpochSecond();

    Group setLastMessageDateAsEpochSecond(int value);

    long getLastMessageDateAsEpochMilli();

    Group setLastMessageDateAsEpochMilli(long value);

    List<GroupFolder> getGroupFolders();

    Group setGroupFolders(List<GroupFolder> value);

    int getGroupFoldersCount();

    Group setGroupFolders(GroupFolder ... value);

    BitSet getGroupFoldersAsBitSet();

    Group addGroupFolders(List<GroupFolder> value);

    Group addGroupFolders(GroupFolder ... value);

    Group removeGroupFolders(List<GroupFolder> value);

    Group removeGroupFolders(GroupFolder ... value);

    Group removeAllGroupFolders();


    static List<Group> getAll() {
        return UdbGroup.getAll();
    }

    static List<Group> sort(List<Group> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbGroup.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbGroup.getCount();
    }

    static GroupQuery filter() {
        return new UdbGroupQuery();
    }
}

