package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface GroupFolder extends Entity<GroupFolder> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_GROUP = "group";
	final static String FIELD_NAME = "name";
	final static String FIELD_MODERATOR_READ_ACCESS = "moderatorReadAccess";
	final static String FIELD_MODERATOR_WRITE_ACCESS = "moderatorWriteAccess";
	final static String FIELD_SUBJECT_TAGS = "subjectTags";
	final static String FIELD_GROUP_FOLDER_TYPE = "groupFolderType";
	final static String FIELD_MESSAGES = "messages";

    static GroupFolder create() {
        return new UdbGroupFolder();
    }

    static GroupFolder create(int id) {
        return new UdbGroupFolder(id, true);
    }

    static GroupFolder getById(int id) {
        return new UdbGroupFolder(id, false);
    }

    static EntityBuilder<GroupFolder> getBuilder() {
        return new UdbGroupFolder(0, false);
    }

    Instant getMetaCreationDate();

    GroupFolder setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    GroupFolder setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    GroupFolder setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    GroupFolder setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    GroupFolder setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    GroupFolder setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    GroupFolder setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    GroupFolder setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    GroupFolder setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    GroupFolder setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    GroupFolder setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    GroupFolder setMetaDeletedBy(int value);

    Group getGroup();

    GroupFolder setGroup(Group value);

    String getName();

    GroupFolder setName(String value);

    boolean getModeratorReadAccess();

    GroupFolder setModeratorReadAccess(boolean value);

    boolean isModeratorReadAccess();

    boolean getModeratorWriteAccess();

    GroupFolder setModeratorWriteAccess(boolean value);

    boolean isModeratorWriteAccess();

    String getSubjectTags();

    GroupFolder setSubjectTags(String value);

    GroupFolderType getGroupFolderType();

    GroupFolder setGroupFolderType(GroupFolderType value);

    List<Message> getMessages();

    GroupFolder setMessages(List<Message> value);

    int getMessagesCount();

    GroupFolder setMessages(Message ... value);

    BitSet getMessagesAsBitSet();

    GroupFolder addMessages(List<Message> value);

    GroupFolder addMessages(Message ... value);

    GroupFolder removeMessages(List<Message> value);

    GroupFolder removeMessages(Message ... value);

    GroupFolder removeAllMessages();


    static List<GroupFolder> getAll() {
        return UdbGroupFolder.getAll();
    }

    static List<GroupFolder> sort(List<GroupFolder> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbGroupFolder.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbGroupFolder.getCount();
    }

    static GroupFolderQuery filter() {
        return new UdbGroupFolderQuery();
    }
}

