package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface LocalizationKeyQuery extends Query<LocalizationKey> {

    static LocalizationKeyQuery create() {
        return new UdbLocalizationKeyQuery();
    }

    LocalizationKeyQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    LocalizationKeyQuery parseFullTextFilter(String query, String... fieldNames);

	LocalizationKeyQuery metaCreationDate(NumericFilter filter);

	LocalizationKeyQuery orMetaCreationDate(NumericFilter filter);

	LocalizationKeyQuery metaCreatedBy(NumericFilter filter);

	LocalizationKeyQuery orMetaCreatedBy(NumericFilter filter);

	LocalizationKeyQuery metaModificationDate(NumericFilter filter);

	LocalizationKeyQuery orMetaModificationDate(NumericFilter filter);

	LocalizationKeyQuery metaModifiedBy(NumericFilter filter);

	LocalizationKeyQuery orMetaModifiedBy(NumericFilter filter);

	LocalizationKeyQuery metaDeletionDate(NumericFilter filter);

	LocalizationKeyQuery orMetaDeletionDate(NumericFilter filter);

	LocalizationKeyQuery metaDeletedBy(NumericFilter filter);

	LocalizationKeyQuery orMetaDeletedBy(NumericFilter filter);

	LocalizationKeyQuery filterApplication(ApplicationQuery query);

	LocalizationKeyQuery application(NumericFilter filter);

	LocalizationKeyQuery orApplication(NumericFilter filter);

	LocalizationKeyQuery key(TextFilter filter);

	LocalizationKeyQuery orKey(TextFilter filter);

	LocalizationKeyQuery used(BooleanFilter filter);

	LocalizationKeyQuery orUsed(BooleanFilter filter);

	LocalizationKeyQuery localizationKeyFormat(EnumFilterType filterType, LocalizationKeyFormat ... enums);

	LocalizationKeyQuery orLocalizationKeyFormat(EnumFilterType filterType, LocalizationKeyFormat ... enums);

	LocalizationKeyQuery localizationKeyType(EnumFilterType filterType, LocalizationKeyType ... enums);

	LocalizationKeyQuery orLocalizationKeyType(EnumFilterType filterType, LocalizationKeyType ... enums);

	LocalizationKeyQuery comments(TextFilter filter);

	LocalizationKeyQuery orComments(TextFilter filter);

	LocalizationKeyQuery filterLocalizationValues(LocalizationValueQuery query);

	LocalizationKeyQuery localizationValues(MultiReferenceFilterType type, LocalizationValue ... value);

	LocalizationKeyQuery localizationValuesCount(MultiReferenceFilterType type, int count);

	LocalizationKeyQuery localizationValues(MultiReferenceFilter filter);

	LocalizationKeyQuery orLocalizationValues(MultiReferenceFilter filter);

	LocalizationKeyQuery filterTopics(LocalizationTopicQuery query);

	LocalizationKeyQuery topics(MultiReferenceFilterType type, LocalizationTopic ... value);

	LocalizationKeyQuery topicsCount(MultiReferenceFilterType type, int count);

	LocalizationKeyQuery topics(MultiReferenceFilter filter);

	LocalizationKeyQuery orTopics(MultiReferenceFilter filter);


    LocalizationKeyQuery andOr(LocalizationKeyQuery... queries);

    LocalizationKeyQuery customFilter(Function<LocalizationKey, Boolean> customFilter);

    List<LocalizationKey> execute();

    LocalizationKey executeExpectSingleton();

    BitSet executeToBitSet();

    List<LocalizationKey> execute(String sortFieldName, boolean ascending, String ... path);

    List<LocalizationKey> execute(int startIndex, int length, Sorting sorting);

}

