package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface ManagedApplicationGroupQuery extends Query<ManagedApplicationGroup> {

    static ManagedApplicationGroupQuery create() {
        return new UdbManagedApplicationGroupQuery();
    }

    ManagedApplicationGroupQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ManagedApplicationGroupQuery parseFullTextFilter(String query, String... fieldNames);

	ManagedApplicationGroupQuery metaCreationDate(NumericFilter filter);

	ManagedApplicationGroupQuery orMetaCreationDate(NumericFilter filter);

	ManagedApplicationGroupQuery metaCreatedBy(NumericFilter filter);

	ManagedApplicationGroupQuery orMetaCreatedBy(NumericFilter filter);

	ManagedApplicationGroupQuery metaModificationDate(NumericFilter filter);

	ManagedApplicationGroupQuery orMetaModificationDate(NumericFilter filter);

	ManagedApplicationGroupQuery metaModifiedBy(NumericFilter filter);

	ManagedApplicationGroupQuery orMetaModifiedBy(NumericFilter filter);

	ManagedApplicationGroupQuery metaDeletionDate(NumericFilter filter);

	ManagedApplicationGroupQuery orMetaDeletionDate(NumericFilter filter);

	ManagedApplicationGroupQuery metaDeletedBy(NumericFilter filter);

	ManagedApplicationGroupQuery orMetaDeletedBy(NumericFilter filter);

	ManagedApplicationGroupQuery icon(TextFilter filter);

	ManagedApplicationGroupQuery orIcon(TextFilter filter);

	ManagedApplicationGroupQuery titleKey(TextFilter filter);

	ManagedApplicationGroupQuery orTitleKey(TextFilter filter);

	ManagedApplicationGroupQuery filterApplications(ManagedApplicationQuery query);

	ManagedApplicationGroupQuery applications(MultiReferenceFilterType type, ManagedApplication ... value);

	ManagedApplicationGroupQuery applicationsCount(MultiReferenceFilterType type, int count);

	ManagedApplicationGroupQuery applications(MultiReferenceFilter filter);

	ManagedApplicationGroupQuery orApplications(MultiReferenceFilter filter);

	ManagedApplicationGroupQuery listingPosition(NumericFilter filter);

	ManagedApplicationGroupQuery orListingPosition(NumericFilter filter);


    ManagedApplicationGroupQuery andOr(ManagedApplicationGroupQuery... queries);

    ManagedApplicationGroupQuery customFilter(Function<ManagedApplicationGroup, Boolean> customFilter);

    List<ManagedApplicationGroup> execute();

    ManagedApplicationGroup executeExpectSingleton();

    BitSet executeToBitSet();

    List<ManagedApplicationGroup> execute(String sortFieldName, boolean ascending, String ... path);

    List<ManagedApplicationGroup> execute(int startIndex, int length, Sorting sorting);

}

