package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Message extends Entity<Message> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_MESSAGE_RECIPIENT_TYPE = "messageRecipientType";
	final static String FIELD_PRIVATE_RECIPIENTS = "privateRecipients";
	final static String FIELD_GROUP_FOLDER = "groupFolder";
	final static String FIELD_APPLICATION_FOLDER = "applicationFolder";
	final static String FIELD_SUBJECT = "subject";
	final static String FIELD_MESSAGE = "message";
	final static String FIELD_MESSAGE_TYPE = "messageType";
	final static String FIELD_FILE = "file";
	final static String FIELD_APPOINTMENT = "appointment";
	final static String FIELD_APPOINTMENT_SERIES = "appointmentSeries";

    static Message create() {
        return new UdbMessage();
    }

    static Message create(int id) {
        return new UdbMessage(id, true);
    }

    static Message getById(int id) {
        return new UdbMessage(id, false);
    }

    static EntityBuilder<Message> getBuilder() {
        return new UdbMessage(0, false);
    }

    Instant getMetaCreationDate();

    Message setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    Message setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    Message setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    Message setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    Message setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    Message setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    Message setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    Message setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    Message setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Message setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Message setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Message setMetaDeletedBy(int value);

    MessageRecipientType getMessageRecipientType();

    Message setMessageRecipientType(MessageRecipientType value);

    List<User> getPrivateRecipients();

    Message setPrivateRecipients(List<User> value);

    int getPrivateRecipientsCount();

    Message setPrivateRecipients(User ... value);

    BitSet getPrivateRecipientsAsBitSet();

    Message addPrivateRecipients(List<User> value);

    Message addPrivateRecipients(User ... value);

    Message removePrivateRecipients(List<User> value);

    Message removePrivateRecipients(User ... value);

    Message removeAllPrivateRecipients();

    GroupFolder getGroupFolder();

    Message setGroupFolder(GroupFolder value);

    ApplicationFolder getApplicationFolder();

    Message setApplicationFolder(ApplicationFolder value);

    String getSubject();

    Message setSubject(String value);

    String getMessage();

    Message setMessage(String value);

    MessageType getMessageType();

    Message setMessageType(MessageType value);

    FileValue getFile();

    Message setFile(File value);

    Message setFile(File value, String fileName);

    Appointment getAppointment();

    Message setAppointment(Appointment value);

    AppointmentSeries getAppointmentSeries();

    Message setAppointmentSeries(AppointmentSeries value);


    static List<Message> getAll() {
        return UdbMessage.getAll();
    }

    static List<Message> sort(List<Message> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbMessage.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbMessage.getCount();
    }

    static MessageQuery filter() {
        return new UdbMessageQuery();
    }
}

