package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface OrganizationFieldViewQuery extends Query<OrganizationFieldView> {

    static OrganizationFieldViewQuery create() {
        return new UdbOrganizationFieldViewQuery();
    }

    OrganizationFieldViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    OrganizationFieldViewQuery parseFullTextFilter(String query, String... fieldNames);

	OrganizationFieldViewQuery title(TranslatableTextFilter filter);

	OrganizationFieldViewQuery orTitle(TranslatableTextFilter filter);

	OrganizationFieldViewQuery icon(TextFilter filter);

	OrganizationFieldViewQuery orIcon(TextFilter filter);


    OrganizationFieldViewQuery andOr(OrganizationFieldViewQuery... queries);

    OrganizationFieldViewQuery customFilter(Function<OrganizationFieldView, Boolean> customFilter);

    List<OrganizationFieldView> execute();

    OrganizationFieldView executeExpectSingleton();

    BitSet executeToBitSet();

    List<OrganizationFieldView> execute(String sortFieldName, boolean ascending, String ... path);

    List<OrganizationFieldView> execute(int startIndex, int length, Sorting sorting);

}

