package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface OrganizationUnitView extends Entity<OrganizationUnitView> {

	final static String FIELD_NAME = "name";
	final static String FIELD_PARENT = "parent";
	final static String FIELD_CHILDREN = "children";
	final static String FIELD_TYPE = "type";
	final static String FIELD_ICON = "icon";
	final static String FIELD_ADDRESS = "address";

    static OrganizationUnitView getById(int id) {
        return new UdbOrganizationUnitView(id, false);
    }

    static EntityBuilder<OrganizationUnitView> getBuilder() {
        return new UdbOrganizationUnitView(0, false);
    }

    TranslatableText getName();

    OrganizationUnitView getParent();

    List<OrganizationUnitView> getChildren();

    int getChildrenCount();

    BitSet getChildrenAsBitSet();

    OrganizationUnitTypeView getType();

    String getIcon();

    AddressView getAddress();


    static List<OrganizationUnitView> getAll() {
        return UdbOrganizationUnitView.getAll();
    }

    static List<OrganizationUnitView> sort(List<OrganizationUnitView> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbOrganizationUnitView.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbOrganizationUnitView.getCount();
    }

    static OrganizationUnitViewQuery filter() {
        return new UdbOrganizationUnitViewQuery();
    }
}

