package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface SystemLogQuery extends Query<SystemLog> {

    static SystemLogQuery create() {
        return new UdbSystemLogQuery();
    }

    SystemLogQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    SystemLogQuery parseFullTextFilter(String query, String... fieldNames);

	SystemLogQuery metaCreationDate(NumericFilter filter);

	SystemLogQuery orMetaCreationDate(NumericFilter filter);

	SystemLogQuery metaCreatedBy(NumericFilter filter);

	SystemLogQuery orMetaCreatedBy(NumericFilter filter);

	SystemLogQuery metaModificationDate(NumericFilter filter);

	SystemLogQuery orMetaModificationDate(NumericFilter filter);

	SystemLogQuery metaModifiedBy(NumericFilter filter);

	SystemLogQuery orMetaModifiedBy(NumericFilter filter);

	SystemLogQuery metaDeletionDate(NumericFilter filter);

	SystemLogQuery orMetaDeletionDate(NumericFilter filter);

	SystemLogQuery metaDeletedBy(NumericFilter filter);

	SystemLogQuery orMetaDeletedBy(NumericFilter filter);

	SystemLogQuery filterManagedApplication(ManagedApplicationQuery query);

	SystemLogQuery managedApplication(NumericFilter filter);

	SystemLogQuery orManagedApplication(NumericFilter filter);

	SystemLogQuery filterManagedPerspective(ManagedApplicationPerspectiveQuery query);

	SystemLogQuery managedPerspective(NumericFilter filter);

	SystemLogQuery orManagedPerspective(NumericFilter filter);

	SystemLogQuery filterApplication(ApplicationQuery query);

	SystemLogQuery application(NumericFilter filter);

	SystemLogQuery orApplication(NumericFilter filter);

	SystemLogQuery filterApplicationPerspective(ApplicationPerspectiveQuery query);

	SystemLogQuery applicationPerspective(NumericFilter filter);

	SystemLogQuery orApplicationPerspective(NumericFilter filter);

	SystemLogQuery filterApplicationVersion(ApplicationVersionQuery query);

	SystemLogQuery applicationVersion(NumericFilter filter);

	SystemLogQuery orApplicationVersion(NumericFilter filter);

	SystemLogQuery logLevel(EnumFilterType filterType, LogLevel ... enums);

	SystemLogQuery orLogLevel(EnumFilterType filterType, LogLevel ... enums);

	SystemLogQuery thread(TextFilter filter);

	SystemLogQuery orThread(TextFilter filter);

	SystemLogQuery message(TextFilter filter);

	SystemLogQuery orMessage(TextFilter filter);

	SystemLogQuery details(TextFilter filter);

	SystemLogQuery orDetails(TextFilter filter);

	SystemLogQuery exceptionClass(TextFilter filter);

	SystemLogQuery orExceptionClass(TextFilter filter);


    SystemLogQuery andOr(SystemLogQuery... queries);

    SystemLogQuery customFilter(Function<SystemLog, Boolean> customFilter);

    List<SystemLog> execute();

    SystemLog executeExpectSingleton();

    BitSet executeToBitSet();

    List<SystemLog> execute(String sortFieldName, boolean ascending, String ... path);

    List<SystemLog> execute(int startIndex, int length, Sorting sorting);

}

