package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbApplication extends AbstractUdbEntity<Application> implements Application {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static TextIndex name;
	protected static TextIndex icon;
	protected static TextIndex titleKey;
	protected static TextIndex descriptionKey;
	protected static BooleanIndex unmanagedApplication;
	protected static TextIndex config;
	protected static BooleanIndex darkTheme;
	protected static MultiReferenceIndex perspectives;
	protected static MultiReferenceIndex privilegeGroups;
	protected static MultiReferenceIndex versions;
	protected static SingleReferenceIndex installedVersion;
	protected static MultiReferenceIndex installedAsMainApplication;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		name = (TextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		titleKey = (TextIndex) tableIndex.getColumnIndex(FIELD_TITLE_KEY);
		descriptionKey = (TextIndex) tableIndex.getColumnIndex(FIELD_DESCRIPTION_KEY);
		unmanagedApplication = (BooleanIndex) tableIndex.getColumnIndex(FIELD_UNMANAGED_APPLICATION);
		config = (TextIndex) tableIndex.getColumnIndex(FIELD_CONFIG);
		darkTheme = (BooleanIndex) tableIndex.getColumnIndex(FIELD_DARK_THEME);
		perspectives = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PERSPECTIVES);
		privilegeGroups = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PRIVILEGE_GROUPS);
		versions = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_VERSIONS);
		installedVersion = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_INSTALLED_VERSION);
		installedAsMainApplication = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_INSTALLED_AS_MAIN_APPLICATION);
    }

    public static List<Application> getAll() {
        return new EntityBitSetList<>(Application.getBuilder(), table.getRecordBitSet());
    }

    public static List<Application> sort(List<Application> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<Application> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, Application.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplication() {
        super(table);
    }

    public UdbApplication(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public Application build() {
        return new UdbApplication();
    }

    @Override
    public Application build(int id) {
        return new UdbApplication(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public Application setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public Application setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public Application setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public Application setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public Application setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public Application setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public Application setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public Application setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public Application setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public Application setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public Application setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public Application setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public Application setName(String value) {
	    setTextValue(value, this.name);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public Application setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public String getTitleKey() {
        return getTextValue(titleKey);
	}

	@Override
	public Application setTitleKey(String value) {
	    setTextValue(value, this.titleKey);
		return this;
	}

	@Override
	public String getDescriptionKey() {
        return getTextValue(descriptionKey);
	}

	@Override
	public Application setDescriptionKey(String value) {
	    setTextValue(value, this.descriptionKey);
		return this;
	}

	@Override
	public boolean getUnmanagedApplication() {
	    return getBooleanValue(unmanagedApplication);
	}

	@Override
	public Application setUnmanagedApplication(boolean value) {
	    setBooleanValue(value, this.unmanagedApplication);
		return this;
	}

	@Override
	public boolean isUnmanagedApplication() {
	    return getBooleanValue(unmanagedApplication);
	}

	@Override
	public String getConfig() {
        return getTextValue(config);
	}

	@Override
	public Application setConfig(String value) {
	    setTextValue(value, this.config);
		return this;
	}

	@Override
	public boolean getDarkTheme() {
	    return getBooleanValue(darkTheme);
	}

	@Override
	public Application setDarkTheme(boolean value) {
	    setBooleanValue(value, this.darkTheme);
		return this;
	}

	@Override
	public boolean isDarkTheme() {
	    return getBooleanValue(darkTheme);
	}

	@Override
	public List<ApplicationPerspective> getPerspectives() {
	    return getMultiReferenceValue(perspectives, ApplicationPerspective.getBuilder());
	}

	@Override
	public Application setPerspectives(List<ApplicationPerspective> value) {
		setMultiReferenceValue(value, perspectives);
		return this;
	}

	@Override
	public int getPerspectivesCount() {
	    return getMultiReferenceValueCount(perspectives, ApplicationPerspective.getBuilder());
	}

	@Override
	public Application setPerspectives(ApplicationPerspective ... value) {
		setMultiReferenceValue(Arrays.asList(value), perspectives);
		return this;
	}

	@Override
	public BitSet getPerspectivesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(perspectives, ApplicationPerspective.getBuilder());
	}

	@Override
	public Application addPerspectives(List<ApplicationPerspective> value) {
		addMultiReferenceValue(value, perspectives);
		return this;
	}

	@Override
	public Application addPerspectives(ApplicationPerspective ... value) {
		addMultiReferenceValue(Arrays.asList(value), perspectives);
		return this;
	}

	@Override
	public Application removePerspectives(List<ApplicationPerspective> value) {
		removeMultiReferenceValue(value, perspectives);
		return this;
	}

	@Override
	public Application removePerspectives(ApplicationPerspective ... value) {
		removeMultiReferenceValue(Arrays.asList(value), perspectives);
		return this;
	}

	@Override
	public Application removeAllPerspectives() {
		removeAllMultiReferenceValue(perspectives);
		return this;
	}

	@Override
	public List<ApplicationPrivilegeGroup> getPrivilegeGroups() {
	    return getMultiReferenceValue(privilegeGroups, ApplicationPrivilegeGroup.getBuilder());
	}

	@Override
	public Application setPrivilegeGroups(List<ApplicationPrivilegeGroup> value) {
		setMultiReferenceValue(value, privilegeGroups);
		return this;
	}

	@Override
	public int getPrivilegeGroupsCount() {
	    return getMultiReferenceValueCount(privilegeGroups, ApplicationPrivilegeGroup.getBuilder());
	}

	@Override
	public Application setPrivilegeGroups(ApplicationPrivilegeGroup ... value) {
		setMultiReferenceValue(Arrays.asList(value), privilegeGroups);
		return this;
	}

	@Override
	public BitSet getPrivilegeGroupsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(privilegeGroups, ApplicationPrivilegeGroup.getBuilder());
	}

	@Override
	public Application addPrivilegeGroups(List<ApplicationPrivilegeGroup> value) {
		addMultiReferenceValue(value, privilegeGroups);
		return this;
	}

	@Override
	public Application addPrivilegeGroups(ApplicationPrivilegeGroup ... value) {
		addMultiReferenceValue(Arrays.asList(value), privilegeGroups);
		return this;
	}

	@Override
	public Application removePrivilegeGroups(List<ApplicationPrivilegeGroup> value) {
		removeMultiReferenceValue(value, privilegeGroups);
		return this;
	}

	@Override
	public Application removePrivilegeGroups(ApplicationPrivilegeGroup ... value) {
		removeMultiReferenceValue(Arrays.asList(value), privilegeGroups);
		return this;
	}

	@Override
	public Application removeAllPrivilegeGroups() {
		removeAllMultiReferenceValue(privilegeGroups);
		return this;
	}

	@Override
	public List<ApplicationVersion> getVersions() {
	    return getMultiReferenceValue(versions, ApplicationVersion.getBuilder());
	}

	@Override
	public Application setVersions(List<ApplicationVersion> value) {
		setMultiReferenceValue(value, versions);
		return this;
	}

	@Override
	public int getVersionsCount() {
	    return getMultiReferenceValueCount(versions, ApplicationVersion.getBuilder());
	}

	@Override
	public Application setVersions(ApplicationVersion ... value) {
		setMultiReferenceValue(Arrays.asList(value), versions);
		return this;
	}

	@Override
	public BitSet getVersionsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(versions, ApplicationVersion.getBuilder());
	}

	@Override
	public Application addVersions(List<ApplicationVersion> value) {
		addMultiReferenceValue(value, versions);
		return this;
	}

	@Override
	public Application addVersions(ApplicationVersion ... value) {
		addMultiReferenceValue(Arrays.asList(value), versions);
		return this;
	}

	@Override
	public Application removeVersions(List<ApplicationVersion> value) {
		removeMultiReferenceValue(value, versions);
		return this;
	}

	@Override
	public Application removeVersions(ApplicationVersion ... value) {
		removeMultiReferenceValue(Arrays.asList(value), versions);
		return this;
	}

	@Override
	public Application removeAllVersions() {
		removeAllMultiReferenceValue(versions);
		return this;
	}

	@Override
	public ApplicationVersion getInstalledVersion() {
		if (isChanged(installedVersion)) {
			return (ApplicationVersion) getReferenceChangeValue(installedVersion);
		} else {
			int id = installedVersion.getValue(getId());
			if (id > 0) {
				return ApplicationVersion.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Application setInstalledVersion(ApplicationVersion value) {
		setSingleReferenceValue(installedVersion, value, table);
		return this;
	}

	@Override
	public List<ManagedApplication> getInstalledAsMainApplication() {
	    return getMultiReferenceValue(installedAsMainApplication, ManagedApplication.getBuilder());
	}

	@Override
	public Application setInstalledAsMainApplication(List<ManagedApplication> value) {
		setMultiReferenceValue(value, installedAsMainApplication);
		return this;
	}

	@Override
	public int getInstalledAsMainApplicationCount() {
	    return getMultiReferenceValueCount(installedAsMainApplication, ManagedApplication.getBuilder());
	}

	@Override
	public Application setInstalledAsMainApplication(ManagedApplication ... value) {
		setMultiReferenceValue(Arrays.asList(value), installedAsMainApplication);
		return this;
	}

	@Override
	public BitSet getInstalledAsMainApplicationAsBitSet() {
	    return getMultiReferenceValueAsBitSet(installedAsMainApplication, ManagedApplication.getBuilder());
	}

	@Override
	public Application addInstalledAsMainApplication(List<ManagedApplication> value) {
		addMultiReferenceValue(value, installedAsMainApplication);
		return this;
	}

	@Override
	public Application addInstalledAsMainApplication(ManagedApplication ... value) {
		addMultiReferenceValue(Arrays.asList(value), installedAsMainApplication);
		return this;
	}

	@Override
	public Application removeInstalledAsMainApplication(List<ManagedApplication> value) {
		removeMultiReferenceValue(value, installedAsMainApplication);
		return this;
	}

	@Override
	public Application removeInstalledAsMainApplication(ManagedApplication ... value) {
		removeMultiReferenceValue(Arrays.asList(value), installedAsMainApplication);
		return this;
	}

	@Override
	public Application removeAllInstalledAsMainApplication() {
		removeAllMultiReferenceValue(installedAsMainApplication);
		return this;
	}


    @Override
    public UdbApplication save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbApplication saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbApplication save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }
}



