package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbApplicationPrivilegeGroup extends AbstractUdbEntity<ApplicationPrivilegeGroup> implements ApplicationPrivilegeGroup {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static SingleReferenceIndex application;
	protected static ShortIndex applicationPrivilegeGroupType;
	protected static TextIndex name;
	protected static TextIndex icon;
	protected static TextIndex titleKey;
	protected static TextIndex descriptionKey;
	protected static MultiReferenceIndex privileges;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		application = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION);
		applicationPrivilegeGroupType = (ShortIndex) tableIndex.getColumnIndex(FIELD_APPLICATION_PRIVILEGE_GROUP_TYPE);
		name = (TextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		titleKey = (TextIndex) tableIndex.getColumnIndex(FIELD_TITLE_KEY);
		descriptionKey = (TextIndex) tableIndex.getColumnIndex(FIELD_DESCRIPTION_KEY);
		privileges = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PRIVILEGES);
    }

    public static List<ApplicationPrivilegeGroup> getAll() {
        return new EntityBitSetList<>(ApplicationPrivilegeGroup.getBuilder(), table.getRecordBitSet());
    }

    public static List<ApplicationPrivilegeGroup> sort(List<ApplicationPrivilegeGroup> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<ApplicationPrivilegeGroup> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, ApplicationPrivilegeGroup.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplicationPrivilegeGroup() {
        super(table);
    }

    public UdbApplicationPrivilegeGroup(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public ApplicationPrivilegeGroup build() {
        return new UdbApplicationPrivilegeGroup();
    }

    @Override
    public ApplicationPrivilegeGroup build(int id) {
        return new UdbApplicationPrivilegeGroup(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public ApplicationPrivilegeGroup setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Application getApplication() {
		if (isChanged(application)) {
			return (Application) getReferenceChangeValue(application);
		} else {
			int id = application.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ApplicationPrivilegeGroup setApplication(Application value) {
		setSingleReferenceValue(application, value, table);
		return this;
	}

	@Override
	public ApplicationPrivilegeGroupType getApplicationPrivilegeGroupType() {
	    return getEnumValue(applicationPrivilegeGroupType, ApplicationPrivilegeGroupType.values());
	}

	@Override
	public ApplicationPrivilegeGroup setApplicationPrivilegeGroupType(ApplicationPrivilegeGroupType value) {
    	setEnumValue(this.applicationPrivilegeGroupType, value);
		return this;
	}

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public ApplicationPrivilegeGroup setName(String value) {
	    setTextValue(value, this.name);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public ApplicationPrivilegeGroup setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public String getTitleKey() {
        return getTextValue(titleKey);
	}

	@Override
	public ApplicationPrivilegeGroup setTitleKey(String value) {
	    setTextValue(value, this.titleKey);
		return this;
	}

	@Override
	public String getDescriptionKey() {
        return getTextValue(descriptionKey);
	}

	@Override
	public ApplicationPrivilegeGroup setDescriptionKey(String value) {
	    setTextValue(value, this.descriptionKey);
		return this;
	}

	@Override
	public List<ApplicationPrivilege> getPrivileges() {
	    return getMultiReferenceValue(privileges, ApplicationPrivilege.getBuilder());
	}

	@Override
	public ApplicationPrivilegeGroup setPrivileges(List<ApplicationPrivilege> value) {
		setMultiReferenceValue(value, privileges);
		return this;
	}

	@Override
	public int getPrivilegesCount() {
	    return getMultiReferenceValueCount(privileges, ApplicationPrivilege.getBuilder());
	}

	@Override
	public ApplicationPrivilegeGroup setPrivileges(ApplicationPrivilege ... value) {
		setMultiReferenceValue(Arrays.asList(value), privileges);
		return this;
	}

	@Override
	public BitSet getPrivilegesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(privileges, ApplicationPrivilege.getBuilder());
	}

	@Override
	public ApplicationPrivilegeGroup addPrivileges(List<ApplicationPrivilege> value) {
		addMultiReferenceValue(value, privileges);
		return this;
	}

	@Override
	public ApplicationPrivilegeGroup addPrivileges(ApplicationPrivilege ... value) {
		addMultiReferenceValue(Arrays.asList(value), privileges);
		return this;
	}

	@Override
	public ApplicationPrivilegeGroup removePrivileges(List<ApplicationPrivilege> value) {
		removeMultiReferenceValue(value, privileges);
		return this;
	}

	@Override
	public ApplicationPrivilegeGroup removePrivileges(ApplicationPrivilege ... value) {
		removeMultiReferenceValue(Arrays.asList(value), privileges);
		return this;
	}

	@Override
	public ApplicationPrivilegeGroup removeAllPrivileges() {
		removeAllMultiReferenceValue(privileges);
		return this;
	}


    @Override
    public UdbApplicationPrivilegeGroup save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbApplicationPrivilegeGroup saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbApplicationPrivilegeGroup save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }
}



