package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbLanguage extends AbstractUdbEntity<Language> implements Language {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static TextIndex isoCode;
	protected static TextIndex icon;
	protected static TextIndex englishDisplayName;
	protected static BooleanIndex nonLatinScript;
	protected static BooleanIndex rightToLeftLanguage;
	protected static SingleReferenceIndex localizationKey;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		isoCode = (TextIndex) tableIndex.getColumnIndex(FIELD_ISO_CODE);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		englishDisplayName = (TextIndex) tableIndex.getColumnIndex(FIELD_ENGLISH_DISPLAY_NAME);
		nonLatinScript = (BooleanIndex) tableIndex.getColumnIndex(FIELD_NON_LATIN_SCRIPT);
		rightToLeftLanguage = (BooleanIndex) tableIndex.getColumnIndex(FIELD_RIGHT_TO_LEFT_LANGUAGE);
		localizationKey = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_LOCALIZATION_KEY);
    }

    public static List<Language> getAll() {
        return new EntityBitSetList<>(Language.getBuilder(), table.getRecordBitSet());
    }

    public static List<Language> sort(List<Language> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<Language> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, Language.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbLanguage() {
        super(table);
    }

    public UdbLanguage(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public Language build() {
        return new UdbLanguage();
    }

    @Override
    public Language build(int id) {
        return new UdbLanguage(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public Language setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public Language setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public Language setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public Language setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public Language setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public Language setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public Language setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public Language setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public Language setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public Language setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public Language setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public Language setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public String getIsoCode() {
        return getTextValue(isoCode);
	}

	@Override
	public Language setIsoCode(String value) {
	    setTextValue(value, this.isoCode);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public Language setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public String getEnglishDisplayName() {
        return getTextValue(englishDisplayName);
	}

	@Override
	public Language setEnglishDisplayName(String value) {
	    setTextValue(value, this.englishDisplayName);
		return this;
	}

	@Override
	public boolean getNonLatinScript() {
	    return getBooleanValue(nonLatinScript);
	}

	@Override
	public Language setNonLatinScript(boolean value) {
	    setBooleanValue(value, this.nonLatinScript);
		return this;
	}

	@Override
	public boolean isNonLatinScript() {
	    return getBooleanValue(nonLatinScript);
	}

	@Override
	public boolean getRightToLeftLanguage() {
	    return getBooleanValue(rightToLeftLanguage);
	}

	@Override
	public Language setRightToLeftLanguage(boolean value) {
	    setBooleanValue(value, this.rightToLeftLanguage);
		return this;
	}

	@Override
	public boolean isRightToLeftLanguage() {
	    return getBooleanValue(rightToLeftLanguage);
	}

	@Override
	public LocalizationKey getLocalizationKey() {
		if (isChanged(localizationKey)) {
			return (LocalizationKey) getReferenceChangeValue(localizationKey);
		} else {
			int id = localizationKey.getValue(getId());
			if (id > 0) {
				return LocalizationKey.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Language setLocalizationKey(LocalizationKey value) {
		setSingleReferenceValue(localizationKey, value, table);
		return this;
	}


    @Override
    public UdbLanguage save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbLanguage saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbLanguage save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }
}



