package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbLocalizationTopicQuery extends AbstractUdbQuery<LocalizationTopic> implements LocalizationTopicQuery {

    public UdbLocalizationTopicQuery() {
        super(UdbLocalizationTopic.table, LocalizationTopic.getBuilder());
    }

	@Override
	public LocalizationTopicQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbLocalizationTopic.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public LocalizationTopicQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbLocalizationTopic.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public LocalizationTopicQuery metaCreationDate(NumericFilter filter) {
		and(UdbLocalizationTopic.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbLocalizationTopic.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery metaCreatedBy(NumericFilter filter) {
		and(UdbLocalizationTopic.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbLocalizationTopic.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery metaModificationDate(NumericFilter filter) {
		and(UdbLocalizationTopic.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbLocalizationTopic.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery metaModifiedBy(NumericFilter filter) {
		and(UdbLocalizationTopic.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbLocalizationTopic.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery metaDeletionDate(NumericFilter filter) {
		and(UdbLocalizationTopic.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbLocalizationTopic.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery metaDeletedBy(NumericFilter filter) {
		and(UdbLocalizationTopic.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbLocalizationTopic.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery filterKeys(LocalizationKeyQuery query) {
		UdbLocalizationKeyQuery udbQuery = (UdbLocalizationKeyQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbLocalizationTopic.keys, UdbLocalizationKey.topics);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public LocalizationTopicQuery keys(MultiReferenceFilterType type, LocalizationKey ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (LocalizationKey value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbLocalizationTopic.keys.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery keysCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbLocalizationTopic.keys.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery keys(MultiReferenceFilter filter) {
		and(UdbLocalizationTopic.keys.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orKeys(MultiReferenceFilter filter) {
		or(UdbLocalizationTopic.keys.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery filterApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbLocalizationTopic.application);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public LocalizationTopicQuery application(NumericFilter filter) {
		and(UdbLocalizationTopic.application.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orApplication(NumericFilter filter) {
		or(UdbLocalizationTopic.application.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery icon(TextFilter filter) {
		and(UdbLocalizationTopic.icon.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orIcon(TextFilter filter) {
		or(UdbLocalizationTopic.icon.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery title(TextFilter filter) {
		and(UdbLocalizationTopic.title.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orTitle(TextFilter filter) {
		or(UdbLocalizationTopic.title.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery screenshot(FileFilter filter) {
		and(UdbLocalizationTopic.screenshot.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationTopicQuery orScreenshot(FileFilter filter) {
		or(UdbLocalizationTopic.screenshot.createFilter(filter));
		return this;
	}


	@Override
	public UdbLocalizationTopicQuery andOr(LocalizationTopicQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public LocalizationTopicQuery customFilter(Function<LocalizationTopic, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(LocalizationTopic.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



