package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbLoginQuery extends AbstractUdbQuery<Login> implements LoginQuery {

    public UdbLoginQuery() {
        super(UdbLogin.table, Login.getBuilder());
    }

	@Override
	public LoginQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbLogin.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public LoginQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbLogin.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public LoginQuery metaDeletionDate(NumericFilter filter) {
		and(UdbLogin.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbLogin.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery metaDeletedBy(NumericFilter filter) {
		and(UdbLogin.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbLogin.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery filterUser(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbLogin.user);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public LoginQuery user(NumericFilter filter) {
		and(UdbLogin.user.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orUser(NumericFilter filter) {
		or(UdbLogin.user.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery ip(TextFilter filter) {
		and(UdbLogin.ip.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orIp(TextFilter filter) {
		or(UdbLogin.ip.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery userAgent(TextFilter filter) {
		and(UdbLogin.userAgent.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orUserAgent(TextFilter filter) {
		or(UdbLogin.userAgent.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery mobileDevice(BooleanFilter filter) {
		and(UdbLogin.mobileDevice.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orMobileDevice(BooleanFilter filter) {
		or(UdbLogin.mobileDevice.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery screenSize(TextFilter filter) {
		and(UdbLogin.screenSize.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orScreenSize(TextFilter filter) {
		or(UdbLogin.screenSize.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery dateLogin(NumericFilter filter) {
		and(UdbLogin.dateLogin.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orDateLogin(NumericFilter filter) {
		or(UdbLogin.dateLogin.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery dateLogout(NumericFilter filter) {
		and(UdbLogin.dateLogout.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orDateLogout(NumericFilter filter) {
		or(UdbLogin.dateLogout.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery activityCount(NumericFilter filter) {
		and(UdbLogin.activityCount.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orActivityCount(NumericFilter filter) {
		or(UdbLogin.activityCount.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery applicationOpenCount(NumericFilter filter) {
		and(UdbLogin.applicationOpenCount.createFilter(filter));
		return this;
	}

	@Override
	public LoginQuery orApplicationOpenCount(NumericFilter filter) {
		or(UdbLogin.applicationOpenCount.createFilter(filter));
		return this;
	}


	@Override
	public UdbLoginQuery andOr(LoginQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public LoginQuery customFilter(Function<Login, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(Login.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



