package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbManagedApplicationPerspectiveQuery extends AbstractUdbQuery<ManagedApplicationPerspective> implements ManagedApplicationPerspectiveQuery {

    public UdbManagedApplicationPerspectiveQuery() {
        super(UdbManagedApplicationPerspective.table, ManagedApplicationPerspective.getBuilder());
    }

	@Override
	public ManagedApplicationPerspectiveQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbManagedApplicationPerspective.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbManagedApplicationPerspective.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery metaCreationDate(NumericFilter filter) {
		and(UdbManagedApplicationPerspective.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbManagedApplicationPerspective.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery metaCreatedBy(NumericFilter filter) {
		and(UdbManagedApplicationPerspective.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbManagedApplicationPerspective.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery metaModificationDate(NumericFilter filter) {
		and(UdbManagedApplicationPerspective.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbManagedApplicationPerspective.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery metaModifiedBy(NumericFilter filter) {
		and(UdbManagedApplicationPerspective.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbManagedApplicationPerspective.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery metaDeletionDate(NumericFilter filter) {
		and(UdbManagedApplicationPerspective.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbManagedApplicationPerspective.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery metaDeletedBy(NumericFilter filter) {
		and(UdbManagedApplicationPerspective.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbManagedApplicationPerspective.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery filterManagedApplication(ManagedApplicationQuery query) {
		UdbManagedApplicationQuery udbQuery = (UdbManagedApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbManagedApplicationPerspective.managedApplication, UdbManagedApplication.perspectives);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery managedApplication(NumericFilter filter) {
		and(UdbManagedApplicationPerspective.managedApplication.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orManagedApplication(NumericFilter filter) {
		or(UdbManagedApplicationPerspective.managedApplication.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery filterApplicationPerspective(ApplicationPerspectiveQuery query) {
		UdbApplicationPerspectiveQuery udbQuery = (UdbApplicationPerspectiveQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbManagedApplicationPerspective.applicationPerspective, UdbApplicationPerspective.managedPerspectives);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery applicationPerspective(NumericFilter filter) {
		and(UdbManagedApplicationPerspective.applicationPerspective.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orApplicationPerspective(NumericFilter filter) {
		or(UdbManagedApplicationPerspective.applicationPerspective.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery iconOverride(TextFilter filter) {
		and(UdbManagedApplicationPerspective.iconOverride.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orIconOverride(TextFilter filter) {
		or(UdbManagedApplicationPerspective.iconOverride.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery titleKeyOverride(TextFilter filter) {
		and(UdbManagedApplicationPerspective.titleKeyOverride.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orTitleKeyOverride(TextFilter filter) {
		or(UdbManagedApplicationPerspective.titleKeyOverride.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery descriptionKeyOverride(TextFilter filter) {
		and(UdbManagedApplicationPerspective.descriptionKeyOverride.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orDescriptionKeyOverride(TextFilter filter) {
		or(UdbManagedApplicationPerspective.descriptionKeyOverride.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery toolbarPerspectiveMenu(BooleanFilter filter) {
		and(UdbManagedApplicationPerspective.toolbarPerspectiveMenu.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orToolbarPerspectiveMenu(BooleanFilter filter) {
		or(UdbManagedApplicationPerspective.toolbarPerspectiveMenu.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery listingPosition(NumericFilter filter) {
		and(UdbManagedApplicationPerspective.listingPosition.createFilter(filter));
		return this;
	}

	@Override
	public ManagedApplicationPerspectiveQuery orListingPosition(NumericFilter filter) {
		or(UdbManagedApplicationPerspective.listingPosition.createFilter(filter));
		return this;
	}


	@Override
	public UdbManagedApplicationPerspectiveQuery andOr(ManagedApplicationPerspectiveQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ManagedApplicationPerspectiveQuery customFilter(Function<ManagedApplicationPerspective, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ManagedApplicationPerspective.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



