package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbOrganizationUnitQuery extends AbstractUdbQuery<OrganizationUnit> implements OrganizationUnitQuery {

    public UdbOrganizationUnitQuery() {
        super(UdbOrganizationUnit.table, OrganizationUnit.getBuilder());
    }

	@Override
	public OrganizationUnitQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbOrganizationUnit.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbOrganizationUnit.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitQuery metaCreationDate(NumericFilter filter) {
		and(UdbOrganizationUnit.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbOrganizationUnit.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery metaCreatedBy(NumericFilter filter) {
		and(UdbOrganizationUnit.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbOrganizationUnit.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery metaModificationDate(NumericFilter filter) {
		and(UdbOrganizationUnit.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbOrganizationUnit.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery metaModifiedBy(NumericFilter filter) {
		and(UdbOrganizationUnit.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbOrganizationUnit.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery metaDeletionDate(NumericFilter filter) {
		and(UdbOrganizationUnit.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbOrganizationUnit.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery metaDeletedBy(NumericFilter filter) {
		and(UdbOrganizationUnit.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbOrganizationUnit.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery name(TranslatableTextFilter filter) {
		and(UdbOrganizationUnit.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orName(TranslatableTextFilter filter) {
		or(UdbOrganizationUnit.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery filterParent(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnit.parent, UdbOrganizationUnit.children);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitQuery parent(NumericFilter filter) {
		and(UdbOrganizationUnit.parent.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orParent(NumericFilter filter) {
		or(UdbOrganizationUnit.parent.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery filterChildren(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnit.children, UdbOrganizationUnit.parent);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitQuery children(MultiReferenceFilterType type, OrganizationUnit ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnit value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbOrganizationUnit.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery childrenCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbOrganizationUnit.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery children(MultiReferenceFilter filter) {
		and(UdbOrganizationUnit.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orChildren(MultiReferenceFilter filter) {
		or(UdbOrganizationUnit.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery filterType(OrganizationUnitTypeQuery query) {
		UdbOrganizationUnitTypeQuery udbQuery = (UdbOrganizationUnitTypeQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnit.type);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitQuery type(NumericFilter filter) {
		and(UdbOrganizationUnit.type.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orType(NumericFilter filter) {
		or(UdbOrganizationUnit.type.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery icon(TextFilter filter) {
		and(UdbOrganizationUnit.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orIcon(TextFilter filter) {
		or(UdbOrganizationUnit.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery filterAddress(AddressQuery query) {
		UdbAddressQuery udbQuery = (UdbAddressQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnit.address);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitQuery address(NumericFilter filter) {
		and(UdbOrganizationUnit.address.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orAddress(NumericFilter filter) {
		or(UdbOrganizationUnit.address.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery filterUsers(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnit.users, UdbUser.organizationUnit);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitQuery users(MultiReferenceFilterType type, User ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (User value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbOrganizationUnit.users.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery usersCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbOrganizationUnit.users.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery users(MultiReferenceFilter filter) {
		and(UdbOrganizationUnit.users.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitQuery orUsers(MultiReferenceFilter filter) {
		or(UdbOrganizationUnit.users.createFilter(filter));
		return this;
	}


	@Override
	public UdbOrganizationUnitQuery andOr(OrganizationUnitQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public OrganizationUnitQuery customFilter(Function<OrganizationUnit, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(OrganizationUnit.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



