/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.translations;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.application.server.controlcenter.translations.TranslationMode;
import org.teamapps.application.server.controlcenter.translations.TranslationUtils;
import org.teamapps.application.server.controlcenter.translations.TranslationWorkState;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.localization.LocalizationUtil;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.ui.dialogue.UploadDialogue;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.icons.composite.CompositeIcon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationTopic;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.model.controlcenter.TranslationState;
import org.teamapps.model.controlcenter.TranslationVerificationState;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.MultiLineTextField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.session.SessionContext;

public class TranslationsPerspective
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData;
    private final UserSessionData userSessionData;
    private final TwoWayBindableValue<LocalizationKey> selectedKey = TwoWayBindableValue.create();
    private String currentTranslationLanguage;
    private String currentTemplate1;
    private String currentTemplate2;
    private boolean language1Visible;
    private boolean language2Visible;
    private boolean machineTranslationVisible;

    public TranslationsPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        View localizationKeyView = View.createView((String)"center", (Icon)ApplicationIcons.SPELL_CHECK, (String)this.getLocalized("translations.overView"), null);
        View topicImageView = View.createView((String)"center-bottom", (Icon)ApplicationIcons.FORM, (String)this.getLocalized("org.teamapps.dictionary.previewImage"), null);
        View translationView = View.createView((String)"right", (Icon)ApplicationIcons.SPELL_CHECK, (String)this.getLocalized("translations.translation"), null);
        localizationKeyView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        translationView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        topicImageView.setVisible(false);
        ToolbarButtonGroup buttonGroup = localizationKeyView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton overViewButtonOn = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.SPELL_CHECK, (Icon)ApplicationIcons.CHECKBOX), (String)this.getLocalized("translations.overView"), (String)this.getLocalized("translations.showOverView")));
        ToolbarButton overViewButtonOff = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.SPELL_CHECK, (Icon)ApplicationIcons.DELETE), (String)this.getLocalized("translations.overView"), (String)this.getLocalized("translations.hideOverView")));
        overViewButtonOn.setVisible(false);
        buttonGroup = localizationKeyView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton startMachineTranslationButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.GEARWHEELS, (Icon)ApplicationIcons.MESSAGES), (String)this.getLocalized("translations.startMachineTranslation"), (String)this.getLocalized("translations.translateAllNewEntries")));
        ToolbarButton createTranslationFilesButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.FOLDER_ZIP, (Icon)ApplicationIcons.EARTH), (String)this.getLocalized("translations.createTranslationFiles"), (String)this.getLocalized("translations.createApplicationResourceFiles")));
        ToolbarButton exportTranslationsButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.BOX_OUT, (Icon)ApplicationIcons.EARTH), (String)this.getLocalized("org.teamapps.dictionary.export"), (String)this.getLocalized("translations.exportTranslations")));
        ToolbarButton importTranslationsButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.BOX_INTO, (Icon)ApplicationIcons.EARTH), (String)this.getLocalized("org.teamapps.dictionary.import"), (String)this.getLocalized("translations.importTranslations")));
        buttonGroup = translationView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton previousButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.NAVIGATE_LEFT, (String)this.getLocalized("org.teamapps.dictionary.previous")));
        ToolbarButton nextButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.NAVIGATE_RIGHT, (String)this.getLocalized("org.teamapps.dictionary.next")));
        buttonGroup = translationView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton doneButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.OK, (String)this.getLocalized("org.teamapps.dictionary.done")));
        ToolbarButton unclearButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.DELETE, (String)this.getLocalized("org.teamapps.dictionary.unclear")));
        buttonGroup = translationView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton verifiedButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.CHECKS, (String)this.getLocalized("org.teamapps.dictionary.verified")));
        ToolbarButton incorrectButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.SIGN_WARNING, (String)this.getLocalized("org.teamapps.dictionary.incorrect")));
        buttonGroup = translationView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton copyTranslationButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.COPY, (String)this.getLocalized("translations.copyTranslation")));
        buttonGroup = translationView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveAdminValuesButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISKS, (String)this.getLocalized("org.teamapps.dictionary.save")));
        ComboBox languageCombo = Language.createComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        ComboBox template1Combo = Language.createComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        ComboBox template2Combo = Language.createComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        template2Combo.setShowClearButton(true);
        ComboBox<TranslationWorkState> workStateComboBox = this.createWorkStateComboBox();
        ComboBox<LocalizationTopic> topicComboBox = this.createTopicComboBox();
        ComboBox<TranslationMode> modeComboBox = this.createTranslationModeComboBox();
        workStateComboBox.setValue((Object)TranslationWorkState.ALL);
        modeComboBox.setValue((Object)TranslationMode.TRANSLATE);
        languageCombo.setValue((Object)Language.FR_FRENCH);
        template1Combo.setValue((Object)Language.EN_ENGLISH);
        template2Combo.setValue((Object)Language.DE_GERMAN);
        this.currentTranslationLanguage = "fr";
        this.currentTemplate1 = "en";
        this.currentTemplate2 = "de";
        ResponsiveForm selectionForm = new ResponsiveForm(50, 75, 200);
        selectionForm.setMargin(Spacing.px((int)0));
        ResponsiveFormLayout formLayout = selectionForm.addResponsiveFormLayout(500);
        formLayout.addSection().setCollapsible(false).setPadding(new Spacing(0, 5)).setMargin(new Spacing(4, 2, 4, 2));
        formLayout.addLabelAndField(null, this.getLocalized("translations.translation"), (AbstractField)languageCombo);
        formLayout.addLabelAndField(null, this.getLocalized("translations.status"), workStateComboBox, false);
        formLayout.addLabelAndField(null, this.getLocalized("translations.template1"), (AbstractField)template1Combo);
        formLayout.addLabelAndField(null, this.getLocalized("translations.topic"), topicComboBox, false);
        formLayout.addLabelAndField(null, this.getLocalized("translations.template2"), (AbstractField)template2Combo);
        formLayout.addLabelAndField(null, this.getLocalized("translations.mode"), modeComboBox, false);
        EntityModelBuilder keyModelBuilder = new EntityModelBuilder(() -> this.isAppFilter() ? LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)this.getMainApplication().getId())) : LocalizationKey.filter(), this.getApplicationInstanceData());
        keyModelBuilder.updateModels();
        keyModelBuilder.attachSearchField(localizationKeyView);
        keyModelBuilder.attachViewCountHandler(localizationKeyView, () -> this.getLocalized("translations.overView"));
        keyModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedKey.set(arg_0));
        Table keyTable = keyModelBuilder.createTable();
        keyTable.setDisplayAsList(true);
        keyTable.setStripedRows(false);
        keyTable.setCssStyle("background-color", "white");
        keyTable.setCssStyle("border-top", "1px solid " + Color.MATERIAL_GREY_400.toHtmlColorString());
        keyTable.setRowHeight(28);
        keyTable.setPropertyProvider((key, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map<String, LocalizationValue> valueMap = TranslationUtils.getValueMap(key);
            map.put("key", key.getKey());
            map.put("language", valueMap.get(this.currentTranslationLanguage));
            map.put("status", valueMap.get(this.currentTranslationLanguage));
            map.put("template1", valueMap.get(this.currentTemplate1));
            map.put("template2", valueMap.get(this.currentTemplate2));
            return map;
        });
        TemplateField<LocalizationValue> template1Column = this.createLocalizationValueTemplateField(true, false);
        TemplateField<LocalizationValue> template2Column = this.createLocalizationValueTemplateField(true, false);
        TemplateField<LocalizationValue> languageColumn = this.createLocalizationValueTemplateField(false, false);
        TemplateField<LocalizationValue> stateColumn = this.createLocalizationValueTemplateField(true, true);
        keyTable.addColumn(new TableColumn("template1", this.getLocalized("translations.template1"), template1Column).setDefaultWidth(230));
        keyTable.addColumn(new TableColumn("template2", this.getLocalized("translations.template2"), template2Column).setDefaultWidth(230));
        keyTable.addColumn(new TableColumn("language", this.getLocalized("translations.translationLanguage"), languageColumn).setDefaultWidth(230));
        keyTable.addColumn(new TableColumn("status", this.getLocalized("translations.status"), stateColumn).setDefaultWidth(170));
        keyTable.addColumn(new TableColumn("key", this.getLocalized("translations.key"), (AbstractField)new TextField()).setDefaultWidth(300));
        Function<String, String> languageByTableFieldNameFunction = field -> switch (field) {
            case "template1" -> this.currentTemplate1;
            case "template2" -> this.currentTemplate2;
            case "language" -> this.currentTranslationLanguage;
            default -> null;
        };
        keyModelBuilder.setCustomFieldSorter(fieldName -> {
            if (fieldName.equals("key")) {
                return Comparator.comparing(LocalizationKey::getKey, Comparator.nullsFirst(String::compareToIgnoreCase));
            }
            if (fieldName.equals("status")) {
                // empty if block
            }
            String language = (String)languageByTableFieldNameFunction.apply((String)fieldName);
            Comparator userStringComparator = this.getUser().getComparator(true);
            if (language != null) {
                return (k1, k2) -> userStringComparator.compare(TranslationUtils.getDisplayValueNonNull(k1, language), TranslationUtils.getDisplayValueNonNull(k2, language));
            }
            return null;
        });
        keyModelBuilder.setCustomFullTextFilter((localizationKey, s) -> {
            if (localizationKey.getKey().toLowerCase().contains((CharSequence)s)) {
                return true;
            }
            Map<String, LocalizationValue> valueMap = TranslationUtils.getValueMap(localizationKey);
            if (this.matchLocalizationValue((String)s, this.currentTemplate1, valueMap).booleanValue()) {
                return true;
            }
            if (this.matchLocalizationValue((String)s, this.currentTemplate2, valueMap).booleanValue()) {
                return true;
            }
            if (this.matchLocalizationValue((String)s, this.currentTranslationLanguage, valueMap).booleanValue()) {
                return true;
            }
            return false;
        });
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponent((Component)selectionForm);
        verticalLayout.addComponentFillRemaining((Component)keyTable);
        localizationKeyView.setComponent((Component)verticalLayout);
        TemplateField<LocalizationValue> template1HeaderField = this.createLocalizationValueHeaderField(true);
        TemplateField<LocalizationValue> template2HeaderField = this.createLocalizationValueHeaderField(true);
        TemplateField<LocalizationValue> machineTranslationHeaderField = this.createLocalizationValueHeaderField(true);
        TemplateField<LocalizationValue> translationHeaderField = this.createLocalizationValueHeaderField(true);
        DisplayField template1ValueField = new DisplayField(true, false);
        DisplayField template2ValueField = new DisplayField(true, false);
        DisplayField machineTranslationValueField = new DisplayField(true, false);
        MultiLineTextField translationField = new MultiLineTextField();
        translationField.setCssStyle("height", "100px");
        MultiLineTextField adminLocalOverrideField = new MultiLineTextField();
        adminLocalOverrideField.setCssStyle("height", "100px");
        MultiLineTextField adminKeyOverrideField = new MultiLineTextField();
        adminKeyOverrideField.setCssStyle("height", "100px");
        MultiLineTextField keyCommentsField = new MultiLineTextField();
        keyCommentsField.setCssStyle("height", "100px");
        MultiLineTextField proofReadNotesField = new MultiLineTextField();
        proofReadNotesField.setCssStyle("height", "100px");
        template1ValueField.setCssStyle(".field-border", "border-color", "#ec9a1a");
        template1ValueField.setCssStyle(".field-border-glow", "box-shadow", "0 0 3px 0 #ec9a1a");
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        formLayout = form.addResponsiveFormLayout(500);
        formLayout.addSection(null, this.getLocalized("translations.template1")).setCollapsible(false).setDrawHeaderLine(false).setHideWhenNoVisibleFields(true);
        formLayout.addComponent(0, 0, template1HeaderField);
        formLayout.addComponent(0, 1, (Component)template1ValueField);
        formLayout.addSection(null, this.getLocalized("translations.template2")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        formLayout.addComponent(0, 0, template2HeaderField);
        formLayout.addComponent(0, 1, (Component)template2ValueField);
        formLayout.addSection(null, this.getLocalized("translations.automaticTranslation")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        formLayout.addComponent(0, 0, machineTranslationHeaderField);
        formLayout.addComponent(0, 1, (Component)machineTranslationValueField);
        formLayout.addSection(null, this.getLocalized("translations.translation")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        formLayout.addComponent(0, 0, translationHeaderField);
        formLayout.addComponent(0, 1, (Component)translationField);
        formLayout.addSection(null, this.getLocalized("translations.mode.proofread")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        formLayout.addLabelAndField(null, this.getLocalized("translations.errorNotes"), (AbstractField)proofReadNotesField);
        formLayout.addSection(null, this.getLocalized("translations.administration")).setCollapsible(false).setDrawHeaderLine(true).setHideWhenNoVisibleFields(true);
        formLayout.addLabelAndField(null, this.getLocalized("translations.translationNotes"), (AbstractField)keyCommentsField);
        formLayout.addLabelAndField(null, this.getLocalized("translations.finalTranslationLocal"), (AbstractField)adminLocalOverrideField);
        formLayout.addLabelAndField(null, this.getLocalized("translations.finalTranslationGlobal"), (AbstractField)adminKeyOverrideField);
        FormMetaFields formMetaFields = this.getApplicationInstanceData().getComponentFactory().createFormMetaFields();
        formMetaFields.addMetaFields(formLayout, false);
        this.selectedKey.onChanged().addListener(arg_0 -> ((FormMetaFields)formMetaFields).updateEntity(arg_0));
        translationView.setComponent((Component)form);
        this.getPerspective().addView(localizationKeyView);
        this.getPerspective().addView(topicImageView);
        this.getPerspective().addView(translationView);
        Consumer<TranslationMode> translationModeChangeHandler = translationMode -> {
            if (translationMode == null) {
                translationMode = this.getAvailableModes().get(0);
            }
            switch (translationMode) {
                case TRANSLATE: {
                    doneButton.setVisible(true);
                    unclearButton.setVisible(true);
                    copyTranslationButton.setVisible(true);
                    verifiedButton.setVisible(false);
                    incorrectButton.setVisible(false);
                    saveAdminValuesButton.setVisible(false);
                    proofReadNotesField.setVisible(false);
                    workStateComboBox.setValue((Object)TranslationWorkState.TRANSLATION_REQUIRED);
                    adminLocalOverrideField.setVisible(false);
                    adminKeyOverrideField.setVisible(false);
                    keyCommentsField.setVisible(false);
                    break;
                }
                case PROOFREAD: {
                    doneButton.setVisible(false);
                    unclearButton.setVisible(false);
                    copyTranslationButton.setVisible(false);
                    verifiedButton.setVisible(true);
                    incorrectButton.setVisible(true);
                    saveAdminValuesButton.setVisible(false);
                    proofReadNotesField.setVisible(true);
                    workStateComboBox.setValue((Object)TranslationWorkState.VERIFICATION_REQUIRED);
                    adminLocalOverrideField.setVisible(false);
                    adminKeyOverrideField.setVisible(false);
                    keyCommentsField.setVisible(false);
                    break;
                }
                case ADMINISTRATE: {
                    doneButton.setVisible(false);
                    unclearButton.setVisible(false);
                    copyTranslationButton.setVisible(false);
                    verifiedButton.setVisible(false);
                    incorrectButton.setVisible(false);
                    saveAdminValuesButton.setVisible(true);
                    proofReadNotesField.setVisible(false);
                    workStateComboBox.setValue((Object)TranslationWorkState.ALL);
                    adminLocalOverrideField.setVisible(true);
                    adminKeyOverrideField.setVisible(true);
                    keyCommentsField.setVisible(true);
                }
            }
            Predicate<LocalizationKey> filterPredicate = TranslationUtils.getFilterPredicate((TranslationWorkState)((Object)((Object)workStateComboBox.getValue())), this.currentTranslationLanguage, (LocalizationTopic)topicComboBox.getValue());
            keyModelBuilder.setCustomFilter(filterPredicate);
        };
        translationModeChangeHandler.accept(this.getAvailableModes().get(0));
        startMachineTranslationButton.onClick.addListener(() -> LocalizationUtil.translateAllValues(this.userSessionData.getRegistry().getTranslationService(), this.userSessionData.getRegistry().getSystemConfig().getLocalizationConfig()));
        createTranslationFilesButton.onClick.addListener(() -> {
            try {
                File file = LocalizationUtil.createTranslationResourceFiles();
                SessionContext.current().downloadFile(file, "Translations.zip");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        exportTranslationsButton.onClick.addListener(() -> {
            try {
                File file = LocalizationUtil.createTranslationExport(this.isAppFilter() ? this.getMainApplication() : null);
                SessionContext.current().downloadFile(file, "Translation-Export.zip");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        importTranslationsButton.onClick.addListener(() -> UploadDialogue.createFileUploadDialogue(file -> {
            try {
                LocalizationUtil.importTranslationExport(file, this.isAppFilter() ? this.getMainApplication() : null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, this.getApplicationInstanceData()));
        modeComboBox.onValueChanged.addListener(translationModeChangeHandler);
        previousButton.onClick.addListener(() -> ((EntityModelBuilder)keyModelBuilder).selectPreviousRecord());
        nextButton.onClick.addListener(() -> ((EntityModelBuilder)keyModelBuilder).selectNextRecord());
        doneButton.onClick.addListener(() -> {
            LocalizationValue value = TranslationUtils.getValue((LocalizationKey)this.selectedKey.get(), this.currentTranslationLanguage);
            LocalizationValue templateValue = TranslationUtils.getValue((LocalizationKey)this.selectedKey.get(), this.currentTemplate1);
            String translation = (String)translationField.getValue();
            if (translation != null && value != null && templateValue != null && templateValue.getCurrentDisplayValue() != null && TranslationUtils.createTranslationStates(TranslationState.TRANSLATION_REQUESTED, TranslationState.UNCLEAR).contains((Object)value.getTranslationState())) {
                if (translation.contains("\n") && !templateValue.getCurrentDisplayValue().contains("\n")) {
                    UiUtils.showNotification((Icon)ApplicationIcons.ERROR, (String)this.getLocalized("translations.translationMayNotContainLineBreaks"));
                    return;
                }
                value.setTranslation(translation).setCurrentDisplayValue(translation).setTranslationState(TranslationState.OK).setTranslationVerificationState(TranslationVerificationState.VERIFICATION_REQUESTED).save();
                keyModelBuilder.selectNextRecord();
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        saveAdminValuesButton.onClick.addListener(() -> {
            LocalizationValue value = TranslationUtils.getValue((LocalizationKey)this.selectedKey.get(), this.currentTranslationLanguage);
            if (value != null) {
                if (keyCommentsField.getValue() != null) {
                    value.getLocalizationKey().setComments((String)keyCommentsField.getValue()).save();
                }
                value.setAdminLocalOverride((String)adminLocalOverrideField.getValue()).setAdminKeyOverride((String)adminKeyOverrideField.getValue()).save();
                if (adminLocalOverrideField.getValue() != null || adminKeyOverrideField.getValue() != null) {
                    value.setCurrentDisplayValue(adminKeyOverrideField.getValue() != null ? (String)adminKeyOverrideField.getValue() : (String)adminLocalOverrideField.getValue()).save();
                }
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        unclearButton.onClick.addListener(() -> {
            LocalizationValue value = TranslationUtils.getValue((LocalizationKey)this.selectedKey.get(), this.currentTranslationLanguage);
            if (value != null && value.getTranslationState() == TranslationState.TRANSLATION_REQUESTED) {
                value.setTranslationState(TranslationState.UNCLEAR).save();
                keyModelBuilder.selectNextRecord();
                keyModelBuilder.updateModels();
                UiUtils.showNotification((Icon)ApplicationIcons.OK, (String)this.getLocalized("translations.translationSuccessfullyRejected"));
            }
        });
        copyTranslationButton.onClick.addListener(() -> {
            LocalizationValue value = TranslationUtils.getValue((LocalizationKey)this.selectedKey.get(), this.currentTranslationLanguage);
            translationField.setValue((Object)value.getMachineTranslation());
        });
        verifiedButton.onClick.addListener(() -> {
            LocalizationValue value = TranslationUtils.getValue((LocalizationKey)this.selectedKey.get(), this.currentTranslationLanguage);
            if (value != null && value.getTranslation() != null && value.getTranslationState() == TranslationState.OK) {
                value.setTranslationVerificationState(TranslationVerificationState.OK).save();
                keyModelBuilder.selectNextRecord();
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        incorrectButton.onClick.addListener(() -> {
            LocalizationValue value = TranslationUtils.getValue((LocalizationKey)this.selectedKey.get(), this.currentTranslationLanguage);
            String notes = (String)proofReadNotesField.getValue();
            if (notes != null && value != null && value.getTranslation() != null && value.getTranslationState() == TranslationState.OK) {
                value.setTranslationVerificationState(TranslationVerificationState.CORRECTIONS_REQUIRED).setTranslationState(TranslationState.TRANSLATION_REQUESTED).setNotes(notes).save();
                keyModelBuilder.selectNextRecord();
                UiUtils.showNotification((Icon)ApplicationIcons.OK, (String)this.getLocalized("translations.translationSuccessfullyRejected"));
            }
        });
        this.selectedKey.onChanged().addListener(key -> {
            Map<String, LocalizationValue> valueMap = TranslationUtils.getValueMap(key);
            translationField.clearCustomFieldMessages();
            LocalizationValue languageValue = valueMap.get(this.currentTranslationLanguage);
            LocalizationValue template1Value = valueMap.get(this.currentTemplate1);
            LocalizationValue template2Value = valueMap.get(this.currentTemplate2);
            machineTranslationHeaderField.setValue((Object)languageValue);
            machineTranslationValueField.setValue((Object)(languageValue == null ? " --- " : (languageValue.getMachineTranslation() != null ? languageValue.getMachineTranslation() : " --- ")));
            translationHeaderField.setValue((Object)languageValue);
            translationField.setValue((Object)(languageValue != null ? languageValue.getTranslation() : null));
            template1HeaderField.setValue((Object)template1Value);
            template1ValueField.setValue((Object)(template1Value == null ? " --- " : (template1Value.getCurrentDisplayValue() != null ? template1Value.getCurrentDisplayValue() : " --- ")));
            template2HeaderField.setValue((Object)template2Value);
            template2ValueField.setValue((Object)(template2Value == null ? " --- " : (template2Value.getCurrentDisplayValue() != null ? template2Value.getCurrentDisplayValue() : " --- ")));
            if (languageValue != null) {
                if (languageValue.getLocalizationKey().getComments() != null) {
                    translationField.addCustomFieldMessage(FieldMessage.Severity.INFO, key.getComments());
                }
                if (languageValue.getNotes() != null) {
                    translationField.addCustomFieldMessage(FieldMessage.Severity.WARNING, languageValue.getNotes());
                }
            }
            proofReadNotesField.setValue((Object)(languageValue != null ? languageValue.getNotes() : null));
            adminLocalOverrideField.setValue((Object)(languageValue != null ? languageValue.getAdminLocalOverride() : null));
            adminKeyOverrideField.setValue((Object)(languageValue != null ? languageValue.getAdminKeyOverride() : null));
            keyCommentsField.setValue((Object)key.getComments());
        });
        languageCombo.onValueChanged.addListener(language -> {
            this.currentTranslationLanguage = language != null ? language.getIsoCode() : null;
            Predicate<LocalizationKey> filterPredicate = TranslationUtils.getFilterPredicate((TranslationWorkState)((Object)((Object)workStateComboBox.getValue())), this.currentTranslationLanguage, (LocalizationTopic)topicComboBox.getValue());
            keyModelBuilder.setCustomFilter(filterPredicate);
        });
        template1Combo.onValueChanged.addListener(language -> {
            this.currentTemplate1 = language != null ? language.getIsoCode() : null;
            keyModelBuilder.updateModels();
        });
        template2Combo.onValueChanged.addListener(language -> {
            this.currentTemplate2 = language != null ? language.getIsoCode() : null;
            keyModelBuilder.updateModels();
        });
        workStateComboBox.onValueChanged.addListener(state -> {
            Predicate<LocalizationKey> filterPredicate = state != null ? TranslationUtils.getFilterPredicate(state, this.currentTranslationLanguage, (LocalizationTopic)topicComboBox.getValue()) : null;
            keyModelBuilder.setCustomFilter(filterPredicate);
        });
        topicComboBox.onValueChanged.addListener(topic -> {
            Predicate<LocalizationKey> filterPredicate = TranslationUtils.getFilterPredicate((TranslationWorkState)((Object)((Object)workStateComboBox.getValue())), this.currentTranslationLanguage, topic);
            keyModelBuilder.setCustomFilter(filterPredicate);
        });
    }

    private Boolean matchLocalizationValue(String query, String language, Map<String, LocalizationValue> valueMap) {
        String displayValue;
        LocalizationValue localizationValue = valueMap.get(language);
        if (localizationValue != null && (displayValue = localizationValue.getCurrentDisplayValue()) != null && displayValue.toLowerCase().contains(query)) {
            return true;
        }
        return false;
    }

    private TemplateField<LocalizationValue> createLocalizationValueHeaderField(boolean skipState) {
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        templateField.setPropertyProvider((value, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (value == null) {
                return map;
            }
            Language language = Language.getLanguageByIsoCode((String)value.getLanguage());
            map.put("icon", language.getIcon());
            Object title = language.getLanguageLocalized((ApplicationLocalizationProvider)this.getApplicationInstanceData());
            if (!skipState) {
                title = (String)title + " (" + this.getLocalizationStateText((LocalizationValue)value) + ")";
            }
            map.put("caption", title);
            return map;
        });
        return templateField;
    }

    private TemplateField<LocalizationValue> createLocalizationValueTemplateField(boolean withStateIcon, boolean withStateText) {
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        templateField.setPropertyProvider((value, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (value == null) {
                return map;
            }
            if (withStateIcon) {
                map.put("icon", this.getLocalizationStateIcon((LocalizationValue)value));
            }
            if (withStateText) {
                map.put("caption", this.getLocalizationStateText((LocalizationValue)value));
            } else {
                map.put("caption", value.getCurrentDisplayValue());
            }
            return map;
        });
        return templateField;
    }

    private Icon getLocalizationStateIcon(LocalizationValue value) {
        if (value == null) {
            return null;
        }
        return switch (value.getTranslationVerificationState()) {
            case TranslationVerificationState.VERIFICATION_REQUESTED -> ApplicationIcons.CHECKS;
            case TranslationVerificationState.OK -> ApplicationIcons.OK;
            case TranslationVerificationState.CORRECTIONS_REQUIRED -> ApplicationIcons.SIGN_WARNING;
            default -> {
                switch (value.getTranslationState()) {
                    case TRANSLATION_REQUESTED: {
                        yield ApplicationIcons.BRIEFCASE;
                    }
                    case UNCLEAR: {
                        yield ApplicationIcons.QUESTION;
                    }
                    case NOT_NECESSARY: {
                        yield ApplicationIcons.OK;
                    }
                }
                yield ApplicationIcons.FOLDER;
            }
        };
    }

    private String getLocalizationStateText(LocalizationValue value) {
        if (value == null) {
            return null;
        }
        return switch (value.getTranslationVerificationState()) {
            case TranslationVerificationState.VERIFICATION_REQUESTED -> this.getLocalized(TranslationWorkState.VERIFICATION_REQUIRED.getTranslationKey());
            case TranslationVerificationState.OK -> this.getLocalized(TranslationWorkState.VERIFIED.getTranslationKey());
            case TranslationVerificationState.CORRECTIONS_REQUIRED -> this.getLocalized(TranslationWorkState.CORRECTIONS_REQUIRED.getTranslationKey());
            default -> {
                switch (value.getTranslationState()) {
                    case TRANSLATION_REQUESTED: {
                        yield this.getLocalized(TranslationWorkState.TRANSLATION_REQUIRED.getTranslationKey());
                    }
                    case UNCLEAR: {
                        yield this.getLocalized(TranslationWorkState.UNCLEAR.getTranslationKey());
                    }
                    case NOT_NECESSARY: {
                        yield this.getLocalized(TranslationWorkState.TRANSLATION_NOT_NECESSARY.getTranslationKey());
                    }
                }
                yield "?";
            }
        };
    }

    private ComboBox<TranslationWorkState> createWorkStateComboBox() {
        PropertyExtractor propertyExtractor = (workState, propertyName) -> switch (propertyName) {
            case "icon" -> workState.getIcon();
            case "caption" -> this.getLocalized(workState.getTranslationKey());
            default -> null;
        };
        ComboBox comboBox = ComboBoxUtils.createRecordComboBox(Arrays.asList(TranslationWorkState.values()), (PropertyProvider)propertyExtractor, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        return comboBox;
    }

    private ComboBox<LocalizationTopic> createTopicComboBox() {
        PropertyProvider<Application> applicationPropertyProvider = PropertyProviders.createApplicationPropertyProvider(this.userSessionData);
        PropertyProvider propertyProvider = (localizationTopic, propertyName) -> {
            HashMap map = new HashMap();
            if (localizationTopic == null) {
                return map;
            }
            if (localizationTopic.getApplication() != null) {
                Map values = applicationPropertyProvider.getValues((Object)localizationTopic.getApplication(), Collections.emptyList());
                map.put("icon", values.get("icon"));
                map.put("caption", values.get("caption"));
            } else {
                map.put("icon", localizationTopic.getIcon() != null ? IconUtils.decodeIcon((String)localizationTopic.getIcon()) : ApplicationIcons.TAGS);
                map.put("caption", localizationTopic.getTitle());
            }
            return map;
        };
        ComboBox comboBox = ComboBoxUtils.createRecordComboBox(this.isAppFilter() ? LocalizationTopic.filter().application(NumericFilter.equalsFilter((Number)this.getMainApplication().getId())).execute() : LocalizationTopic.getAll(), (PropertyProvider)propertyProvider, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        comboBox.setShowClearButton(true);
        return comboBox;
    }

    private ComboBox<TranslationMode> createTranslationModeComboBox() {
        PropertyExtractor propertyExtractor = (mode, propertyName) -> switch (propertyName) {
            case "icon" -> mode.getIcon();
            case "caption" -> this.getLocalized(mode.getTranslationKey());
            default -> null;
        };
        ComboBox comboBox = ComboBoxUtils.createRecordComboBox(Arrays.asList(TranslationMode.values()), (PropertyProvider)propertyExtractor, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        return comboBox;
    }

    private List<TranslationMode> getAvailableModes() {
        return Arrays.asList(TranslationMode.values());
    }
}

