/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.localization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.application.server.system.config.LocalizationConfig;
import org.teamapps.application.server.system.localization.LocalizationProvider;
import org.teamapps.application.server.system.localization.LocalizationUtil;
import org.teamapps.application.server.system.machinetranslation.TranslationService;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;

public class DictionaryLocalizationProvider
implements LocalizationProvider {
    private Map<String, Map<String, LocalizationValue>> localizationLanguageValueMapByKey;

    public DictionaryLocalizationProvider(TranslationService translationService, LocalizationConfig localizationConfig) {
        this.synchronizeDictionaryData(localizationConfig);
        this.loadDictionary();
        LocalizationUtil.translateAllDictionaryValues(translationService, localizationConfig);
    }

    private void synchronizeDictionaryData(LocalizationConfig localizationConfig) {
        LocalizationUtil.synchronizeLocalizationData(LocalizationData.createDictionaryData((ClassLoader)this.getClass().getClassLoader()), null, LocalizationKeyType.DICTIONARY_KEY, localizationConfig);
    }

    private void loadDictionary() {
        this.localizationLanguageValueMapByKey = new HashMap<String, Map<String, LocalizationValue>>();
        LocalizationKey.filter().application(NumericFilter.equalsFilter((Number)0)).localizationKeyType(EnumFilterType.EQUALS, LocalizationKeyType.DICTIONARY_KEY).execute().stream().flatMap(key -> key.getLocalizationValues().stream()).forEach(value -> this.localizationLanguageValueMapByKey.computeIfAbsent(value.getLocalizationKey().getKey(), k -> new HashMap()).put(value.getLanguage(), value));
    }

    @Override
    public String getLocalizationValue(String key, List<String> languagePriorityOrder) {
        Map<String, LocalizationValue> languageValueMap = this.localizationLanguageValueMapByKey.get(key);
        if (languageValueMap != null) {
            for (String language : languagePriorityOrder) {
                LocalizationValue value = languageValueMap.get(language);
                if (value == null || value.getCurrentDisplayValue() == null) continue;
                return value.getCurrentDisplayValue();
            }
        }
        return key;
    }
}

