/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.servlet.resourceprovider.ResourceProvider;

public class PublicLinkResourceProvider
implements ResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SERVLET_PATH_PREFIX = "/pl/";
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, Resource> resourceByUuid = new ConcurrentHashMap<String, Resource>();
    private static final PublicLinkResourceProvider INSTANCE = new PublicLinkResourceProvider();

    public static PublicLinkResourceProvider getInstance() {
        return INSTANCE;
    }

    private PublicLinkResourceProvider() {
    }

    public Resource getResource(String servletPath, String relativeResourcePath, String httpSessionId) {
        return this.resourceByUuid.get(relativeResourcePath.replace("/", ""));
    }

    public String createStaticResource(String resourceName, Resource resource) {
        String suffix = FilenameUtils.getExtension((String)resource.getName());
        String linkName = resourceName + (String)(StringUtils.isNotBlank((CharSequence)suffix) ? "." + suffix : "");
        String link = SERVLET_PATH_PREFIX + linkName;
        if (!this.resourceByUuid.containsKey(linkName)) {
            this.resourceByUuid.put(linkName, resource);
            LOGGER.info("Generating static link for resource {} --> {}, map-size: {}", new Object[]{resource.getName(), link, this.resourceByUuid.size()});
        }
        return link;
    }

    public String createStaticResource(Resource resource) {
        String suffix = FilenameUtils.getExtension((String)resource.getName());
        String linkName = String.valueOf(UUID.randomUUID()) + (String)(StringUtils.isNotBlank((CharSequence)suffix) ? "." + suffix : "");
        this.resourceByUuid.put(linkName, resource);
        String link = SERVLET_PATH_PREFIX + linkName;
        LOGGER.info("Generating link for resource {} --> {}, map-size: {}", new Object[]{resource.getName(), link, this.resourceByUuid.size()});
        return link;
    }

    public String createLinkForResource(Resource resource, Duration availabilityDuration) {
        String suffix = FilenameUtils.getExtension((String)resource.getName());
        String linkName = String.valueOf(UUID.randomUUID()) + (String)(StringUtils.isNotBlank((CharSequence)suffix) ? "." + suffix : "");
        this.resourceByUuid.put(linkName, resource);
        SCHEDULED_EXECUTOR_SERVICE.schedule(() -> this.resourceByUuid.remove(linkName), availabilityDuration.toSeconds(), TimeUnit.SECONDS);
        String link = SERVLET_PATH_PREFIX + linkName;
        LOGGER.info("Generating link for resource {} --> {}, map-size: {}", new Object[]{resource.getName(), link, this.resourceByUuid.size()});
        return link;
    }
}

