/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import org.teamapps.config.TeamAppsConfiguration;

public class ApplicationServerConfig {
    private final File indexPath;
    private final File fullTextIndexPath;
    private final File transactionLogPath;
    private final File fileStorePath;
    private final File logStorePath;
    private final File appDataPath;
    private final File embeddedContentStorePath;
    private final File webserverStaticFilesPath;
    private final TeamAppsConfiguration teamAppsConfiguration;
    private final int port;

    public static ApplicationServerConfig create() {
        TeamAppsConfiguration teamAppsConfiguration = new TeamAppsConfiguration();
        int port = 8080;
        File basePath = ApplicationServerConfig.createPath(new File("./"), "server-data");
        return ApplicationServerConfig.createPaths(teamAppsConfiguration, port, basePath);
    }

    public static ApplicationServerConfig create(File basePath) {
        TeamAppsConfiguration teamAppsConfiguration = new TeamAppsConfiguration();
        teamAppsConfiguration.setCommandBufferTotalSize(30000000);
        teamAppsConfiguration.setCommandBufferLength(50000);
        int port = 8080;
        return ApplicationServerConfig.createPaths(teamAppsConfiguration, port, basePath);
    }

    public static ApplicationServerConfig create(File basePath, File fileStorePath) {
        TeamAppsConfiguration teamAppsConfiguration = new TeamAppsConfiguration();
        teamAppsConfiguration.setCommandBufferTotalSize(30000000);
        teamAppsConfiguration.setCommandBufferLength(50000);
        int port = 8080;
        return ApplicationServerConfig.createPaths(teamAppsConfiguration, port, basePath, fileStorePath);
    }

    public static ApplicationServerConfig create(File basePath, File fileStorePath, int port) {
        TeamAppsConfiguration teamAppsConfiguration = new TeamAppsConfiguration();
        teamAppsConfiguration.setCommandBufferTotalSize(30000000);
        teamAppsConfiguration.setCommandBufferLength(50000);
        return ApplicationServerConfig.createPaths(teamAppsConfiguration, port, basePath, fileStorePath);
    }

    public static ApplicationServerConfig create(File basePath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        return ApplicationServerConfig.createPaths(teamAppsConfiguration, port, basePath);
    }

    private static ApplicationServerConfig createPaths(TeamAppsConfiguration teamAppsConfiguration, int port, File basePath) {
        File indexPath = ApplicationServerConfig.createPath(basePath, "index");
        File fullTextIndexPath = ApplicationServerConfig.createPath(basePath, "text");
        File transactionLogPath = ApplicationServerConfig.createPath(basePath, "transactions");
        File fileStorePath = ApplicationServerConfig.createPath(basePath, "files");
        File logStorePath = ApplicationServerConfig.createPath(basePath, "logs");
        File appDataPath = ApplicationServerConfig.createPath(basePath, "apps");
        File embeddedContentStorePath = ApplicationServerConfig.createPath(basePath, "embedded");
        File webserverStaticFilesPath = ApplicationServerConfig.createPath(basePath, "static");
        return new ApplicationServerConfig(indexPath, fullTextIndexPath, transactionLogPath, fileStorePath, logStorePath, appDataPath, embeddedContentStorePath, webserverStaticFilesPath, teamAppsConfiguration, port);
    }

    private static ApplicationServerConfig createPaths(TeamAppsConfiguration teamAppsConfiguration, int port, File basePath, File fileStorePath) {
        File indexPath = ApplicationServerConfig.createPath(basePath, "index");
        File fullTextIndexPath = ApplicationServerConfig.createPath(basePath, "text");
        File transactionLogPath = ApplicationServerConfig.createPath(basePath, "transactions");
        File logStorePath = ApplicationServerConfig.createPath(basePath, "logs");
        File appDataPath = ApplicationServerConfig.createPath(basePath, "apps");
        File embeddedContentStorePath = ApplicationServerConfig.createPath(basePath, "embedded");
        File webserverStaticFilesPath = ApplicationServerConfig.createPath(basePath, "static");
        return new ApplicationServerConfig(indexPath, fullTextIndexPath, transactionLogPath, fileStorePath, logStorePath, appDataPath, embeddedContentStorePath, webserverStaticFilesPath, teamAppsConfiguration, port);
    }

    public ApplicationServerConfig(File indexPath, File fullTextIndexPath, File transactionLogPath, File fileStorePath, File logStorePath, File appDataPath, File embeddedContentStorePath, File webserverStaticFilesPath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        this.indexPath = indexPath;
        this.fullTextIndexPath = fullTextIndexPath;
        this.transactionLogPath = transactionLogPath;
        this.fileStorePath = fileStorePath;
        this.logStorePath = logStorePath;
        this.appDataPath = appDataPath;
        this.embeddedContentStorePath = embeddedContentStorePath;
        this.webserverStaticFilesPath = webserverStaticFilesPath;
        this.teamAppsConfiguration = teamAppsConfiguration;
        this.port = port;
    }

    private static File createPath(File basePath, String name) {
        File path = new File(basePath, name);
        path.mkdir();
        return path;
    }

    public File getIndexPath() {
        return this.indexPath;
    }

    public File getFullTextIndexPath() {
        return this.fullTextIndexPath;
    }

    public File getTransactionLogPath() {
        return this.transactionLogPath;
    }

    public File getAppDataPath() {
        return this.appDataPath;
    }

    public File getFileStorePath() {
        return this.fileStorePath;
    }

    public File getLogStorePath() {
        return this.logStorePath;
    }

    public File getEmbeddedContentStorePath() {
        return this.embeddedContentStorePath;
    }

    public File getWebserverStaticFilesPath() {
        return this.webserverStaticFilesPath;
    }

    public TeamAppsConfiguration getTeamAppsConfiguration() {
        return this.teamAppsConfiguration;
    }

    public int getPort() {
        return this.port;
    }
}

