package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ApplicationVersion extends Entity<ApplicationVersion> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_APPLICATION = "application";
	final static String FIELD_BINARY = "binary";
	final static String FIELD_BINARY_HASH = "binaryHash";
	final static String FIELD_VERSION = "version";
	final static String FIELD_RELEASE_NOTES = "releaseNotes";
	final static String FIELD_DATA_MODEL_DATA = "dataModelData";
	final static String FIELD_LOCALIZATION_DATA = "localizationData";
	final static String FIELD_PRIVILEGE_DATA = "privilegeData";
	final static String FIELD_PERSPECTIVE_DATA = "perspectiveData";

    static ApplicationVersion create() {
        return new UdbApplicationVersion();
    }

    static ApplicationVersion create(int id) {
        return new UdbApplicationVersion(id, true);
    }

    static ApplicationVersion getById(int id) {
        return new UdbApplicationVersion(id, false);
    }

    static EntityBuilder<ApplicationVersion> getBuilder() {
        return new UdbApplicationVersion(0, false);
    }

    Instant getMetaCreationDate();

    ApplicationVersion setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ApplicationVersion setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ApplicationVersion setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ApplicationVersion setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ApplicationVersion setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ApplicationVersion setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ApplicationVersion setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ApplicationVersion setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ApplicationVersion setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ApplicationVersion setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ApplicationVersion setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ApplicationVersion setMetaDeletedBy(int value);

    Application getApplication();

    ApplicationVersion setApplication(Application value);

    FileValue getBinary();

    ApplicationVersion setBinary(File value);

    ApplicationVersion setBinary(File value, String fileName);

    String getBinaryHash();

    ApplicationVersion setBinaryHash(String value);

    String getVersion();

    ApplicationVersion setVersion(String value);

    String getReleaseNotes();

    ApplicationVersion setReleaseNotes(String value);

    ApplicationVersionData getDataModelData();

    ApplicationVersion setDataModelData(ApplicationVersionData value);

    ApplicationVersionData getLocalizationData();

    ApplicationVersion setLocalizationData(ApplicationVersionData value);

    ApplicationVersionData getPrivilegeData();

    ApplicationVersion setPrivilegeData(ApplicationVersionData value);

    ApplicationVersionData getPerspectiveData();

    ApplicationVersion setPerspectiveData(ApplicationVersionData value);


    static List<ApplicationVersion> getAll() {
        return UdbApplicationVersion.getAll();
    }

    static List<ApplicationVersion> sort(List<ApplicationVersion> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplicationVersion.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbApplicationVersion.getCount();
    }

    static ApplicationVersionQuery filter() {
        return new UdbApplicationVersionQuery();
    }
}

