package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ManagedApplication extends Entity<ManagedApplication> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_MAIN_APPLICATION = "mainApplication";
	final static String FIELD_ORGANIZATION_FIELD = "organizationField";
	final static String FIELD_ICON = "icon";
	final static String FIELD_TITLE_KEY = "titleKey";
	final static String FIELD_DESCRIPTION_KEY = "descriptionKey";
	final static String FIELD_SINGLE_APPLICATION = "singleApplication";
	final static String FIELD_DARK_THEME = "darkTheme";
	final static String FIELD_START_ON_LOGIN = "startOnLogin";
	final static String FIELD_PERSPECTIVES = "perspectives";
	final static String FIELD_LISTING_POSITION = "listingPosition";
	final static String FIELD_TOOLBAR_APPLICATION_MENU = "toolbarApplicationMenu";
	final static String FIELD_APPLICATION_GROUP = "applicationGroup";
	final static String FIELD_HIDDEN = "hidden";

    static ManagedApplication create() {
        return new UdbManagedApplication();
    }

    static ManagedApplication create(int id) {
        return new UdbManagedApplication(id, true);
    }

    static ManagedApplication getById(int id) {
        return new UdbManagedApplication(id, false);
    }

    static EntityBuilder<ManagedApplication> getBuilder() {
        return new UdbManagedApplication(0, false);
    }

    Instant getMetaCreationDate();

    ManagedApplication setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ManagedApplication setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ManagedApplication setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ManagedApplication setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ManagedApplication setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ManagedApplication setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ManagedApplication setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ManagedApplication setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ManagedApplication setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ManagedApplication setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ManagedApplication setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ManagedApplication setMetaDeletedBy(int value);

    Application getMainApplication();

    ManagedApplication setMainApplication(Application value);

    OrganizationField getOrganizationField();

    ManagedApplication setOrganizationField(OrganizationField value);

    String getIcon();

    ManagedApplication setIcon(String value);

    String getTitleKey();

    ManagedApplication setTitleKey(String value);

    String getDescriptionKey();

    ManagedApplication setDescriptionKey(String value);

    boolean getSingleApplication();

    ManagedApplication setSingleApplication(boolean value);

    boolean isSingleApplication();

    boolean getDarkTheme();

    ManagedApplication setDarkTheme(boolean value);

    boolean isDarkTheme();

    boolean getStartOnLogin();

    ManagedApplication setStartOnLogin(boolean value);

    boolean isStartOnLogin();

    List<ManagedApplicationPerspective> getPerspectives();

    ManagedApplication setPerspectives(List<ManagedApplicationPerspective> value);

    int getPerspectivesCount();

    ManagedApplication setPerspectives(ManagedApplicationPerspective ... value);

    BitSet getPerspectivesAsBitSet();

    ManagedApplication addPerspectives(List<ManagedApplicationPerspective> value);

    ManagedApplication addPerspectives(ManagedApplicationPerspective ... value);

    ManagedApplication removePerspectives(List<ManagedApplicationPerspective> value);

    ManagedApplication removePerspectives(ManagedApplicationPerspective ... value);

    ManagedApplication removeAllPerspectives();

    int getListingPosition();

    ManagedApplication setListingPosition(int value);

    boolean getToolbarApplicationMenu();

    ManagedApplication setToolbarApplicationMenu(boolean value);

    boolean isToolbarApplicationMenu();

    ManagedApplicationGroup getApplicationGroup();

    ManagedApplication setApplicationGroup(ManagedApplicationGroup value);

    boolean getHidden();

    ManagedApplication setHidden(boolean value);

    boolean isHidden();


    static List<ManagedApplication> getAll() {
        return UdbManagedApplication.getAll();
    }

    static List<ManagedApplication> sort(List<ManagedApplication> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbManagedApplication.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbManagedApplication.getCount();
    }

    static ManagedApplicationQuery filter() {
        return new UdbManagedApplicationQuery();
    }
}

