package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface NewsBoardMessageImage extends Entity<NewsBoardMessageImage> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_FILE = "file";
	final static String FIELD_THUMBNAIL = "thumbnail";
	final static String FIELD_FILE_NAME = "fileName";
	final static String FIELD_EMBEDDED = "embedded";
	final static String FIELD_POSITION = "position";

    static NewsBoardMessageImage create() {
        return new UdbNewsBoardMessageImage();
    }

    static NewsBoardMessageImage create(int id) {
        return new UdbNewsBoardMessageImage(id, true);
    }

    static NewsBoardMessageImage getById(int id) {
        return new UdbNewsBoardMessageImage(id, false);
    }

    static EntityBuilder<NewsBoardMessageImage> getBuilder() {
        return new UdbNewsBoardMessageImage(0, false);
    }

    Instant getMetaCreationDate();

    NewsBoardMessageImage setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    NewsBoardMessageImage setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    NewsBoardMessageImage setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    NewsBoardMessageImage setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    NewsBoardMessageImage setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    NewsBoardMessageImage setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    NewsBoardMessageImage setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    NewsBoardMessageImage setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    NewsBoardMessageImage setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    NewsBoardMessageImage setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    NewsBoardMessageImage setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    NewsBoardMessageImage setMetaDeletedBy(int value);

    FileValue getFile();

    NewsBoardMessageImage setFile(File value);

    NewsBoardMessageImage setFile(File value, String fileName);

    FileValue getThumbnail();

    NewsBoardMessageImage setThumbnail(File value);

    NewsBoardMessageImage setThumbnail(File value, String fileName);

    String getFileName();

    NewsBoardMessageImage setFileName(String value);

    boolean getEmbedded();

    NewsBoardMessageImage setEmbedded(boolean value);

    boolean isEmbedded();

    int getPosition();

    NewsBoardMessageImage setPosition(int value);


    static List<NewsBoardMessageImage> getAll() {
        return UdbNewsBoardMessageImage.getAll();
    }

    static List<NewsBoardMessageImage> sort(List<NewsBoardMessageImage> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbNewsBoardMessageImage.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbNewsBoardMessageImage.getCount();
    }

    static NewsBoardMessageImageQuery filter() {
        return new UdbNewsBoardMessageImageQuery();
    }
}

