package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface NewsBoardMessageQuery extends Query<NewsBoardMessage> {

    static NewsBoardMessageQuery create() {
        return new UdbNewsBoardMessageQuery();
    }

    NewsBoardMessageQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    NewsBoardMessageQuery parseFullTextFilter(String query, String... fieldNames);

	NewsBoardMessageQuery metaCreationDate(NumericFilter filter);

	NewsBoardMessageQuery orMetaCreationDate(NumericFilter filter);

	NewsBoardMessageQuery metaCreatedBy(NumericFilter filter);

	NewsBoardMessageQuery orMetaCreatedBy(NumericFilter filter);

	NewsBoardMessageQuery metaModificationDate(NumericFilter filter);

	NewsBoardMessageQuery orMetaModificationDate(NumericFilter filter);

	NewsBoardMessageQuery metaModifiedBy(NumericFilter filter);

	NewsBoardMessageQuery orMetaModifiedBy(NumericFilter filter);

	NewsBoardMessageQuery metaDeletionDate(NumericFilter filter);

	NewsBoardMessageQuery orMetaDeletionDate(NumericFilter filter);

	NewsBoardMessageQuery metaDeletedBy(NumericFilter filter);

	NewsBoardMessageQuery orMetaDeletedBy(NumericFilter filter);

	NewsBoardMessageQuery published(BooleanFilter filter);

	NewsBoardMessageQuery orPublished(BooleanFilter filter);

	NewsBoardMessageQuery htmlMessage(TextFilter filter);

	NewsBoardMessageQuery orHtmlMessage(TextFilter filter);

	NewsBoardMessageQuery language(TextFilter filter);

	NewsBoardMessageQuery orLanguage(TextFilter filter);

	NewsBoardMessageQuery filterImages(NewsBoardMessageImageQuery query);

	NewsBoardMessageQuery images(MultiReferenceFilterType type, NewsBoardMessageImage ... value);

	NewsBoardMessageQuery imagesCount(MultiReferenceFilterType type, int count);

	NewsBoardMessageQuery images(MultiReferenceFilter filter);

	NewsBoardMessageQuery orImages(MultiReferenceFilter filter);

	NewsBoardMessageQuery filterTranslations(NewsBoardMessageTranslationQuery query);

	NewsBoardMessageQuery translations(MultiReferenceFilterType type, NewsBoardMessageTranslation ... value);

	NewsBoardMessageQuery translationsCount(MultiReferenceFilterType type, int count);

	NewsBoardMessageQuery translations(MultiReferenceFilter filter);

	NewsBoardMessageQuery orTranslations(MultiReferenceFilter filter);

	NewsBoardMessageQuery filterOrganizationField(OrganizationFieldQuery query);

	NewsBoardMessageQuery organizationField(NumericFilter filter);

	NewsBoardMessageQuery orOrganizationField(NumericFilter filter);

	NewsBoardMessageQuery filterOrganizationUnit(OrganizationUnitQuery query);

	NewsBoardMessageQuery organizationUnit(NumericFilter filter);

	NewsBoardMessageQuery orOrganizationUnit(NumericFilter filter);


    NewsBoardMessageQuery andOr(NewsBoardMessageQuery... queries);

    NewsBoardMessageQuery customFilter(Function<NewsBoardMessage, Boolean> customFilter);

    List<NewsBoardMessage> execute();

    NewsBoardMessage executeExpectSingleton();

    BitSet executeToBitSet();

    List<NewsBoardMessage> execute(String sortFieldName, boolean ascending, String ... path);

    List<NewsBoardMessage> execute(int startIndex, int length, Sorting sorting);

}

