package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface NewsBoardMessageTranslation extends Entity<NewsBoardMessageTranslation> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_MESSAGE = "message";
	final static String FIELD_LANGUAGE = "language";
	final static String FIELD_TRANSLATION = "translation";

    static NewsBoardMessageTranslation create() {
        return new UdbNewsBoardMessageTranslation();
    }

    static NewsBoardMessageTranslation create(int id) {
        return new UdbNewsBoardMessageTranslation(id, true);
    }

    static NewsBoardMessageTranslation getById(int id) {
        return new UdbNewsBoardMessageTranslation(id, false);
    }

    static EntityBuilder<NewsBoardMessageTranslation> getBuilder() {
        return new UdbNewsBoardMessageTranslation(0, false);
    }

    Instant getMetaCreationDate();

    NewsBoardMessageTranslation setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    NewsBoardMessageTranslation setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    NewsBoardMessageTranslation setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    NewsBoardMessageTranslation setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    NewsBoardMessageTranslation setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    NewsBoardMessageTranslation setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    NewsBoardMessageTranslation setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    NewsBoardMessageTranslation setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    NewsBoardMessageTranslation setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    NewsBoardMessageTranslation setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    NewsBoardMessageTranslation setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    NewsBoardMessageTranslation setMetaDeletedBy(int value);

    NewsBoardMessage getMessage();

    NewsBoardMessageTranslation setMessage(NewsBoardMessage value);

    String getLanguage();

    NewsBoardMessageTranslation setLanguage(String value);

    String getTranslation();

    NewsBoardMessageTranslation setTranslation(String value);


    static List<NewsBoardMessageTranslation> getAll() {
        return UdbNewsBoardMessageTranslation.getAll();
    }

    static List<NewsBoardMessageTranslation> sort(List<NewsBoardMessageTranslation> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbNewsBoardMessageTranslation.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbNewsBoardMessageTranslation.getCount();
    }

    static NewsBoardMessageTranslationQuery filter() {
        return new UdbNewsBoardMessageTranslationQuery();
    }
}

