package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface OrganizationUnitType extends Entity<OrganizationUnitType> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_NAME = "name";
	final static String FIELD_ABBREVIATION = "abbreviation";
	final static String FIELD_ICON = "icon";
	final static String FIELD_TRANSLATE_ORGANIZATION_UNITS = "translateOrganizationUnits";
	final static String FIELD_ALLOW_USERS = "allowUsers";
	final static String FIELD_DEFAULT_CHILD_TYPE = "defaultChildType";
	final static String FIELD_POSSIBLE_CHILDREN_TYPES = "possibleChildrenTypes";
	final static String FIELD_GEO_LOCATION_TYPE = "geoLocationType";

    static OrganizationUnitType create() {
        return new UdbOrganizationUnitType();
    }

    static OrganizationUnitType create(int id) {
        return new UdbOrganizationUnitType(id, true);
    }

    static OrganizationUnitType getById(int id) {
        return new UdbOrganizationUnitType(id, false);
    }

    static EntityBuilder<OrganizationUnitType> getBuilder() {
        return new UdbOrganizationUnitType(0, false);
    }

    Instant getMetaCreationDate();

    OrganizationUnitType setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    OrganizationUnitType setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    OrganizationUnitType setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    OrganizationUnitType setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    OrganizationUnitType setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    OrganizationUnitType setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    OrganizationUnitType setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    OrganizationUnitType setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    OrganizationUnitType setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    OrganizationUnitType setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    OrganizationUnitType setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    OrganizationUnitType setMetaDeletedBy(int value);

    TranslatableText getName();

    OrganizationUnitType setName(TranslatableText value);

    TranslatableText getAbbreviation();

    OrganizationUnitType setAbbreviation(TranslatableText value);

    String getIcon();

    OrganizationUnitType setIcon(String value);

    boolean getTranslateOrganizationUnits();

    OrganizationUnitType setTranslateOrganizationUnits(boolean value);

    boolean isTranslateOrganizationUnits();

    boolean getAllowUsers();

    OrganizationUnitType setAllowUsers(boolean value);

    boolean isAllowUsers();

    OrganizationUnitType getDefaultChildType();

    OrganizationUnitType setDefaultChildType(OrganizationUnitType value);

    List<OrganizationUnitType> getPossibleChildrenTypes();

    OrganizationUnitType setPossibleChildrenTypes(List<OrganizationUnitType> value);

    int getPossibleChildrenTypesCount();

    OrganizationUnitType setPossibleChildrenTypes(OrganizationUnitType ... value);

    BitSet getPossibleChildrenTypesAsBitSet();

    OrganizationUnitType addPossibleChildrenTypes(List<OrganizationUnitType> value);

    OrganizationUnitType addPossibleChildrenTypes(OrganizationUnitType ... value);

    OrganizationUnitType removePossibleChildrenTypes(List<OrganizationUnitType> value);

    OrganizationUnitType removePossibleChildrenTypes(OrganizationUnitType ... value);

    OrganizationUnitType removeAllPossibleChildrenTypes();

    GeoLocationType getGeoLocationType();

    OrganizationUnitType setGeoLocationType(GeoLocationType value);


    static List<OrganizationUnitType> getAll() {
        return UdbOrganizationUnitType.getAll();
    }

    static List<OrganizationUnitType> sort(List<OrganizationUnitType> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbOrganizationUnitType.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbOrganizationUnitType.getCount();
    }

    static OrganizationUnitTypeQuery filter() {
        return new UdbOrganizationUnitTypeQuery();
    }
}

