/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.applications;

import java.io.File;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.LocalizationEntry;
import org.teamapps.application.api.localization.LocalizationEntrySet;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.bootstrap.ApplicationInfo;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstaller;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.window.WindowUtils;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPrivilege;
import org.teamapps.model.controlcenter.ApplicationPrivilegeGroup;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.dialogue.FormDialogue;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.field.upload.FileFieldDisplayType;
import org.teamapps.ux.component.field.upload.simple.FileItem;
import org.teamapps.ux.component.field.upload.simple.SimpleFileField;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.session.SessionContext;

public class ApplicationsPerspectiveComponents
extends AbstractManagedApplicationPerspective {
    private final PerspectiveSessionData perspectiveSessionData;
    private final UserSessionData userSessionData;
    private final TwoWayBindableValue<Application> selectedApplication = TwoWayBindableValue.create();

    public ApplicationsPerspectiveComponents(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
    }

    public TwoWayBindableValue<Application> getSelectedApplication() {
        return this.selectedApplication;
    }

    public void createToolbarButtons(ToolbarButtonGroup buttonGroup) {
        ToolbarButton dataModelButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.DATA_CLOUD, (String)this.getLocalized("applications.dataModel"), (String)this.getLocalized("applications.showDataModel")));
        dataModelButton.onClick.addListener(() -> {
            Application application = (Application)this.selectedApplication.get();
            if (application == null) {
                return;
            }
            LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication(application);
            String schemaDefinition = loadedApplication.getBaseApplicationBuilder().getDatabaseModel() != null ? loadedApplication.getBaseApplicationBuilder().getDatabaseModel().getSchema().createDefinition() : "";
            StringBuilder sb = new StringBuilder();
            for (String line : schemaDefinition.split("[\\r\\n]+")) {
                sb.append(line.replaceAll("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;")).append("<br>");
            }
            this.showTextWindow(ApplicationIcons.DATA_CLOUD, this.getLocalized("applications.dataModel"), sb.toString());
        });
        buttonGroup.addButton((ToolbarButton)ToolbarButton.create((Icon)ApplicationIcons.KEYS, (String)this.getLocalized((String)"applications.privileges"), (String)this.getLocalized((String)"applications.showPrivileges"))).onClick.addListener(() -> {
            Application application = (Application)this.selectedApplication.get();
            if (application == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            ApplicationLocalizationProvider localizationProvider = this.userSessionData.getApplicationLocalizationProvider(application);
            for (ApplicationPrivilegeGroup privilegeGroup : application.getPrivilegeGroups()) {
                sb.append("<b>").append(localizationProvider.getLocalized(privilegeGroup.getTitleKey(), new Object[0])).append("</b>");
                if (privilegeGroup.getDescriptionKey() != null) {
                    sb.append(" (").append(localizationProvider.getLocalized(privilegeGroup.getDescriptionKey(), new Object[0])).append(")");
                }
                sb.append("<br>");
                if (!privilegeGroup.getPrivileges().isEmpty()) {
                    sb.append("<ul>");
                }
                for (ApplicationPrivilege privilege : privilegeGroup.getPrivileges()) {
                    sb.append("<li>").append(localizationProvider.getLocalized(privilege.getTitleKey(), new Object[0])).append("</li>");
                }
                if (privilegeGroup.getPrivileges().isEmpty()) continue;
                sb.append("</ul>");
            }
            this.showTextWindow(ApplicationIcons.DATA_CLOUD, this.getLocalized("applications.privileges"), sb.toString());
        });
        ToolbarButton applicationRolesButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.USERS_THREE, (String)this.getLocalized("applications.applicationRoles"), (String)this.getLocalized("applications.showApplicationRoles")));
        applicationRolesButton.onClick.addListener(() -> {
            Application application = (Application)this.selectedApplication.get();
            if (application == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication(application);
            ApplicationLocalizationProvider localizationProvider = this.userSessionData.getApplicationLocalizationProvider(application);
            if (loadedApplication.getBaseApplicationBuilder().getApplicationRoles() != null) {
                for (ApplicationRole applicationRole : loadedApplication.getBaseApplicationBuilder().getApplicationRoles()) {
                    sb.append("<b>").append(this.getLocalized(applicationRole.getTitleKey())).append("</b>");
                    if (applicationRole.getDescriptionKey() != null) {
                        sb.append(" (").append(localizationProvider.getLocalized(applicationRole.getDescriptionKey(), new Object[0])).append(")");
                    }
                    sb.append("<br>");
                    for (PrivilegeGroup privilegeGroup : applicationRole.getPrivilegeGroups()) {
                        sb.append(localizationProvider.getLocalized(privilegeGroup.getTitleKey(), new Object[0]));
                        if (privilegeGroup.getDescriptionKey() != null) {
                            sb.append(" (").append(localizationProvider.getLocalized(privilegeGroup.getDescriptionKey(), new Object[0])).append(")");
                        }
                        sb.append("<br>");
                        if (!privilegeGroup.getPrivileges().isEmpty()) {
                            sb.append("<ul>");
                        }
                        for (Privilege privilege : privilegeGroup.getPrivileges()) {
                            sb.append("<li>").append(localizationProvider.getLocalized(privilege.getTitleKey(), new Object[0])).append("</li>");
                        }
                        if (privilegeGroup.getPrivileges().isEmpty()) continue;
                        sb.append("</ul>");
                    }
                }
            }
            this.showTextWindow(ApplicationIcons.USERS_THREE, this.getLocalized("applications.applicationRoles"), sb.toString());
        });
        buttonGroup.addButton((ToolbarButton)ToolbarButton.create((Icon)ApplicationIcons.DOCUMENT_TEXT, (String)this.getLocalized((String)"applications.applicationCaptions"), (String)this.getLocalized((String)"applications.showApplicationCaptions"))).onClick.addListener(() -> {
            Application application = (Application)this.selectedApplication.get();
            if (application == null) {
                return;
            }
            LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication(application);
            StringBuilder sb = new StringBuilder();
            for (LocalizationEntrySet localizationEntrySet : loadedApplication.getBaseApplicationBuilder().getLocalizationData().getLocalizationEntrySets()) {
                String language = localizationEntrySet.getLanguage();
                sb.append("<b>").append(language).append(":</b><br>");
                for (LocalizationEntry entry : localizationEntrySet.getEntries().stream().sorted(Comparator.comparing(LocalizationEntry::getKey)).collect(Collectors.toList())) {
                    sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("<br>");
                }
            }
            this.showTextWindow(ApplicationIcons.DOCUMENT_TEXT, this.getLocalized("applications.applicationCaptions"), sb.toString());
        });
        applicationRolesButton.setVisible(false);
        dataModelButton.setVisible(false);
        this.selectedApplication.onChanged().addListener(() -> {
            Application application = (Application)this.selectedApplication.get();
            LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication(application);
            applicationRolesButton.setVisible(false);
            dataModelButton.setVisible(false);
            if (loadedApplication != null) {
                BaseApplicationBuilder baseApplicationBuilder = loadedApplication.getBaseApplicationBuilder();
                applicationRolesButton.setVisible(baseApplicationBuilder.getApplicationRoles() != null && !baseApplicationBuilder.getApplicationRoles().isEmpty());
                dataModelButton.setVisible(baseApplicationBuilder.getDatabaseModel() != null);
            }
        });
    }

    public void showTextWindow(Icon icon, String title, String content) {
        DisplayField displayField = new DisplayField(false, true);
        Window window = WindowUtils.createWindow((Icon)icon, (String)title);
        WindowUtils.addCancelCloseButton((Window)window, (ApplicationInstanceData)this.getApplicationInstanceData());
        displayField.setMargin(Spacing.px((int)10));
        displayField.setValue((Object)content);
        window.setContent((Component)displayField);
        window.show();
    }

    public void showInstallApplicationDialogue(Application fixedApplication) {
        FormDialogue dialogue = FormDialogue.create((Icon)ApplicationIcons.UPLOAD, (String)this.getLocalized("applications.upload"), (String)this.getLocalized("applications.uploadApplicationJar"));
        SimpleFileField fileField = new SimpleFileField();
        fileField.setMaxFiles(1);
        fileField.setDisplayType(FileFieldDisplayType.LIST);
        dialogue.addField(ApplicationIcons.JAR, this.getLocalized("applications.applicationJar"), (AbstractField)fileField);
        dialogue.addOkCancelButtons(ApplicationIcons.CHECK, this.getLocalized("org.teamapps.dictionary.oK"), ApplicationIcons.ERROR, this.getLocalized("org.teamapps.dictionary.cancel"));
        dialogue.setCloseable(true);
        dialogue.setAutoCloseOnOk(true);
        dialogue.setCloseOnEscape(true);
        dialogue.show();
        dialogue.onOk.addListener(() -> {
            if (!fileField.getValue().isEmpty()) {
                FileItem fileItem = (FileItem)fileField.getValue().get(0);
                File jarFile = fileItem.getFile();
                if (fileItem.getFileName().endsWith("jar")) {
                    this.showInstaller(jarFile, fixedApplication);
                }
            }
            dialogue.close();
        });
    }

    public void showInstaller(File jarFile, Application fixedApplication) {
        ApplicationInstaller installer = this.userSessionData.getRegistry().createJarInstaller(jarFile);
        ApplicationInfo applicationInfo = installer.checkApplication();
        if (!applicationInfo.getErrors().isEmpty()) {
            FormDialogue dialogue = FormDialogue.create((Icon)ApplicationIcons.SIGN_WARNING, (String)this.getLocalized("applications.cannotInstallApplication"), (String)this.getLocalized("applications.cannotInstallApplication.error"));
            DisplayField displayField = new DisplayField(false, true);
            displayField.setValue((Object)String.join((CharSequence)"<br>", applicationInfo.getErrors()));
            dialogue.addField(null, this.getLocalized("applications.errors"), (AbstractField)displayField);
            dialogue.addOkButton(ApplicationIcons.CHECK, this.getLocalized("org.teamapps.dictionary.oK"));
            dialogue.setCloseable(true);
            dialogue.setAutoCloseOnOk(true);
            dialogue.setCloseOnEscape(true);
            dialogue.show();
            return;
        }
        if (fixedApplication != null && !applicationInfo.getName().equals(fixedApplication.getName())) {
            FormDialogue dialogue = FormDialogue.create((Icon)ApplicationIcons.SIGN_WARNING, (String)this.getLocalized("applications.wrongApplication"), (String)this.getLocalized("applications.wrongApplication.error"));
            dialogue.addOkButton(ApplicationIcons.CHECK, this.getLocalized("org.teamapps.dictionary.oK"));
            dialogue.setCloseable(true);
            dialogue.setAutoCloseOnOk(true);
            dialogue.setCloseOnEscape(true);
            dialogue.show();
            return;
        }
        if (installer.isInstalled()) {
            FormDialogue dialogue = FormDialogue.create((Icon)ApplicationIcons.SIGN_WARNING, (String)this.getLocalized("applications.applicationAlreadyInstalled"), (String)this.getLocalized("applications.applicationAlreadyInstalled.error"));
            dialogue.addOkButton(ApplicationIcons.CHECK, this.getLocalized("org.teamapps.dictionary.oK"));
            dialogue.setCloseable(true);
            dialogue.setAutoCloseOnOk(true);
            dialogue.setCloseOnEscape(true);
            dialogue.show();
            return;
        }
        Window window = WindowUtils.createWindow((Icon)ApplicationIcons.UPLOAD, (String)this.getLocalized("applications.installApplication"));
        ResponsiveForm form = new ResponsiveForm(100, 0, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(400);
        BaseApplicationBuilder baseApplicationBuilder = applicationInfo.getBaseApplicationBuilder();
        if (applicationInfo.getApplication() != null) {
            TemplateField applicationField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES, PropertyProviders.createApplicationPropertyProvider(this.userSessionData));
            applicationField.setValue((Object)applicationInfo.getApplication());
            formLayout.addLabelAndComponent(null, this.getLocalized("applications.application"), (Component)applicationField);
        } else {
            Map localizationMap = (Map)baseApplicationBuilder.getLocalizationData().createLocalizationMapByLanguage().values().iterator().next();
            formLayout.addLabelAndComponent(null, this.getLocalized("applications.application"), (Component)UiUtils.createSingleValueTemplateField((Icon)baseApplicationBuilder.getApplicationIcon(), (String)baseApplicationBuilder.getApplicationName()));
            formLayout.addLabelAndComponent(null, this.getLocalized("applications.appTitle"), (Component)UiUtils.createSingleValueTextField((String)(baseApplicationBuilder.getApplicationTitleKey() + " -> " + (String)localizationMap.get(baseApplicationBuilder.getApplicationTitleKey()))));
            formLayout.addLabelAndComponent(null, this.getLocalized("applications.appDescription"), (Component)UiUtils.createSingleValueTextField((String)(baseApplicationBuilder.getApplicationDescriptionKey() + " -> " + (String)localizationMap.get(baseApplicationBuilder.getApplicationDescriptionKey()))));
            formLayout.addLabelAndComponent(null, this.getLocalized("applications.releaseNotes"), (Component)UiUtils.createSingleValueTextField((String)baseApplicationBuilder.getReleaseNotes()));
        }
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.installationType"), (Component)UiUtils.createSingleValueTemplateField((Icon)(applicationInfo.getApplication() != null ? ApplicationIcons.NAV_REFRESH : ApplicationIcons.INSTALL), (String)(applicationInfo.getApplication() != null ? this.getLocalized("applications.applicationUpdate") : this.getLocalized("applications.newApplication"))));
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.appVersion"), (Component)UiUtils.createSingleValueTextField((String)baseApplicationBuilder.getApplicationVersion().getVersion()));
        if (!applicationInfo.getWarnings().isEmpty()) {
            TagComboBox warningsField = UiUtils.createSingleValueTagComboBox((Icon)ApplicationIcons.SIGN_WARNING, applicationInfo.getWarnings());
            formLayout.addLabelAndComponent(null, this.getLocalized("applications.warnings"), (Component)warningsField);
        }
        formLayout.addSection(ApplicationIcons.INFORMATION, this.getLocalized("applications.applicationInfo")).setDrawHeaderLine(false);
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.dataModelChanges"), (Component)UiUtils.createSingleValueTemplateField((Icon)ApplicationIcons.DATA_CLOUD, (String)applicationInfo.getDataModelData().getChangeString()));
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.localizationDataChanges"), (Component)UiUtils.createSingleValueTemplateField((Icon)ApplicationIcons.EARTH, (String)applicationInfo.getLocalizationData().getChangeString()));
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.privilegesDataChanges"), (Component)UiUtils.createSingleValueTemplateField((Icon)ApplicationIcons.KEYS, (String)applicationInfo.getPrivilegeData().getChangeString()));
        formLayout.addLabelAndComponent(null, this.getLocalized("applications.perspectivesDataChanges"), (Component)UiUtils.createSingleValueTemplateField((Icon)ApplicationIcons.WINDOWS, (String)applicationInfo.getPerspectiveData().getChangeString()));
        formLayout.addSection(ApplicationIcons.DATA_CLOUD, this.getLocalized("applications.dataModelChanges")).setDrawHeaderLine(false).setCollapsed(true);
        formLayout.addLabelAndComponent(null, (Component)UiUtils.createSingleValueDisplayField((String)applicationInfo.getDataModelData().getMultiLineChangeHtml(this.getLocalized("applications.addedData"), this.getLocalized("applications.removedData"))));
        formLayout.addSection(ApplicationIcons.EARTH, this.getLocalized("applications.localizationDataChanges")).setDrawHeaderLine(false).setCollapsed(true);
        formLayout.addLabelAndComponent(null, (Component)UiUtils.createSingleValueDisplayField((String)applicationInfo.getLocalizationData().getMultiLineChangeHtml(this.getLocalized("applications.addedData"), this.getLocalized("applications.removedData"))));
        formLayout.addSection(ApplicationIcons.KEYS, this.getLocalized("applications.privilegesDataChanges")).setDrawHeaderLine(false).setCollapsed(true);
        formLayout.addLabelAndComponent(null, (Component)UiUtils.createSingleValueDisplayField((String)applicationInfo.getPrivilegeData().getMultiLineChangeHtml(this.getLocalized("applications.addedData"), this.getLocalized("applications.removedData"))));
        formLayout.addSection(ApplicationIcons.WINDOWS, this.getLocalized("applications.perspectivesDataChanges")).setDrawHeaderLine(false).setCollapsed(true);
        formLayout.addLabelAndComponent(null, (Component)UiUtils.createSingleValueDisplayField((String)applicationInfo.getPerspectiveData().getMultiLineChangeHtml(this.getLocalized("applications.addedData"), this.getLocalized("applications.removedData"))));
        window.setContent((Component)form);
        ToolbarButtonGroup buttonGroup = window.getToolbar().addButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.create((Icon)ApplicationIcons.INSTALL, (String)this.getLocalized((String)"applications.installApplication"), (String)this.getLocalized((String)"applications.installApplication"))).onClick.addListener(() -> {
            SessionContext context = SessionContext.current();
            window.close();
            this.getApplicationInstanceData().getMultiProgressDisplay().addTask(ApplicationIcons.INSTALL, this.getLocalized("applications.installApplication"), progressMonitor -> {
                boolean result = this.userSessionData.getRegistry().installAndLoadApplication(installer);
                context.runWithContext(() -> {
                    if (result) {
                        SessionContext.current().showNotification(ApplicationIcons.OK, this.getLocalized("applications.installationSuccessful"));
                    } else {
                        SessionContext.current().showNotification(ApplicationIcons.ERROR, this.getLocalized("applications.installationNotSuccessful"));
                    }
                });
            });
        });
        buttonGroup = window.getToolbar().addButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.create((Icon)ApplicationIcons.DATA_CLOUD, (String)this.getLocalized((String)"applications.dataModel"), (String)this.getLocalized((String)"applications.showDataModel"))).onClick.addListener(() -> {
            String schemaDefinition = baseApplicationBuilder.getDatabaseModel() != null ? baseApplicationBuilder.getDatabaseModel().getSchema().createDefinition() : "";
            StringBuilder sb = new StringBuilder();
            for (String line : schemaDefinition.split("[\\r\\n]+")) {
                sb.append(line.replaceAll("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;")).append("<br>");
            }
            this.showTextWindow(ApplicationIcons.DATA_CLOUD, this.getLocalized("applications.dataModel"), sb.toString());
        });
        buttonGroup.addButton((ToolbarButton)ToolbarButton.create((Icon)ApplicationIcons.DOCUMENT_TEXT, (String)this.getLocalized((String)"applications.applicationCaptions"), (String)this.getLocalized((String)"applications.showApplicationCaptions"))).onClick.addListener(() -> {
            StringBuilder sb = new StringBuilder();
            for (LocalizationEntrySet localizationEntrySet : baseApplicationBuilder.getLocalizationData().getLocalizationEntrySets()) {
                String language = localizationEntrySet.getLanguage();
                sb.append("<b>").append(language).append(":</b><br>");
                for (LocalizationEntry entry : localizationEntrySet.getEntries().stream().sorted(Comparator.comparing(LocalizationEntry::getKey)).collect(Collectors.toList())) {
                    sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("<br>");
                }
            }
            this.showTextWindow(ApplicationIcons.DOCUMENT_TEXT, this.getLocalized("applications.applicationCaptions"), sb.toString());
        });
        WindowUtils.addCancelCloseButton((Window)window, (ApplicationInstanceData)this.getApplicationInstanceData());
        window.show();
    }
}

