/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.roles;

import java.time.Instant;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserRoleAssignment;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class UserRoleAssignmentPerspective
extends AbstractManagedApplicationPerspective {
    private final TwoWayBindableValue<UserRoleAssignment> selectedUserRoleAssignment = TwoWayBindableValue.create();
    private final PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
    private final UserSessionData userSessionData = this.perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();

    public UserRoleAssignmentPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.USERS_THREE_RELATION, (String)this.getLocalized("userRoleAssignment.userRoleAssignments"), null));
        View detailView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.USERS_THREE_RELATION, (String)this.getLocalized("userRoleAssignment.userRoleAssignment"), null));
        detailView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        EntityModelBuilder roleModelBuilder = new EntityModelBuilder(() -> this.isAppFilter() ? UserRoleAssignment.filter().filterRole(Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId()))) : UserRoleAssignment.filter(), this.getApplicationInstanceData());
        roleModelBuilder.attachViewCountHandler(masterView, () -> this.getLocalized("userRoleAssignment.userRoleAssignments"));
        roleModelBuilder.attachSearchField(masterView);
        roleModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedUserRoleAssignment.set(arg_0));
        Table table = roleModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setRowHeight(28);
        table.setStripedRows(false);
        roleModelBuilder.updateModels();
        TemplateField userTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        TemplateField roleTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()));
        TemplateField orgUnitTableField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()));
        table.addColumn(new TableColumn("user", this.getLocalized("userRoleAssignment.user"), (AbstractField)userTableField).setDefaultWidth(200));
        table.addColumn(new TableColumn("role", this.getLocalized("userRoleAssignment.role"), (AbstractField)roleTableField).setDefaultWidth(200));
        table.addColumn(new TableColumn("organizationUnit", this.getLocalized("userRoleAssignment.orgUnit"), (AbstractField)orgUnitTableField).setDefaultWidth(200));
        table.setPropertyExtractor((userRoleAssignment, propertyName) -> switch (propertyName) {
            case "user" -> userRoleAssignment.getUser();
            case "role" -> userRoleAssignment.getRole();
            case "organizationUnit" -> userRoleAssignment.getOrganizationUnit();
            default -> null;
        });
        masterView.setComponent((Component)table);
        ToolbarButtonGroup buttonGroup = detailView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton addButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ADD, (String)this.getLocalized("org.teamapps.dictionary.add"), (String)this.getLocalized("org.teamapps.dictionary.addRecord")));
        buttonGroup = detailView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISK, (String)this.getLocalized("org.teamapps.dictionary.saveChanges")));
        ComboBox userCombobox = ComboBoxUtils.createComboBox(query -> query == null || query.isBlank() ? User.getAll().stream().limit(50L).collect(Collectors.toList()) : User.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(50L).collect(Collectors.toList()), PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        ComboBox roleComboBox = ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Role.filter().organizationField(NumericFilter.equalsFilter((Number)this.getOrganizationField().getId())).execute() : Role.getAll(), PropertyProviders.createRolePropertyProvider(this.getApplicationInstanceData()), (Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        ComboBox<OrganizationUnit> organizationComboBox = OrganizationUtils.createOrganizationComboBox((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, OrganizationUnit.getAll(), true, this.getApplicationInstanceData());
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("userRoleAssignment.user"), (AbstractField)userCombobox);
        formLayout.addLabelAndField(null, this.getLocalized("userRoleAssignment.role"), (AbstractField)roleComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("userRoleAssignment.orgUnit"), organizationComboBox);
        FormMetaFields formMetaFields = this.getApplicationInstanceData().getComponentFactory().createFormMetaFields();
        formMetaFields.addMetaFields(formLayout, false);
        this.selectedUserRoleAssignment.onChanged().addListener(arg_0 -> ((FormMetaFields)formMetaFields).updateEntity(arg_0));
        detailView.setComponent((Component)form);
        addButton.onClick.addListener(() -> this.selectedUserRoleAssignment.set((Object)UserRoleAssignment.create()));
        saveButton.onClick.addListener(() -> {
            UserRoleAssignment userRoleAssignment = (UserRoleAssignment)this.selectedUserRoleAssignment.get();
            if (userRoleAssignment != null && userCombobox.getValue() != null && roleComboBox.getValue() != null && organizationComboBox.getValue() != null) {
                userRoleAssignment.setUser((User)userCombobox.getValue()).setRole((Role)roleComboBox.getValue()).setOrganizationUnit((OrganizationUnit)organizationComboBox.getValue()).setLastVerified(Instant.now()).save();
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
                roleModelBuilder.updateModels();
            } else {
                UiUtils.showSaveNotification((boolean)false, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
        this.selectedUserRoleAssignment.onChanged().addListener(userRoleAssignment -> {
            userCombobox.setValue((Object)userRoleAssignment.getUser());
            roleComboBox.setValue((Object)userRoleAssignment.getRole());
            organizationComboBox.setValue((Object)userRoleAssignment.getOrganizationUnit());
        });
        this.selectedUserRoleAssignment.set((Object)UserRoleAssignment.create());
    }
}

