/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.teamapps.application.server.system.auth.AuthenticationHandler;
import org.teamapps.application.server.system.config.AuthenticationConfig;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserAccountStatus;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.ux.session.SessionContext;

public class UrlAuthenticationHandler
implements AuthenticationHandler {
    private final Supplier<AuthenticationConfig> authenticationConfigSupplier;

    public UrlAuthenticationHandler(Supplier<AuthenticationConfig> authenticationConfigSupplier) {
        this.authenticationConfigSupplier = authenticationConfigSupplier;
    }

    @Override
    public User authenticate(SessionContext context, Map<String, Object> clientParameters) {
        String token = (String)clientParameters.get("ATOK");
        AuthenticationConfig authenticationConfig = this.authenticationConfigSupplier.get();
        if (authenticationConfig.isEnableAutoLoginUrls()) {
            return this.authenticate(token, authenticationConfig);
        }
        return null;
    }

    private User authenticate(String token, AuthenticationConfig authenticationConfig) {
        try {
            String data = new String(Base64.getUrlDecoder().decode(token), StandardCharsets.UTF_8);
            String[] parts = data.split(":");
            if (parts.length == 3) {
                long diff;
                String login = parts[0];
                long time = Long.parseLong(parts[1]);
                String hash = parts[2];
                User user = User.filter().login(TextFilter.textEqualsIgnoreCaseFilter((String)login)).executeExpectSingleton();
                if (user == null || user.getUserAccountStatus() == UserAccountStatus.INACTIVE || user.getLogin() == null || user.getPassword() == null) {
                    return null;
                }
                if (UrlAuthenticationHandler.validate(login, user.getPassword(), time, authenticationConfig.getAutoLoginSecret(), hash) && (diff = Math.abs(System.currentTimeMillis() - time)) < (long)authenticationConfig.getAutoLoginUrlValidityInSeconds() * 1000L) {
                    return user;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean validate(String login, String password, long timestamp, String secret, String hash) {
        String sha256Hex = DigestUtils.sha256Hex((String)(login + ":" + password + ":" + timestamp + ":" + secret));
        return hash.equals(sha256Hex);
    }

    public static String createToken(String login, String password, long timestamp, String secret) {
        String sha256Hex = DigestUtils.sha256Hex((String)(login + ":" + password + ":" + timestamp + ":" + secret));
        String token = login + ":" + timestamp + ":" + sha256Hex;
        return Base64.getUrlEncoder().withoutPadding().encodeToString(token.getBytes(StandardCharsets.UTF_8));
    }
}

