/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.session;

import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.ui.UiComponentFactory;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.session.SessionUiComponentFactory;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.LogLevel;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.SystemLog;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.component.progress.MultiProgressDisplay;

public class UnmanagedApplicationSessionData
implements ApplicationInstanceData {
    private final SystemRegistry registry;
    private final UserSessionData userSessionData;
    private final ManagedApplication managedApplication;
    private final Application application;
    private final ResponsiveApplication responsiveApplication;
    private final ApplicationPrivilegeProvider privilegeProvider;
    private final ApplicationLocalizationProvider localizationProvider;
    private final Supplier<DocumentConverter> documentConverterSupplier;
    private final SessionUiComponentFactory componentFactory;

    public UnmanagedApplicationSessionData(UserSessionData userSessionData, ManagedApplication managedApplication, ResponsiveApplication responsiveApplication, ApplicationPrivilegeProvider privilegeProvider, ApplicationLocalizationProvider localizationProvider) {
        this.registry = userSessionData.getRegistry();
        this.userSessionData = userSessionData;
        this.managedApplication = managedApplication;
        this.application = managedApplication.getMainApplication();
        this.responsiveApplication = responsiveApplication;
        this.privilegeProvider = privilegeProvider;
        this.localizationProvider = localizationProvider;
        this.documentConverterSupplier = this.registry.getDocumentConverterSupplier();
        this.componentFactory = new SessionUiComponentFactory(this, userSessionData.getRegistry(), this.application);
    }

    public SessionUser getUser() {
        return this.userSessionData.getSessionUser();
    }

    public OrganizationFieldView getOrganizationField() {
        return null;
    }

    public int getManagedApplicationId() {
        return this.managedApplication.getId();
    }

    public DocumentConverter getDocumentConverter() {
        return this.documentConverterSupplier != null ? this.documentConverterSupplier.get() : null;
    }

    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.responsiveApplication.getMultiProgressDisplay();
    }

    public void showPerspective(Perspective perspective) {
        this.responsiveApplication.showPerspective(perspective);
    }

    public ApplicationDesktop createApplicationDesktop() {
        return this.userSessionData.getApplicationDesktopSupplier().get();
    }

    public boolean isDarkTheme() {
        return this.managedApplication.getDarkTheme();
    }

    public UiComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public LoadedApplication getMainApplication() {
        return this.registry.getLoadedApplication(this.managedApplication.getMainApplication());
    }

    public ApplicationConfig<?> getApplicationConfig() {
        return this.getMainApplication().getBaseApplicationBuilder().getApplicationConfig();
    }

    public void writeActivityLog(String title, String data) {
        SystemLog.create().setManagedApplication(this.managedApplication).setApplication(this.application).setLogLevel(LogLevel.INFO).setMessage(title).setDetails(data).save();
    }

    public void writeExceptionLog(String title, Throwable throwable) {
        SystemLog.create().setManagedApplication(this.managedApplication).setApplication(this.application).setLogLevel(LogLevel.ERROR).setMessage(title).setDetails(ExceptionUtils.getStackTrace((Throwable)throwable)).save();
    }

    public String getLocalized(String s, Object ... objects) {
        return this.localizationProvider.getLocalized(s, objects);
    }

    public String getLocalized(TranslatableText translatableText) {
        return this.localizationProvider.getLocalized(translatableText);
    }

    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        return this.privilegeProvider.isAllowed(simplePrivilege);
    }

    public boolean isAllowed(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege, OrganizationUnitView organizationUnitView) {
        return this.privilegeProvider.isAllowed(simpleOrganizationalPrivilege, organizationUnitView);
    }

    public boolean isAllowed(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege, PrivilegeObject privilegeObject) {
        return this.privilegeProvider.isAllowed(simpleCustomObjectPrivilege, privilegeObject);
    }

    public boolean isAllowed(StandardPrivilegeGroup standardPrivilegeGroup, Privilege privilege) {
        return this.privilegeProvider.isAllowed(standardPrivilegeGroup, privilege);
    }

    public boolean isAllowed(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege, OrganizationUnitView organizationUnitView) {
        return this.privilegeProvider.isAllowed(organizationalPrivilegeGroup, privilege, organizationUnitView);
    }

    public boolean isAllowed(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.privilegeProvider.isAllowed(customObjectPrivilegeGroup, privilege, privilegeObject);
    }

    public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege simpleOrganizationalPrivilege) {
        return this.privilegeProvider.getAllowedUnits(simpleOrganizationalPrivilege);
    }

    public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Privilege privilege) {
        return this.privilegeProvider.getAllowedUnits(organizationalPrivilegeGroup, privilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simpleCustomObjectPrivilege) {
        return this.privilegeProvider.getAllowedPrivilegeObjects(simpleCustomObjectPrivilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup customObjectPrivilegeGroup, Privilege privilege) {
        return this.privilegeProvider.getAllowedPrivilegeObjects(customObjectPrivilegeGroup, privilege);
    }
}

