/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Appointment;
import org.teamapps.model.controlcenter.AppointmentSeries;
import org.teamapps.model.controlcenter.Message;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;

public class UdbAppointment
extends AbstractUdbEntity<Appointment>
implements Appointment {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static SingleReferenceIndex message;
    protected static SingleReferenceIndex appointmentSeries;
    protected static BooleanIndex webConference;
    protected static LongIndex startDateTime;
    protected static LongIndex endDateTime;
    protected static BooleanIndex fullDayEvent;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        message = (SingleReferenceIndex)tableIndex.getColumnIndex("message");
        appointmentSeries = (SingleReferenceIndex)tableIndex.getColumnIndex("appointmentSeries");
        webConference = (BooleanIndex)tableIndex.getColumnIndex("webConference");
        startDateTime = (LongIndex)tableIndex.getColumnIndex("startDateTime");
        endDateTime = (LongIndex)tableIndex.getColumnIndex("endDateTime");
        fullDayEvent = (BooleanIndex)tableIndex.getColumnIndex("fullDayEvent");
    }

    public static List<Appointment> getAll() {
        return new EntityBitSetList(Appointment.getBuilder(), table.getRecordBitSet());
    }

    public static List<Appointment> sort(List<Appointment> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbAppointment.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<Appointment> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbAppointment.sort((TableIndex)table, Appointment.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbAppointment() {
        super(table);
    }

    public UdbAppointment(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public Appointment build() {
        return new UdbAppointment();
    }

    public Appointment build(int id) {
        return new UdbAppointment(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public Appointment setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public Appointment setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public Appointment setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public Appointment setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public Appointment setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public Appointment setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public Appointment setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public Appointment setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public Appointment setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public Appointment setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public Appointment setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public Appointment setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public Message getMessage() {
        if (this.isChanged((ColumnIndex)message)) {
            return (Message)this.getReferenceChangeValue((ColumnIndex)message);
        }
        int id = message.getValue(this.getId());
        if (id > 0) {
            return Message.getById(id);
        }
        return null;
    }

    @Override
    public Appointment setMessage(Message value) {
        this.setSingleReferenceValue(message, value, table);
        return this;
    }

    @Override
    public AppointmentSeries getAppointmentSeries() {
        if (this.isChanged((ColumnIndex)appointmentSeries)) {
            return (AppointmentSeries)this.getReferenceChangeValue((ColumnIndex)appointmentSeries);
        }
        int id = appointmentSeries.getValue(this.getId());
        if (id > 0) {
            return AppointmentSeries.getById(id);
        }
        return null;
    }

    @Override
    public Appointment setAppointmentSeries(AppointmentSeries value) {
        this.setSingleReferenceValue(appointmentSeries, value, table);
        return this;
    }

    @Override
    public boolean getWebConference() {
        return this.getBooleanValue(webConference);
    }

    @Override
    public Appointment setWebConference(boolean value) {
        this.setBooleanValue(value, webConference);
        return this;
    }

    @Override
    public boolean isWebConference() {
        return this.getBooleanValue(webConference);
    }

    @Override
    public Instant getStartDateTime() {
        return this.getDateTimeValue(startDateTime);
    }

    @Override
    public Appointment setStartDateTime(Instant value) {
        this.setDateTimeValue(value, startDateTime);
        return this;
    }

    @Override
    public long getStartDateTimeAsEpochMilli() {
        return this.getDateTimeAsEpochMilli(startDateTime);
    }

    @Override
    public Appointment setStartDateTimeAsEpochMilli(long value) {
        this.setDateTimeAsEpochMilli(value, startDateTime);
        return this;
    }

    @Override
    public Instant getEndDateTime() {
        return this.getDateTimeValue(endDateTime);
    }

    @Override
    public Appointment setEndDateTime(Instant value) {
        this.setDateTimeValue(value, endDateTime);
        return this;
    }

    @Override
    public long getEndDateTimeAsEpochMilli() {
        return this.getDateTimeAsEpochMilli(endDateTime);
    }

    @Override
    public Appointment setEndDateTimeAsEpochMilli(long value) {
        this.setDateTimeAsEpochMilli(value, endDateTime);
        return this;
    }

    @Override
    public boolean getFullDayEvent() {
        return this.getBooleanValue(fullDayEvent);
    }

    @Override
    public Appointment setFullDayEvent(boolean value) {
        this.setBooleanValue(value, fullDayEvent);
        return this;
    }

    @Override
    public boolean isFullDayEvent() {
        return this.getBooleanValue(fullDayEvent);
    }

    public UdbAppointment save(Transaction transaction, boolean strictChangeVerification) {
        this.save(transaction, table, strictChangeVerification);
        return this;
    }

    public UdbAppointment saveTransactional(boolean strictChangeVerification) {
        this.save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    public UdbAppointment save() {
        this.save(table);
        return this;
    }

    public void delete(Transaction transaction) {
        this.delete(transaction, table);
    }

    public void delete() {
        this.delete(table);
    }
}

