/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.ChatChannel;
import org.teamapps.model.controlcenter.ChatMessage;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;

public class UdbChatChannel
extends AbstractUdbEntity<ChatChannel>
implements ChatChannel {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static TextIndex title;
    protected static MultiReferenceIndex chatMessages;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        title = (TextIndex)tableIndex.getColumnIndex("title");
        chatMessages = (MultiReferenceIndex)tableIndex.getColumnIndex("chatMessages");
    }

    public static List<ChatChannel> getAll() {
        return new EntityBitSetList(ChatChannel.getBuilder(), table.getRecordBitSet());
    }

    public static List<ChatChannel> sort(List<ChatChannel> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbChatChannel.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<ChatChannel> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbChatChannel.sort((TableIndex)table, ChatChannel.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbChatChannel() {
        super(table);
    }

    public UdbChatChannel(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public ChatChannel build() {
        return new UdbChatChannel();
    }

    public ChatChannel build(int id) {
        return new UdbChatChannel(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public ChatChannel setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public ChatChannel setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public ChatChannel setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public ChatChannel setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public ChatChannel setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public ChatChannel setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public ChatChannel setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public ChatChannel setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public ChatChannel setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public ChatChannel setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public ChatChannel setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public ChatChannel setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public String getTitle() {
        return this.getTextValue(title);
    }

    @Override
    public ChatChannel setTitle(String value) {
        this.setTextValue(value, title);
        return this;
    }

    @Override
    public List<ChatMessage> getChatMessages() {
        return this.getMultiReferenceValue(chatMessages, ChatMessage.getBuilder());
    }

    @Override
    public ChatChannel setChatMessages(List<ChatMessage> value) {
        this.setMultiReferenceValue(value, chatMessages);
        return this;
    }

    @Override
    public int getChatMessagesCount() {
        return this.getMultiReferenceValueCount(chatMessages, ChatMessage.getBuilder());
    }

    @Override
    public ChatChannel setChatMessages(ChatMessage ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), chatMessages);
        return this;
    }

    @Override
    public BitSet getChatMessagesAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(chatMessages, ChatMessage.getBuilder());
    }

    @Override
    public ChatChannel addChatMessages(List<ChatMessage> value) {
        this.addMultiReferenceValue(value, chatMessages);
        return this;
    }

    @Override
    public ChatChannel addChatMessages(ChatMessage ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), chatMessages);
        return this;
    }

    @Override
    public ChatChannel removeChatMessages(List<ChatMessage> value) {
        this.removeMultiReferenceValue(value, chatMessages);
        return this;
    }

    @Override
    public ChatChannel removeChatMessages(ChatMessage ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), chatMessages);
        return this;
    }

    @Override
    public ChatChannel removeAllChatMessages() {
        this.removeAllMultiReferenceValue(chatMessages);
        return this;
    }

    public UdbChatChannel save(Transaction transaction, boolean strictChangeVerification) {
        this.save(transaction, table, strictChangeVerification);
        return this;
    }

    public UdbChatChannel saveTransactional(boolean strictChangeVerification) {
        this.save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    public UdbChatChannel save() {
        this.save(table);
        return this;
    }

    public void delete(Transaction transaction) {
        this.delete(transaction, table);
    }

    public void delete() {
        this.delete(table);
    }
}

