/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Group;
import org.teamapps.model.controlcenter.GroupFolder;
import org.teamapps.model.controlcenter.GroupMembershipDefinition;
import org.teamapps.model.controlcenter.GroupType;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserGroupMembership;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;

public class UdbGroup
extends AbstractUdbEntity<Group>
implements Group {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static ShortIndex groupType;
    protected static TextIndex name;
    protected static TextIndex description;
    protected static TextIndex language;
    protected static SingleReferenceIndex organizationField;
    protected static SingleReferenceIndex organizationUnit;
    protected static SingleReferenceIndex owner;
    protected static MultiReferenceIndex moderators;
    protected static MultiReferenceIndex mentors;
    protected static BooleanIndex valid;
    protected static MultiReferenceIndex membershipDefinitions;
    protected static MultiReferenceIndex registrationAllowedForDefinitions;
    protected static MultiReferenceIndex userMemberships;
    protected static IntegerIndex lastMessageDate;
    protected static MultiReferenceIndex groupFolders;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        groupType = (ShortIndex)tableIndex.getColumnIndex("groupType");
        name = (TextIndex)tableIndex.getColumnIndex("name");
        description = (TextIndex)tableIndex.getColumnIndex("description");
        language = (TextIndex)tableIndex.getColumnIndex("language");
        organizationField = (SingleReferenceIndex)tableIndex.getColumnIndex("organizationField");
        organizationUnit = (SingleReferenceIndex)tableIndex.getColumnIndex("organizationUnit");
        owner = (SingleReferenceIndex)tableIndex.getColumnIndex("owner");
        moderators = (MultiReferenceIndex)tableIndex.getColumnIndex("moderators");
        mentors = (MultiReferenceIndex)tableIndex.getColumnIndex("mentors");
        valid = (BooleanIndex)tableIndex.getColumnIndex("valid");
        membershipDefinitions = (MultiReferenceIndex)tableIndex.getColumnIndex("membershipDefinitions");
        registrationAllowedForDefinitions = (MultiReferenceIndex)tableIndex.getColumnIndex("registrationAllowedForDefinitions");
        userMemberships = (MultiReferenceIndex)tableIndex.getColumnIndex("userMemberships");
        lastMessageDate = (IntegerIndex)tableIndex.getColumnIndex("lastMessageDate");
        groupFolders = (MultiReferenceIndex)tableIndex.getColumnIndex("groupFolders");
    }

    public static List<Group> getAll() {
        return new EntityBitSetList(Group.getBuilder(), table.getRecordBitSet());
    }

    public static List<Group> sort(List<Group> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbGroup.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<Group> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbGroup.sort((TableIndex)table, Group.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbGroup() {
        super(table);
    }

    public UdbGroup(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public Group build() {
        return new UdbGroup();
    }

    public Group build(int id) {
        return new UdbGroup(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public Group setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public Group setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public Group setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public Group setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public Group setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public Group setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public Group setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public Group setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public Group setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public Group setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public Group setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public Group setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public GroupType getGroupType() {
        return (GroupType)this.getEnumValue(groupType, GroupType.values());
    }

    @Override
    public Group setGroupType(GroupType value) {
        this.setEnumValue(groupType, value);
        return this;
    }

    @Override
    public String getName() {
        return this.getTextValue(name);
    }

    @Override
    public Group setName(String value) {
        this.setTextValue(value, name);
        return this;
    }

    @Override
    public String getDescription() {
        return this.getTextValue(description);
    }

    @Override
    public Group setDescription(String value) {
        this.setTextValue(value, description);
        return this;
    }

    @Override
    public String getLanguage() {
        return this.getTextValue(language);
    }

    @Override
    public Group setLanguage(String value) {
        this.setTextValue(value, language);
        return this;
    }

    @Override
    public OrganizationField getOrganizationField() {
        if (this.isChanged((ColumnIndex)organizationField)) {
            return (OrganizationField)this.getReferenceChangeValue((ColumnIndex)organizationField);
        }
        int id = organizationField.getValue(this.getId());
        if (id > 0) {
            return OrganizationField.getById(id);
        }
        return null;
    }

    @Override
    public Group setOrganizationField(OrganizationField value) {
        this.setSingleReferenceValue(organizationField, value, table);
        return this;
    }

    @Override
    public OrganizationUnit getOrganizationUnit() {
        if (this.isChanged((ColumnIndex)organizationUnit)) {
            return (OrganizationUnit)this.getReferenceChangeValue((ColumnIndex)organizationUnit);
        }
        int id = organizationUnit.getValue(this.getId());
        if (id > 0) {
            return OrganizationUnit.getById(id);
        }
        return null;
    }

    @Override
    public Group setOrganizationUnit(OrganizationUnit value) {
        this.setSingleReferenceValue(organizationUnit, value, table);
        return this;
    }

    @Override
    public User getOwner() {
        if (this.isChanged((ColumnIndex)owner)) {
            return (User)this.getReferenceChangeValue((ColumnIndex)owner);
        }
        int id = owner.getValue(this.getId());
        if (id > 0) {
            return User.getById(id);
        }
        return null;
    }

    @Override
    public Group setOwner(User value) {
        this.setSingleReferenceValue(owner, value, table);
        return this;
    }

    @Override
    public List<User> getModerators() {
        return this.getMultiReferenceValue(moderators, User.getBuilder());
    }

    @Override
    public Group setModerators(List<User> value) {
        this.setMultiReferenceValue(value, moderators);
        return this;
    }

    @Override
    public int getModeratorsCount() {
        return this.getMultiReferenceValueCount(moderators, User.getBuilder());
    }

    @Override
    public Group setModerators(User ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), moderators);
        return this;
    }

    @Override
    public BitSet getModeratorsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(moderators, User.getBuilder());
    }

    @Override
    public Group addModerators(List<User> value) {
        this.addMultiReferenceValue(value, moderators);
        return this;
    }

    @Override
    public Group addModerators(User ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), moderators);
        return this;
    }

    @Override
    public Group removeModerators(List<User> value) {
        this.removeMultiReferenceValue(value, moderators);
        return this;
    }

    @Override
    public Group removeModerators(User ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), moderators);
        return this;
    }

    @Override
    public Group removeAllModerators() {
        this.removeAllMultiReferenceValue(moderators);
        return this;
    }

    @Override
    public List<User> getMentors() {
        return this.getMultiReferenceValue(mentors, User.getBuilder());
    }

    @Override
    public Group setMentors(List<User> value) {
        this.setMultiReferenceValue(value, mentors);
        return this;
    }

    @Override
    public int getMentorsCount() {
        return this.getMultiReferenceValueCount(mentors, User.getBuilder());
    }

    @Override
    public Group setMentors(User ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), mentors);
        return this;
    }

    @Override
    public BitSet getMentorsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(mentors, User.getBuilder());
    }

    @Override
    public Group addMentors(List<User> value) {
        this.addMultiReferenceValue(value, mentors);
        return this;
    }

    @Override
    public Group addMentors(User ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), mentors);
        return this;
    }

    @Override
    public Group removeMentors(List<User> value) {
        this.removeMultiReferenceValue(value, mentors);
        return this;
    }

    @Override
    public Group removeMentors(User ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), mentors);
        return this;
    }

    @Override
    public Group removeAllMentors() {
        this.removeAllMultiReferenceValue(mentors);
        return this;
    }

    @Override
    public boolean getValid() {
        return this.getBooleanValue(valid);
    }

    @Override
    public Group setValid(boolean value) {
        this.setBooleanValue(value, valid);
        return this;
    }

    @Override
    public boolean isValid() {
        return this.getBooleanValue(valid);
    }

    @Override
    public List<GroupMembershipDefinition> getMembershipDefinitions() {
        return this.getMultiReferenceValue(membershipDefinitions, GroupMembershipDefinition.getBuilder());
    }

    @Override
    public Group setMembershipDefinitions(List<GroupMembershipDefinition> value) {
        this.setMultiReferenceValue(value, membershipDefinitions);
        return this;
    }

    @Override
    public int getMembershipDefinitionsCount() {
        return this.getMultiReferenceValueCount(membershipDefinitions, GroupMembershipDefinition.getBuilder());
    }

    @Override
    public Group setMembershipDefinitions(GroupMembershipDefinition ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), membershipDefinitions);
        return this;
    }

    @Override
    public BitSet getMembershipDefinitionsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(membershipDefinitions, GroupMembershipDefinition.getBuilder());
    }

    @Override
    public Group addMembershipDefinitions(List<GroupMembershipDefinition> value) {
        this.addMultiReferenceValue(value, membershipDefinitions);
        return this;
    }

    @Override
    public Group addMembershipDefinitions(GroupMembershipDefinition ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), membershipDefinitions);
        return this;
    }

    @Override
    public Group removeMembershipDefinitions(List<GroupMembershipDefinition> value) {
        this.removeMultiReferenceValue(value, membershipDefinitions);
        return this;
    }

    @Override
    public Group removeMembershipDefinitions(GroupMembershipDefinition ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), membershipDefinitions);
        return this;
    }

    @Override
    public Group removeAllMembershipDefinitions() {
        this.removeAllMultiReferenceValue(membershipDefinitions);
        return this;
    }

    @Override
    public List<GroupMembershipDefinition> getRegistrationAllowedForDefinitions() {
        return this.getMultiReferenceValue(registrationAllowedForDefinitions, GroupMembershipDefinition.getBuilder());
    }

    @Override
    public Group setRegistrationAllowedForDefinitions(List<GroupMembershipDefinition> value) {
        this.setMultiReferenceValue(value, registrationAllowedForDefinitions);
        return this;
    }

    @Override
    public int getRegistrationAllowedForDefinitionsCount() {
        return this.getMultiReferenceValueCount(registrationAllowedForDefinitions, GroupMembershipDefinition.getBuilder());
    }

    @Override
    public Group setRegistrationAllowedForDefinitions(GroupMembershipDefinition ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), registrationAllowedForDefinitions);
        return this;
    }

    @Override
    public BitSet getRegistrationAllowedForDefinitionsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(registrationAllowedForDefinitions, GroupMembershipDefinition.getBuilder());
    }

    @Override
    public Group addRegistrationAllowedForDefinitions(List<GroupMembershipDefinition> value) {
        this.addMultiReferenceValue(value, registrationAllowedForDefinitions);
        return this;
    }

    @Override
    public Group addRegistrationAllowedForDefinitions(GroupMembershipDefinition ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), registrationAllowedForDefinitions);
        return this;
    }

    @Override
    public Group removeRegistrationAllowedForDefinitions(List<GroupMembershipDefinition> value) {
        this.removeMultiReferenceValue(value, registrationAllowedForDefinitions);
        return this;
    }

    @Override
    public Group removeRegistrationAllowedForDefinitions(GroupMembershipDefinition ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), registrationAllowedForDefinitions);
        return this;
    }

    @Override
    public Group removeAllRegistrationAllowedForDefinitions() {
        this.removeAllMultiReferenceValue(registrationAllowedForDefinitions);
        return this;
    }

    @Override
    public List<UserGroupMembership> getUserMemberships() {
        return this.getMultiReferenceValue(userMemberships, UserGroupMembership.getBuilder());
    }

    @Override
    public Group setUserMemberships(List<UserGroupMembership> value) {
        this.setMultiReferenceValue(value, userMemberships);
        return this;
    }

    @Override
    public int getUserMembershipsCount() {
        return this.getMultiReferenceValueCount(userMemberships, UserGroupMembership.getBuilder());
    }

    @Override
    public Group setUserMemberships(UserGroupMembership ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), userMemberships);
        return this;
    }

    @Override
    public BitSet getUserMembershipsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(userMemberships, UserGroupMembership.getBuilder());
    }

    @Override
    public Group addUserMemberships(List<UserGroupMembership> value) {
        this.addMultiReferenceValue(value, userMemberships);
        return this;
    }

    @Override
    public Group addUserMemberships(UserGroupMembership ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), userMemberships);
        return this;
    }

    @Override
    public Group removeUserMemberships(List<UserGroupMembership> value) {
        this.removeMultiReferenceValue(value, userMemberships);
        return this;
    }

    @Override
    public Group removeUserMemberships(UserGroupMembership ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), userMemberships);
        return this;
    }

    @Override
    public Group removeAllUserMemberships() {
        this.removeAllMultiReferenceValue(userMemberships);
        return this;
    }

    @Override
    public Instant getLastMessageDate() {
        return this.getTimestampValue(lastMessageDate);
    }

    @Override
    public Group setLastMessageDate(Instant value) {
        this.setTimestampValue(value, lastMessageDate);
        return this;
    }

    @Override
    public int getLastMessageDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(lastMessageDate);
    }

    @Override
    public Group setLastMessageDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, lastMessageDate);
        return this;
    }

    @Override
    public long getLastMessageDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(lastMessageDate);
    }

    @Override
    public Group setLastMessageDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, lastMessageDate);
        return this;
    }

    @Override
    public List<GroupFolder> getGroupFolders() {
        return this.getMultiReferenceValue(groupFolders, GroupFolder.getBuilder());
    }

    @Override
    public Group setGroupFolders(List<GroupFolder> value) {
        this.setMultiReferenceValue(value, groupFolders);
        return this;
    }

    @Override
    public int getGroupFoldersCount() {
        return this.getMultiReferenceValueCount(groupFolders, GroupFolder.getBuilder());
    }

    @Override
    public Group setGroupFolders(GroupFolder ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), groupFolders);
        return this;
    }

    @Override
    public BitSet getGroupFoldersAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(groupFolders, GroupFolder.getBuilder());
    }

    @Override
    public Group addGroupFolders(List<GroupFolder> value) {
        this.addMultiReferenceValue(value, groupFolders);
        return this;
    }

    @Override
    public Group addGroupFolders(GroupFolder ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), groupFolders);
        return this;
    }

    @Override
    public Group removeGroupFolders(List<GroupFolder> value) {
        this.removeMultiReferenceValue(value, groupFolders);
        return this;
    }

    @Override
    public Group removeGroupFolders(GroupFolder ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), groupFolders);
        return this;
    }

    @Override
    public Group removeAllGroupFolders() {
        this.removeAllMultiReferenceValue(groupFolders);
        return this;
    }

    public UdbGroup save(Transaction transaction, boolean strictChangeVerification) {
        this.save(transaction, table, strictChangeVerification);
        return this;
    }

    public UdbGroup saveTransactional(boolean strictChangeVerification) {
        this.save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    public UdbGroup save() {
        this.save(table);
        return this;
    }

    public void delete(Transaction transaction) {
        this.delete(transaction, table);
    }

    public void delete() {
        this.delete(table);
    }
}

