/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.model.controlcenter.Address;
import org.teamapps.model.controlcenter.Message;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserAcceptedPolicy;
import org.teamapps.model.controlcenter.UserAccessToken;
import org.teamapps.model.controlcenter.UserAccountStatus;
import org.teamapps.model.controlcenter.UserGroupMembership;
import org.teamapps.model.controlcenter.UserRoleAssignment;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.binary.BinaryIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;

public class UdbUser
extends AbstractUdbEntity<User>
implements User {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static TextIndex firstName;
    protected static TextIndex lastName;
    protected static BinaryIndex profilePicture;
    protected static BinaryIndex profilePictureLarge;
    protected static TextIndex languages;
    protected static TextIndex email;
    protected static TextIndex mobile;
    protected static TextIndex phone;
    protected static TextIndex login;
    protected static IntegerIndex lastLogin;
    protected static TextIndex password;
    protected static TextIndex theme;
    protected static ShortIndex userAccountStatus;
    protected static SingleReferenceIndex acceptedPolicies;
    protected static SingleReferenceIndex address;
    protected static SingleReferenceIndex organizationUnit;
    protected static MultiReferenceIndex accessTokens;
    protected static MultiReferenceIndex roleAssignments;
    protected static MultiReferenceIndex allGroupMemberships;
    protected static MultiReferenceIndex privateMessages;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        firstName = (TextIndex)tableIndex.getColumnIndex("firstName");
        lastName = (TextIndex)tableIndex.getColumnIndex("lastName");
        profilePicture = (BinaryIndex)tableIndex.getColumnIndex("profilePicture");
        profilePictureLarge = (BinaryIndex)tableIndex.getColumnIndex("profilePictureLarge");
        languages = (TextIndex)tableIndex.getColumnIndex("languages");
        email = (TextIndex)tableIndex.getColumnIndex("email");
        mobile = (TextIndex)tableIndex.getColumnIndex("mobile");
        phone = (TextIndex)tableIndex.getColumnIndex("phone");
        login = (TextIndex)tableIndex.getColumnIndex("login");
        lastLogin = (IntegerIndex)tableIndex.getColumnIndex("lastLogin");
        password = (TextIndex)tableIndex.getColumnIndex("password");
        theme = (TextIndex)tableIndex.getColumnIndex("theme");
        userAccountStatus = (ShortIndex)tableIndex.getColumnIndex("userAccountStatus");
        acceptedPolicies = (SingleReferenceIndex)tableIndex.getColumnIndex("acceptedPolicies");
        address = (SingleReferenceIndex)tableIndex.getColumnIndex("address");
        organizationUnit = (SingleReferenceIndex)tableIndex.getColumnIndex("organizationUnit");
        accessTokens = (MultiReferenceIndex)tableIndex.getColumnIndex("accessTokens");
        roleAssignments = (MultiReferenceIndex)tableIndex.getColumnIndex("roleAssignments");
        allGroupMemberships = (MultiReferenceIndex)tableIndex.getColumnIndex("allGroupMemberships");
        privateMessages = (MultiReferenceIndex)tableIndex.getColumnIndex("privateMessages");
    }

    public static List<User> getAll() {
        return new EntityBitSetList(User.getBuilder(), table.getRecordBitSet());
    }

    public static List<User> sort(List<User> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbUser.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static List<User> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return UdbUser.sort((TableIndex)table, User.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUser() {
        super(table);
    }

    public UdbUser(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public User build() {
        return new UdbUser();
    }

    public User build(int id) {
        return new UdbUser(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public User setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public User setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public User setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public User setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public User setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public User setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public User setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public User setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public User setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public User setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public User setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public User setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public String getFirstName() {
        return this.getTextValue(firstName);
    }

    @Override
    public User setFirstName(String value) {
        this.setTextValue(value, firstName);
        return this;
    }

    @Override
    public String getLastName() {
        return this.getTextValue(lastName);
    }

    @Override
    public User setLastName(String value) {
        this.setTextValue(value, lastName);
        return this;
    }

    @Override
    public byte[] getProfilePicture() {
        if (this.isChanged((ColumnIndex)profilePicture)) {
            return (byte[])this.getChangedValue((ColumnIndex)profilePicture);
        }
        return profilePicture.getValue(this.getId());
    }

    @Override
    public User setProfilePicture(byte[] value) {
        this.setChangeValue((ColumnIndex)profilePicture, value, table);
        return this;
    }

    @Override
    public int getProfilePictureLength() {
        if (this.isChanged((ColumnIndex)profilePicture)) {
            byte[] bytes = (byte[])this.getChangedValue((ColumnIndex)profilePicture);
            return bytes != null ? bytes.length : 0;
        }
        return profilePicture.getLength(this.getId());
    }

    @Override
    public Supplier<InputStream> getProfilePictureInputStreamSupplier() {
        if (this.isChanged((ColumnIndex)profilePicture)) {
            byte[] bytes = (byte[])this.getChangedValue((ColumnIndex)profilePicture);
            if (bytes == null) {
                return null;
            }
            return () -> new ByteArrayInputStream(bytes);
        }
        return profilePicture.getInputStreamSupplier(this.getId());
    }

    @Override
    public byte[] getProfilePictureLarge() {
        if (this.isChanged((ColumnIndex)profilePictureLarge)) {
            return (byte[])this.getChangedValue((ColumnIndex)profilePictureLarge);
        }
        return profilePictureLarge.getValue(this.getId());
    }

    @Override
    public User setProfilePictureLarge(byte[] value) {
        this.setChangeValue((ColumnIndex)profilePictureLarge, value, table);
        return this;
    }

    @Override
    public int getProfilePictureLargeLength() {
        if (this.isChanged((ColumnIndex)profilePictureLarge)) {
            byte[] bytes = (byte[])this.getChangedValue((ColumnIndex)profilePictureLarge);
            return bytes != null ? bytes.length : 0;
        }
        return profilePictureLarge.getLength(this.getId());
    }

    @Override
    public Supplier<InputStream> getProfilePictureLargeInputStreamSupplier() {
        if (this.isChanged((ColumnIndex)profilePictureLarge)) {
            byte[] bytes = (byte[])this.getChangedValue((ColumnIndex)profilePictureLarge);
            if (bytes == null) {
                return null;
            }
            return () -> new ByteArrayInputStream(bytes);
        }
        return profilePictureLarge.getInputStreamSupplier(this.getId());
    }

    @Override
    public String getLanguages() {
        return this.getTextValue(languages);
    }

    @Override
    public User setLanguages(String value) {
        this.setTextValue(value, languages);
        return this;
    }

    @Override
    public String getEmail() {
        return this.getTextValue(email);
    }

    @Override
    public User setEmail(String value) {
        this.setTextValue(value, email);
        return this;
    }

    @Override
    public String getMobile() {
        return this.getTextValue(mobile);
    }

    @Override
    public User setMobile(String value) {
        this.setTextValue(value, mobile);
        return this;
    }

    @Override
    public String getPhone() {
        return this.getTextValue(phone);
    }

    @Override
    public User setPhone(String value) {
        this.setTextValue(value, phone);
        return this;
    }

    @Override
    public String getLogin() {
        return this.getTextValue(login);
    }

    @Override
    public User setLogin(String value) {
        this.setTextValue(value, login);
        return this;
    }

    @Override
    public Instant getLastLogin() {
        return this.getTimestampValue(lastLogin);
    }

    @Override
    public User setLastLogin(Instant value) {
        this.setTimestampValue(value, lastLogin);
        return this;
    }

    @Override
    public int getLastLoginAsEpochSecond() {
        return this.getTimestampAsEpochSecond(lastLogin);
    }

    @Override
    public User setLastLoginAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, lastLogin);
        return this;
    }

    @Override
    public long getLastLoginAsEpochMilli() {
        return this.getTimestampAsEpochMilli(lastLogin);
    }

    @Override
    public User setLastLoginAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, lastLogin);
        return this;
    }

    @Override
    public String getPassword() {
        return this.getTextValue(password);
    }

    @Override
    public User setPassword(String value) {
        this.setTextValue(value, password);
        return this;
    }

    @Override
    public String getTheme() {
        return this.getTextValue(theme);
    }

    @Override
    public User setTheme(String value) {
        this.setTextValue(value, theme);
        return this;
    }

    @Override
    public UserAccountStatus getUserAccountStatus() {
        return (UserAccountStatus)this.getEnumValue(userAccountStatus, UserAccountStatus.values());
    }

    @Override
    public User setUserAccountStatus(UserAccountStatus value) {
        this.setEnumValue(userAccountStatus, value);
        return this;
    }

    @Override
    public UserAcceptedPolicy getAcceptedPolicies() {
        if (this.isChanged((ColumnIndex)acceptedPolicies)) {
            return (UserAcceptedPolicy)this.getReferenceChangeValue((ColumnIndex)acceptedPolicies);
        }
        int id = acceptedPolicies.getValue(this.getId());
        if (id > 0) {
            return UserAcceptedPolicy.getById(id);
        }
        return null;
    }

    @Override
    public User setAcceptedPolicies(UserAcceptedPolicy value) {
        this.setSingleReferenceValue(acceptedPolicies, value, table);
        return this;
    }

    @Override
    public Address getAddress() {
        if (this.isChanged((ColumnIndex)address)) {
            return (Address)this.getReferenceChangeValue((ColumnIndex)address);
        }
        int id = address.getValue(this.getId());
        if (id > 0) {
            return Address.getById(id);
        }
        return null;
    }

    @Override
    public User setAddress(Address value) {
        this.setSingleReferenceValue(address, value, table);
        return this;
    }

    @Override
    public OrganizationUnit getOrganizationUnit() {
        if (this.isChanged((ColumnIndex)organizationUnit)) {
            return (OrganizationUnit)this.getReferenceChangeValue((ColumnIndex)organizationUnit);
        }
        int id = organizationUnit.getValue(this.getId());
        if (id > 0) {
            return OrganizationUnit.getById(id);
        }
        return null;
    }

    @Override
    public User setOrganizationUnit(OrganizationUnit value) {
        this.setSingleReferenceValue(organizationUnit, value, table);
        return this;
    }

    @Override
    public List<UserAccessToken> getAccessTokens() {
        return this.getMultiReferenceValue(accessTokens, UserAccessToken.getBuilder());
    }

    @Override
    public User setAccessTokens(List<UserAccessToken> value) {
        this.setMultiReferenceValue(value, accessTokens);
        return this;
    }

    @Override
    public int getAccessTokensCount() {
        return this.getMultiReferenceValueCount(accessTokens, UserAccessToken.getBuilder());
    }

    @Override
    public User setAccessTokens(UserAccessToken ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), accessTokens);
        return this;
    }

    @Override
    public BitSet getAccessTokensAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(accessTokens, UserAccessToken.getBuilder());
    }

    @Override
    public User addAccessTokens(List<UserAccessToken> value) {
        this.addMultiReferenceValue(value, accessTokens);
        return this;
    }

    @Override
    public User addAccessTokens(UserAccessToken ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), accessTokens);
        return this;
    }

    @Override
    public User removeAccessTokens(List<UserAccessToken> value) {
        this.removeMultiReferenceValue(value, accessTokens);
        return this;
    }

    @Override
    public User removeAccessTokens(UserAccessToken ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), accessTokens);
        return this;
    }

    @Override
    public User removeAllAccessTokens() {
        this.removeAllMultiReferenceValue(accessTokens);
        return this;
    }

    @Override
    public List<UserRoleAssignment> getRoleAssignments() {
        return this.getMultiReferenceValue(roleAssignments, UserRoleAssignment.getBuilder());
    }

    @Override
    public User setRoleAssignments(List<UserRoleAssignment> value) {
        this.setMultiReferenceValue(value, roleAssignments);
        return this;
    }

    @Override
    public int getRoleAssignmentsCount() {
        return this.getMultiReferenceValueCount(roleAssignments, UserRoleAssignment.getBuilder());
    }

    @Override
    public User setRoleAssignments(UserRoleAssignment ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), roleAssignments);
        return this;
    }

    @Override
    public BitSet getRoleAssignmentsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(roleAssignments, UserRoleAssignment.getBuilder());
    }

    @Override
    public User addRoleAssignments(List<UserRoleAssignment> value) {
        this.addMultiReferenceValue(value, roleAssignments);
        return this;
    }

    @Override
    public User addRoleAssignments(UserRoleAssignment ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), roleAssignments);
        return this;
    }

    @Override
    public User removeRoleAssignments(List<UserRoleAssignment> value) {
        this.removeMultiReferenceValue(value, roleAssignments);
        return this;
    }

    @Override
    public User removeRoleAssignments(UserRoleAssignment ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), roleAssignments);
        return this;
    }

    @Override
    public User removeAllRoleAssignments() {
        this.removeAllMultiReferenceValue(roleAssignments);
        return this;
    }

    @Override
    public List<UserGroupMembership> getAllGroupMemberships() {
        return this.getMultiReferenceValue(allGroupMemberships, UserGroupMembership.getBuilder());
    }

    @Override
    public User setAllGroupMemberships(List<UserGroupMembership> value) {
        this.setMultiReferenceValue(value, allGroupMemberships);
        return this;
    }

    @Override
    public int getAllGroupMembershipsCount() {
        return this.getMultiReferenceValueCount(allGroupMemberships, UserGroupMembership.getBuilder());
    }

    @Override
    public User setAllGroupMemberships(UserGroupMembership ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), allGroupMemberships);
        return this;
    }

    @Override
    public BitSet getAllGroupMembershipsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(allGroupMemberships, UserGroupMembership.getBuilder());
    }

    @Override
    public User addAllGroupMemberships(List<UserGroupMembership> value) {
        this.addMultiReferenceValue(value, allGroupMemberships);
        return this;
    }

    @Override
    public User addAllGroupMemberships(UserGroupMembership ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), allGroupMemberships);
        return this;
    }

    @Override
    public User removeAllGroupMemberships(List<UserGroupMembership> value) {
        this.removeMultiReferenceValue(value, allGroupMemberships);
        return this;
    }

    @Override
    public User removeAllGroupMemberships(UserGroupMembership ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), allGroupMemberships);
        return this;
    }

    @Override
    public User removeAllAllGroupMemberships() {
        this.removeAllMultiReferenceValue(allGroupMemberships);
        return this;
    }

    @Override
    public List<Message> getPrivateMessages() {
        return this.getMultiReferenceValue(privateMessages, Message.getBuilder());
    }

    @Override
    public User setPrivateMessages(List<Message> value) {
        this.setMultiReferenceValue(value, privateMessages);
        return this;
    }

    @Override
    public int getPrivateMessagesCount() {
        return this.getMultiReferenceValueCount(privateMessages, Message.getBuilder());
    }

    @Override
    public User setPrivateMessages(Message ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), privateMessages);
        return this;
    }

    @Override
    public BitSet getPrivateMessagesAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(privateMessages, Message.getBuilder());
    }

    @Override
    public User addPrivateMessages(List<Message> value) {
        this.addMultiReferenceValue(value, privateMessages);
        return this;
    }

    @Override
    public User addPrivateMessages(Message ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), privateMessages);
        return this;
    }

    @Override
    public User removePrivateMessages(List<Message> value) {
        this.removeMultiReferenceValue(value, privateMessages);
        return this;
    }

    @Override
    public User removePrivateMessages(Message ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), privateMessages);
        return this;
    }

    @Override
    public User removeAllPrivateMessages() {
        this.removeAllMultiReferenceValue(privateMessages);
        return this;
    }

    public UdbUser save(Transaction transaction, boolean strictChangeVerification) {
        this.save(transaction, table, strictChangeVerification);
        return this;
    }

    public UdbUser saveTransactional(boolean strictChangeVerification) {
        this.save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    public UdbUser save() {
        this.save(table);
        return this;
    }

    public void delete(Transaction transaction) {
        this.delete(transaction, table);
    }

    public void delete() {
        this.delete(table);
    }
}

