/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.teamapps.application.server.ApiHandler;

public class ApiServlet
extends HttpServlet {
    private static final ApiServlet INSTANCE = new ApiServlet();
    private Map<String, ApiHandler> handlerMap = new HashMap<String, ApiHandler>();

    private ApiServlet() {
    }

    public static ApiServlet getInstance() {
        return INSTANCE;
    }

    public void addHandler(String app, ApiHandler handler) {
        this.handlerMap.put(app, handler);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp, true);
    }

    private void handleRequest(HttpServletRequest req, HttpServletResponse resp, boolean post) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null || pathInfo.length() < 3) {
            return;
        }
        String[] parts = pathInfo.split("/");
        String appName = parts[1];
        ArrayList<String> apiPath = new ArrayList<String>();
        if (parts.length > 2) {
            apiPath.addAll(Arrays.asList(parts).subList(2, parts.length));
        }
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        req.getParameterNames().asIterator().forEachRemaining(name -> parameterMap.put((String)name, req.getParameter(name)));
        byte[] bodyData = null;
        if (req.getHeader("transfer-encoding") != null || req.getHeader("content-length") != null) {
            bodyData = IOUtils.toByteArray((InputStream)req.getInputStream());
        }
        String contentType = req.getHeader("content-type");
        ApiHandler apiHandler = this.handlerMap.get(appName);
        if (apiHandler != null) {
            apiHandler.handleApiRequest(apiPath, parameterMap, req, resp, post, contentType, bodyData);
        }
    }
}

