/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.teamapps.application.server.ApplicationServerConfig;
import org.teamapps.application.server.EntityUpdateEventHandler;
import org.teamapps.application.server.SessionHandler;
import org.teamapps.core.TeamAppsCore;
import org.teamapps.protocol.system.LoginData;
import org.teamapps.protocol.system.SystemLogEntry;
import org.teamapps.universaldb.DatabaseManager;
import org.teamapps.universaldb.message.MessageStore;

public class ServerRegistry {
    private final ApplicationServerConfig serverConfig;
    private final DatabaseManager databaseManager;
    private final MessageStore<SystemLogEntry> systemLogMessageStore;
    private final MessageStore<LoginData> loginDataMessageStore;
    private final Supplier<List<SessionHandler>> sessionHandlerSupplier;
    private final TeamAppsCore teamAppsCore;
    private final Map<String, EntityUpdateEventHandler> databaseEventHandlerMap;
    private Map<String, Object> loadedApplications = new ConcurrentHashMap<String, Object>();

    public ServerRegistry(ApplicationServerConfig serverConfig, DatabaseManager databaseManager, MessageStore<SystemLogEntry> systemLogMessageStore, MessageStore<LoginData> loginDataMessageStore, Supplier<List<SessionHandler>> sessionHandlerSupplier, TeamAppsCore teamAppsCore) {
        this.serverConfig = serverConfig;
        this.databaseManager = databaseManager;
        this.databaseEventHandlerMap = new ConcurrentHashMap<String, EntityUpdateEventHandler>();
        this.systemLogMessageStore = systemLogMessageStore;
        this.loginDataMessageStore = loginDataMessageStore;
        this.sessionHandlerSupplier = sessionHandlerSupplier;
        this.teamAppsCore = teamAppsCore;
        databaseManager.addDatabaseHandler(universalDB -> this.databaseEventHandlerMap.put(universalDB.getName(), new EntityUpdateEventHandler(universalDB.getUpdateEventQueue())));
    }

    public ApplicationServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public File getAppsBasePath() {
        return this.serverConfig.getAppDataPath();
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public EntityUpdateEventHandler getEntityUpdateEventHandler(String name) {
        return this.databaseEventHandlerMap.get(name);
    }

    public Map<String, Object> getLoadedApplications() {
        return this.loadedApplications;
    }

    public List<SessionHandler> getSessionHandlers() {
        return this.sessionHandlerSupplier.get();
    }

    public MessageStore<SystemLogEntry> getSystemLogMessageStore() {
        return this.systemLogMessageStore;
    }

    public MessageStore<LoginData> getLoginDataMessageStore() {
        return this.loginDataMessageStore;
    }

    public TeamAppsCore getTeamAppsCore() {
        return this.teamAppsCore;
    }
}

