/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.server.ApiServlet;
import org.teamapps.application.server.ApplicationServerConfig;
import org.teamapps.application.server.DatabaseLogAppender;
import org.teamapps.application.server.EmbeddedResourceStore;
import org.teamapps.application.server.PublicLinkResourceProvider;
import org.teamapps.application.server.SecureResourceHandler;
import org.teamapps.application.server.ServerData;
import org.teamapps.application.server.ServerRegistry;
import org.teamapps.application.server.ServletRegistration;
import org.teamapps.application.server.SessionHandler;
import org.teamapps.application.server.SessionManager;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.core.TeamAppsCore;
import org.teamapps.protocol.system.LoginData;
import org.teamapps.protocol.system.SystemLogEntry;
import org.teamapps.server.undertow.embedded.TeamAppsUndertowEmbeddedServer;
import org.teamapps.universaldb.DatabaseManager;
import org.teamapps.universaldb.message.MessageStore;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.servlet.resourceprovider.ClassPathResourceProvider;
import org.teamapps.ux.servlet.resourceprovider.ResourceProvider;
import org.teamapps.ux.servlet.resourceprovider.ResourceProviderServlet;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class ApplicationServer
implements WebController,
SessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ApplicationServerConfig serverConfig;
    private ServerRegistry serverRegistry;
    private List<ServletRegistration> servletRegistrations = new ArrayList<ServletRegistration>();
    private SessionHandler sessionHandler;
    private DatabaseManager databaseManager;
    private WeakHashMap<SessionHandler, Long> weakStartDateBySessionHandler = new WeakHashMap();
    private TeamAppsCore teamAppsCore;

    public ApplicationServer(ApplicationServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public ApplicationServer() {
        this.serverConfig = ApplicationServerConfig.create();
    }

    public ApplicationServer(File basePath) {
        this.serverConfig = ApplicationServerConfig.create(basePath);
    }

    public ApplicationServer(File basePath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        this.serverConfig = ApplicationServerConfig.create(basePath, teamAppsConfiguration, port);
    }

    @Override
    public SessionHandler updateSessionHandler(File jarFile) throws Exception {
        LOGGER.info("Loading new session handler:" + jarFile.getPath());
        URL resource = jarFile.toURI().toURL();
        return this.updateSessionHandler(resource);
    }

    public SessionHandler updateSessionHandler(URL resource) throws Exception {
        LOGGER.info("Loading new session handler:" + resource.getPath());
        URLClassLoader classLoader = new URLClassLoader(new URL[]{resource});
        SessionHandler newSessionHandler = this.loadSessionHandler(classLoader);
        if (newSessionHandler != null) {
            this.weakStartDateBySessionHandler.put(newSessionHandler, System.currentTimeMillis());
            if (this.serverRegistry != null) {
                newSessionHandler.init(this, this.serverRegistry);
            }
            this.sessionHandler = newSessionHandler;
            System.gc();
            LOGGER.info("Updated session handler:" + String.valueOf(this.sessionHandler));
        }
        return newSessionHandler;
    }

    @Override
    public void updateSessionHandler(SessionHandler sessionHandler) {
        this.weakStartDateBySessionHandler.put(sessionHandler, System.currentTimeMillis());
        if (this.serverRegistry != null) {
            sessionHandler.init(this, this.serverRegistry);
        }
        this.sessionHandler = sessionHandler;
        System.gc();
        LOGGER.info("Updated session handler:" + String.valueOf(sessionHandler));
    }

    private SessionHandler loadSessionHandler(URLClassLoader classLoader) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        ClassGraph classGraph = new ClassGraph();
        if (classLoader != null) {
            classGraph.overrideClassLoaders(new ClassLoader[]{classLoader});
        }
        ClassInfoList classInfos = classGraph.enableAllInfo().scan().getClassesImplementing(SessionHandler.class.getName()).getStandardClasses();
        ClassInfo bootableClassInfo = null;
        for (ClassInfo classInfo : classInfos) {
            String path2;
            if (bootableClassInfo == null) {
                bootableClassInfo = classInfo;
                continue;
            }
            String path1 = this.getInheritanceClassPath(classInfo);
            if (path1.contains(path2 = this.getInheritanceClassPath(bootableClassInfo))) {
                bootableClassInfo = classInfo;
                continue;
            }
            if (path2.contains(path1)) continue;
            bootableClassInfo = null;
            LOGGER.error("Error several implementations for SessionHandler without common inheritance");
            break;
        }
        if (bootableClassInfo == null) {
            LOGGER.info("Selecting class by annotation...");
            bootableClassInfo = classInfos.stream().sorted((o1, o2) -> Integer.compare(this.getBootPriority((ClassInfo)o2), this.getBootPriority((ClassInfo)o1))).findFirst().orElse(null);
        }
        if (bootableClassInfo != null) {
            LOGGER.info("Booting class: " + bootableClassInfo.getName() + " with priority:" + this.getBootPriority(bootableClassInfo));
            Class<?> builder = classLoader.loadClass(bootableClassInfo.getName());
            return (SessionHandler)builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        LOGGER.error("Error: no matching class found!");
        return null;
    }

    private int getBootPriority(ClassInfo classInfo) {
        AnnotationInfo bootableClass = classInfo.getAnnotationInfo("org.teamapps.application.api.annotation.TeamAppsBootableClass");
        return bootableClass != null ? (Integer)bootableClass.getParameterValues(true).getValue("priority") : 0;
    }

    private String getInheritanceClassPath(ClassInfo classInfo) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(classInfo.getName());
        for (ClassInfo superclass : classInfo.getSuperclasses()) {
            path.add(superclass.getName());
        }
        Collections.reverse(path);
        return path.stream().collect(Collectors.joining("/"));
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void onSessionStart(SessionContext context) {
        this.sessionHandler.handleSessionStart(context);
    }

    @Override
    public Collection<Long> getBootstrappedSystems() {
        return this.weakStartDateBySessionHandler.values();
    }

    public void start() throws Exception {
        if (ServerData.getServerMode() == null) {
            throw new IllegalStateException("ServerMode is null");
        }
        LOGGER.info("START TEAMAPPS.ORG APPLICATION SERVER with: \nport: {}, \nserver-mode: {}, \npaths: \n\tindex-path: {}, \n\tfull-text-path: {}, \n\ttransaction-log-path: {}, \n\tfile-store-path: {}, \n\tapp-data-path: {}, \n\tembedded-content-path: {}, \n\twebserver-path: {}, \n\ttemp-path: {}", new Object[]{this.serverConfig.getPort(), ServerData.getServerMode(), this.serverConfig.getIndexPath().toPath(), this.serverConfig.getFullTextIndexPath().toPath(), this.serverConfig.getTransactionLogPath().toPath(), this.serverConfig.getFileStorePath().toPath(), this.serverConfig.getAppDataPath().toPath(), this.serverConfig.getEmbeddedContentStorePath().toPath(), this.serverConfig.getWebserverStaticFilesPath().toPath(), this.serverConfig.getTempPath().toPath()});
        this.databaseManager = new DatabaseManager();
        MessageStore logMessageStore = MessageStore.create((File)this.serverConfig.getLogStorePath(), (String)"system-logs", SystemLogEntry.getMessageDecoder());
        DatabaseLogAppender.startLogger((MessageStore<SystemLogEntry>)logMessageStore);
        MessageStore loginDataMessageStore = MessageStore.create((File)this.serverConfig.getLogStorePath(), (String)"login-logs", LoginData.getMessageDecoder());
        TeamAppsUndertowEmbeddedServer server = new TeamAppsUndertowEmbeddedServer((WebController)this, this.serverConfig.getTeamAppsConfiguration(), this.serverConfig.getPort());
        this.teamAppsCore = server.getTeamAppsCore();
        this.serverRegistry = new ServerRegistry(this.serverConfig, this.databaseManager, (MessageStore<SystemLogEntry>)logMessageStore, (MessageStore<LoginData>)loginDataMessageStore, () -> this.weakStartDateBySessionHandler.keySet().stream().filter(Objects::nonNull).collect(Collectors.toList()), this.teamAppsCore);
        this.sessionHandler.init(this, this.serverRegistry);
        this.addClassPathResourceProvider("org.teamapps.application.server.media", "/ta-media/");
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((servletPath, relativeResourcePath, httpSessionId) -> {
            File file = new File(this.serverConfig.getWebserverStaticFilesPath(), relativeResourcePath);
            if (file.exists() && !file.isDirectory()) {
                return new FileResource(file);
            }
            return null;
        }), "/static/*"));
        for (final ServletRegistration servletRegistration : this.servletRegistrations) {
            for (final String mapping : servletRegistration.getMappings()) {
                LOGGER.info("Registering servlet on url path: " + mapping);
                server.addServletContextListener(new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        ServletRegistration.Dynamic dynamic = sce.getServletContext().addServlet("teamapps-registered-" + servletRegistration.getServlet().getClass().getSimpleName() + UUID.randomUUID().toString(), servletRegistration.getServlet());
                        dynamic.setAsyncSupported(servletRegistration.isAsyncSupported());
                        dynamic.addMapping(new String[]{mapping});
                    }
                });
            }
        }
        server.addServletContextListener(new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                ServletContext servletContext = sce.getServletContext();
                servletContext.addServlet("ta-embedded", (Servlet)new ResourceProviderServlet((ResourceProvider)new EmbeddedResourceStore(ApplicationServer.this.serverConfig.getEmbeddedContentStorePath()))).addMapping(new String[]{"/TA-EMBEDDED/*"});
                servletContext.addServlet("ta-sec-links", (Servlet)new ResourceProviderServlet((servletPath, relativeResourcePath, httpSessionId) -> SecureResourceHandler.getInstance().getResource(servletPath, relativeResourcePath, httpSessionId))).addMapping(new String[]{"/TA-SEC-PRVD/*"});
                servletContext.addServlet("ta-public-link", (Servlet)new ResourceProviderServlet((ResourceProvider)PublicLinkResourceProvider.getInstance())).addMapping(new String[]{"/pl/*"});
                servletContext.addServlet("ta-api-servlet", (Servlet)ApiServlet.getInstance()).addMapping(new String[]{"/api/*"});
            }
        });
        server.start();
    }

    public void addClassPathResourceProvider(String basePackage, String prefix) {
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((ResourceProvider)new ClassPathResourceProvider(basePackage)), (String)prefix + "*"));
    }

    public void addServletRegistration(ServletRegistration servletRegistration) {
        this.servletRegistrations.add(servletRegistration);
    }

    public TeamAppsCore getTeamAppsCore() {
        return this.teamAppsCore;
    }

    public ApplicationServerConfig getServerConfig() {
        return this.serverConfig;
    }
}

