/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teamapps.universaldb.index.filelegacy.FileUtil;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.servlet.resourceprovider.ResourceProvider;

public class EmbeddedResourceStore
implements ResourceProvider {
    public static final String RESOURCE_PREFIX = "/TA-EMBEDDED/";
    private static EmbeddedResourceStore INSTANCE;
    private final File basePath;
    private final Map<String, String> conversionMap = new ConcurrentHashMap<String, String>();

    public static EmbeddedResourceStore getInstance() {
        return INSTANCE;
    }

    public EmbeddedResourceStore(File basePath) {
        this.basePath = basePath;
        this.mapDirectoryRecursive(basePath);
        INSTANCE = this;
    }

    public String saveResource(String application, String bucket, File file) throws IOException {
        if (file == null || file.length() == 0L || this.illegalName(application) || this.illegalName(bucket)) {
            return null;
        }
        String appKey = this.mapName(application);
        String bucketKey = this.mapName(bucket);
        String fileHash = FileUtil.createFileHash((File)file);
        File storeFile = new File(this.basePath, application + "/" + bucket + "/" + fileHash);
        if (!storeFile.exists()) {
            File path = storeFile.getParentFile();
            if (!path.exists()) {
                path.mkdirs();
            }
            Files.copy(file.toPath(), storeFile.toPath(), new CopyOption[0]);
        }
        return RESOURCE_PREFIX + appKey + "/" + bucketKey + "/" + fileHash;
    }

    public Resource getResource(String servletPath, String relativeResourcePath, String httpSessionId) {
        String[] parts = relativeResourcePath.split("/");
        if (parts.length > 3) {
            String application = this.conversionMap.get(parts[1]);
            String bucket = this.conversionMap.get(parts[2]);
            String fileHash = parts[3];
            File file = new File(this.basePath, application + "/" + bucket + "/" + fileHash);
            String name = fileHash;
            if (parts.length > 4) {
                name = parts[4];
            }
            if (file.exists()) {
                return new FileResource(file, name);
            }
        }
        return null;
    }

    private void mapDirectoryRecursive(File directory) {
        if (directory.isDirectory()) {
            String name = directory.getName();
            this.mapName(name);
            for (File file : directory.listFiles()) {
                this.mapDirectoryRecursive(file);
            }
        }
    }

    private String mapName(String name) {
        if (this.conversionMap.containsKey(name)) {
            return this.conversionMap.get(name);
        }
        String hash = EmbeddedResourceStore.createHash(name).substring(0, 16);
        this.conversionMap.put(hash, name);
        this.conversionMap.put(name, hash);
        return hash;
    }

    private boolean illegalName(String name) {
        return name == null || name.isBlank() || name.contains(" ") || name.contains("/") || name.contains("\\") || name.contains("'") || name.contains("\"");
    }

    public static String createHash(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA3-256");
            return EmbeddedResourceStore.bytesToHex(digest.digest(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String bytesToHex(byte[] bytes) {
        return HexFormat.of().formatHex(bytes);
    }
}

